/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.whsybc.dc.service;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.whsybc.dc.service.receipt.HisReceiptListQryImpl;
import kd.ebg.receipt.banks.whsybc.dc.service.receipt.HisReceiptUrlGetImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    private static final String RECEIPTSEPERATOR = "_";

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)transDateStr);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(8);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDateStr + "\n");
        BankReceiptRequest req = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr("1").build();
        List<Map<String, Object>> queries = new HisReceiptListQryImpl().process(req);
        for (Map<String, Object> query : queries) {
            String url;
            StringBuilder fileName = new StringBuilder();
            String transferFlowNo = (String)query.get("transferFlowNo");
            fileName.append(accNo).append(RECEIPTSEPERATOR).append(transDateStr).append(RECEIPTSEPERATOR).append(transferFlowNo).append(".pdf");
            BankReceiptResponseEB queryResult = new HisReceiptUrlGetImpl().doBiz(BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr("1").paramsMap(query).build());
            if (Objects.isNull(queryResult.getData())) continue;
            String ds = (String)queryResult.getData();
            byte[] urlByte = Base64.getDecoder().decode(ds);
            try {
                url = new String(urlByte, "GBK");
                URL downloadUrl = new URL(url);
                String protocol = downloadUrl.getProtocol();
                logger.info("\u534f\u8bae:{}", (Object)protocol);
                if ("https".equalsIgnoreCase(protocol)) {
                    RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"HTTPS");
                } else {
                    RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"HTTP");
                }
            }
            catch (UnsupportedEncodingException | MalformedURLException e) {
                logger.error("\u89e3\u6790\u56de\u5355\u4e0b\u8f7d\u5730\u5740\u5f02\u5e38", (Throwable)e);
                throw new ReceiptException((Throwable)e);
            }
            DownloadUtils.download((String)url, (String)fileName.toString(), (String)bakFilePath);
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(fileName.toString());
            downloadListDetail.setFileLink(fileName.toString());
            result.add(downloadListDetail);
        }
        logger.info(">>>>>>>>>\u9f50\u5546\u94f6\u884c-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, result.size()});
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-whsybc-dc", (Object[])new Object[0]);
    }
}

