/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.abc.dc.service.receipt;

import java.time.LocalDate;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.abc.dc.service.receipt.AbcDcCommonConfig;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.ReceiptFileConvertUtils;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.receipt.parse.impl.AbstractFileParser;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class ABCDCFileParser
extends AbstractFileParser {
    public String getAccNo() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        AbcDcCommonConfig config = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLoginId);
        boolean isPushedFromMaster = config.getPushWay().equals("true");
        if (isPushedFromMaster) {
            return ReceiptFileConvertUtils.fixAccNoTo15Or19(this.getParsedString(2));
        }
        return ReceiptFileConvertUtils.fixAccNoTo15Or19(this.getParsedString(0));
    }

    public LocalDate getDate() {
        return LocalDateUtil.parserDate((String)this.getParsedString(1));
    }

    public String getReceiptNo() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        AbcDcCommonConfig config = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLoginId);
        boolean isPushedFromMaster = config.getPushWay().equals("true");
        String receiptNo = "";
        receiptNo = isPushedFromMaster ? this.getParsedString(3) : this.getParsedString(2);
        return receiptNo;
    }

    public String getOppAccNo() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        AbcDcCommonConfig config = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLoginId);
        boolean isPushedFromMaster = config.getPushWay().equals("true");
        String oppAccNo = "e";
        if (isPushedFromMaster && EBGStringUtils.isNotEmpty((String)(oppAccNo = this.getParsedString(4)))) {
            oppAccNo = ReceiptFileConvertUtils.fixAccNoTo15Or19(oppAccNo);
        }
        return oppAccNo;
    }

    public String getAmount() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        AbcDcCommonConfig config = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLoginId);
        boolean isPushedFromMaster = config.getPushWay().equals("true");
        String amount = "e";
        if (isPushedFromMaster) {
            amount = this.getParsedString(5);
        }
        return amount;
    }

    public String getFileSplit() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        AbcDcCommonConfig config = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLoginId);
        boolean isPushedFromMaster = config.getPushWay().equals("true");
        if (isPushedFromMaster) {
            return "_";
        }
        return "-";
    }

    public String getBankVersion() {
        return "ABC_DC";
    }
}

