/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zyb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zyb.dc.utils.GLBPacker;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Element;

public class ReceiptPrintImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptPrintImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String Reference = bankReceiptRequest.getRequestStr();
        String requestStr = ReceiptPrintImpl.receiptRequest(accNo, transDateStr, Reference);
        return requestStr;
    }

    public static String receiptRequest(String acNo, String transDate, String Reference) {
        String TrsCode = "B2EEleReceiptPrintDetailPrint";
        Element root = JDomExtUtils.createRoot((String)"Message");
        JDomUtils.addChild((Element)root, (Element)GLBPacker.getHeadPackerData(TrsCode));
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)acNo);
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)transDate);
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)transDate);
        JDomUtils.addChild((Element)body, (String)"OpType", (String)"0");
        JDomUtils.addChild((Element)body, (String)"Flag", (String)"2");
        Element seqList = JDomUtils.addChild((Element)body, (String)"SeqList");
        Element row = JDomUtils.addChild((Element)seqList, (String)"Row");
        JDomUtils.addChild((Element)row, (String)"SeqNo", (String)Reference);
        String rqstStr = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return rqstStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String rspStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        Map<String, String> receiptMap = ReceiptPrintImpl.receiptParser(rspStr);
        return BankReceiptResponseEB.success(receiptMap);
    }

    public static Map<String, String> receiptParser(String response) {
        if ("".equals(response)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"ReceiptPrintImpl_0", (String)"ebg-receipt-banks-zyb-dc", (Object[])new Object[0]));
        }
        Element root = JDomUtils.str2DocGBK((String)response).getRootElement();
        Element sys_Head = JDomUtils.getUnNullChildElement((Element)root, (String)"Sys_Head");
        String ReturnCode = JDomUtils.getUnNullChildText((Element)sys_Head, (String)"ReturnCode");
        String ReturnMsg = JDomUtils.getUnNullChildText((Element)sys_Head, (String)"ReturnMsg");
        if ("000000".equalsIgnoreCase(ReturnCode)) {
            HashMap<String, String> map = new HashMap<String, String>();
            Element Body = JDomUtils.getUnNullChildElement((Element)root, (String)"Body");
            String FileName = JDomUtils.getUnNullChildText((Element)Body, (String)"FileName");
            String FileContent = JDomUtils.getUnNullChildText((Element)Body, (String)"FileContent");
            map.put("FileName", FileName);
            map.put("FileContent", FileContent);
            return map;
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u8fd4\u56de\u7801\uff1a%s\u3002", (String)"ReceiptPrintImpl_4", (String)"ebg-receipt-banks-zyb-dc", (Object[])new Object[0]), ReturnCode) + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4fe1\u606f\uff1a%s\u3002", (String)"ReceiptPrintImpl_5", (String)"ebg-receipt-banks-zyb-dc", (Object[])new Object[0]), ReturnMsg));
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "/bte-ebte/pay/q/eleReceiptQuery";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u751f\u6210\u8bf7\u6c42\u3002", (String)"ReceiptPrintImpl_3", (String)"ebg-receipt-banks-zyb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/bte-ebte/pay/q/eleReceiptQuery").append("?userPassword=").append(RequestContextUtils.getParameter().getBankParameter("Password")).append("&SIGDATA=0&_locale=zh_CN&encryptType=2&_PrintCurrentPage='1'&_Download=pdf&_MultiReports=false&_HidePdfToolBar=false&_ForbidPdfPrint=false");
        factory.setUri(sb.toString());
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
    }
}

