/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cexim.dc.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.api.LoginImpl;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.CEXIMDCBankResponse;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.CommonPacker;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.CommonParser;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.JDomExtUtils;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class BankReceiptInfoQueryImpl
extends AbstractDetailImpl
implements IDetail {
    private int size = 100;

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "P1CCMS001";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        LoginImpl.login();
        Element root = new Element("Transaction");
        String pageNo = this.getCurrentPage();
        boolean isStartPage = Integer.toString(this.getFirstPage()).equals(pageNo);
        Element header = CommonPacker.createSystemHead(this.getBizCode(), Integer.toString(this.size), pageNo, isStartPage ? "" : (String)EBContext.getContext().getRunningParams().get("STS_TRACE_ID"));
        root.addContent((Content)header);
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element request = CommonPacker.packInfoComEntity();
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData(request, "Btch_Vchr_Blg_AccNo", bankDetailRequest.getAcnt().getAccNo());
        JDomExtUtils.addChildCDData(request, "Enqr_StDt", LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate(), (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData(request, "Enqr_CODt", LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getEndDate(), (String)"yyyyMMdd"));
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        CEXIMDCBankResponse bankResponse = CommonParser.getFrontResponse(rspStr, true);
        if (!bankResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"BankReceiptInfoQueryImpl_0", (String)"ebg-receipt-banks-cexim-dc", (Object[])new Object[0]), bankResponse.getResponseCode() + bankResponse.getResponseMessage()));
        }
        rspStr = bankResponse.getBankMsg();
        CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8c03\u7528\u56de\u5355\u67e5\u8be2\u670d\u52a1\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%s", (String)"BankReceiptInfoQueryImpl_1", (String)"ebg-receipt-banks-cexim-dc", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        EBContext.getContext().getRunningParams().put("STS_TRACE_ID", bankResp.getStsTraceId());
        this.setPageParam(bankResp.getTotalPage());
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String rcrdNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        List detaiList = response.getChildren("Hd_Grp");
        if (!"0".equalsIgnoreCase(rcrdNum)) {
            for (Element node : detaiList) {
                String DbtCrDrcCd;
                DetailInfo detailInfo = new DetailInfo();
                String VchID = JDomExtUtils.getChildText((Element)node, (String)"VchID");
                if (EBGStringUtils.isEmpty((String)VchID)) continue;
                String Cptl_Stmt_ID = JDomExtUtils.getChildText((Element)node, (String)"Cptl_Stmt_ID");
                String Pym_AccNo = JDomExtUtils.getChildText((Element)node, (String)"Pym_AccNo");
                String Dep_TxnAmt = JDomExtUtils.getChildText((Element)node, (String)"Dep_TxnAmt");
                String cdFlg = DbtCrDrcCd = JDomExtUtils.getChildText((Element)node, (String)"DbtCrDrcCd");
                if (Objects.equals(DbtCrDrcCd, PropertiesConstantsUtils.getValue((String)"CD_CREDIT"))) {
                    cdFlg = "1";
                }
                if (Objects.equals(DbtCrDrcCd, PropertiesConstantsUtils.getValue((String)"CD_DEBIT"))) {
                    cdFlg = "2";
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(node);
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                jsonObject.put("cdFlag", (Object)cdFlg);
                detailInfo.setReceiptNo(VchID);
                detailInfo.setOppAccNo(Pym_AccNo);
                detailInfo.setJson(jsonObject.toJSONString());
                detailInfo.setBankSerialNo(Cptl_Stmt_ID);
                detailInfo.setCdFlag(cdFlg);
                detailInfo.setAmount(Dep_TxnAmt);
                result.add(detailInfo);
            }
        }
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        detailResponse.setDetails(result);
        return detailResponse;
    }

    public boolean isRemoveResponseWrite() {
        return true;
    }

    private void setPageParam(String totalPageStr) {
        int totalPage;
        int currencyPage = Integer.parseInt(this.getCurrentPage());
        if (currencyPage >= (totalPage = Integer.parseInt(totalPageStr))) {
            this.setLastPage(true);
        } else {
            this.setCurrentPage(currencyPage + 1);
        }
    }

    public boolean isSupportPage() {
        return true;
    }

    public int getFirstPage() {
        return 1;
    }
}

