/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cexim.dc.service.receipt.api;

import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.cexim.dc.BankBusinessConfig;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.CEXIMDCBankResponse;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.CommonPacker;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.CommonParser;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.JDomExtUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Content;
import org.jdom2.Element;

public class LoginImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(LoginImpl.class);

    public static void login() {
        if (BankBusinessConfig.isAutoLogin()) {
            LoginImpl.doLogin();
        }
    }

    public static boolean doLogin() {
        EBContext context = EBContext.getContext();
        String key = context.getBankLoginID() + "_login";
        if (CosmicCache.contains((String)key) && StringUtils.isNotEmpty((String)CosmicCache.get((String)key))) {
            logger.info("\u7b7e\u5230\u5b58\u5728\u7f13\u5b58\uff0c\u672c\u6b21\u8df3\u8fc7\u7b7e\u5230");
            return true;
        }
        LoginImpl login = new LoginImpl();
        BankReceiptRequest bankReceiptRequest = new BankReceiptRequest();
        login.doBiz(bankReceiptRequest);
        return true;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "P1OPME001";
    }

    public String getBizDesc() {
        return "";
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element root = new Element("Transaction");
        Element headr = CommonPacker.createSystemHead(this.getBizCode());
        root.addContent((Content)headr);
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        body.addContent((Content)new Element("request"));
        logger.info("\u8fdb\u884c\u7b7e\u5230\u64cd\u4f5c");
        String req = JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
        return req;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String rsp) {
        CEXIMDCBankResponse response = CommonParser.getFrontResponse(rsp, true);
        if (!response.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38%s\u3002", (String)"LoginImpl_1", (String)"ebg-receipt-banks-cexim-dc", (Object[])new Object[0]), response.getResponseCode() + response.getResponseMessage()));
        }
        rsp = response.getBankMsg();
        CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse(rsp);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u5230\u5931\u8d25%s\u3002", (String)"LoginImpl_0", (String)"ebg-receipt-banks-cexim-dc", (Object[])new Object[0]), bankResp.getResponseCode() + bankResp.getResponseMessage()));
        }
        logger.info("\u7b7e\u5230\u64cd\u4f5c\u5b8c\u6210");
        EBContext context = EBContext.getContext();
        String key = context.getBankLoginID() + "_login";
        CosmicCache.putIfAbsentWithExpire((String)key, (String)"1", (int)7200, (TimeUnit)TimeUnit.SECONDS);
        return null;
    }
}

