/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cexim.dc.service.receipt.fetch;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.api.BankReceiptInfoQueryImpl;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.api.BankReceiptPrintApiImpl;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.CommonParser;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.FileInfoNode;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        long taskId = request.getTaskId();
        List downloadListDetailList = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        Map<String, DownloadListDetail> existMap = downloadListDetailList.stream().filter(o -> o.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()).collect(Collectors.toMap(DownloadListDetail::getFileName, o -> o));
        ArrayList<Object> result = new ArrayList<Object>(1);
        ArrayList<DownloadListDetail> needTwoReceiptList = new ArrayList<DownloadListDetail>(1);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        BankReceiptInfoQueryImpl bankReceiptInfoQuery = new BankReceiptInfoQueryImpl();
        List detailInfoList = bankReceiptInfoQuery.queryTransDetail(accNo, transDate, transDate);
        for (DetailInfo detailInfo : detailInfoList) {
            DownloadListDetail downloadListDetail;
            String oppAccNo = detailInfo.getOppAccNo();
            String VchID = detailInfo.getReceiptNo();
            String transNo = detailInfo.getBankSerialNo();
            String amount = detailInfo.getAmount();
            String cdFlag = detailInfo.getCdFlag();
            String jsonStr = detailInfo.getJson();
            String fileName = CommonParser.createFileNameByNewApi(accNo, transDate, amount, oppAccNo, transNo, cdFlag, countMap);
            if (existMap.containsKey(fileName)) {
                downloadListDetail = existMap.get(fileName);
                downloadListDetail.setReceiptJson(jsonStr);
                result.add(downloadListDetail);
                continue;
            }
            downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileLink(VchID);
            downloadListDetail.setReceiptJson(jsonStr);
            downloadListDetail.setFileName(fileName);
            needTwoReceiptList.add(downloadListDetail);
        }
        int count = 0;
        do {
            ArrayList<DownloadListDetail> downloadReceiptNos = new ArrayList<DownloadListDetail>(16);
            for (int i = 0; i < 1 && count < needTwoReceiptList.size(); ++count, ++i) {
                DownloadListDetail receiptNode = (DownloadListDetail)needTwoReceiptList.get(count);
                downloadReceiptNos.add(receiptNode);
            }
            if (downloadReceiptNos.size() == 0) continue;
            BankReceiptPrintApiImpl bankReceiptPrintApi = new BankReceiptPrintApiImpl();
            HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)1);
            paramsMap.put("downloadReceiptNos", downloadReceiptNos);
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().paramsMap((Map)paramsMap).build();
            BankReceiptResponseEB receiptResponseEB = bankReceiptPrintApi.doBiz(bankReceiptRequest);
            if (receiptResponseEB.getCode() != BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) continue;
            List fileInfoNodeList = (List)receiptResponseEB.getData();
            for (int i = 0; i < fileInfoNodeList.size(); ++i) {
                FileInfoNode receiptNode = (FileInfoNode)fileInfoNodeList.get(i);
                ((DownloadListDetail)downloadReceiptNos.get(i)).setFileLink(receiptNode.getFileName());
            }
            result.addAll(downloadReceiptNos);
        } while (count < needTwoReceiptList.size());
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

