/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bocom.dc.service.receipt.api.detail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.api.utils.BOCOM_DC_Parser;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailParser {
    public static List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) {
        return DetailParser.parseDetail(rqst, rspStr);
    }

    public static List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) {
        return DetailParser.parseDetail(rqst, rspStr);
    }

    private static List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de \uff1a%1$s\u3002", (String)"DetailParser_0", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = root.getChild("body");
        String field_num = JDomUtils.getChildTextNotNull((Element)body, (String)"field_num");
        String record_num = JDomUtils.getChildTextNotNull((Element)body, (String)"record_num");
        String serial_record = JDomUtils.getChildTextNotNull((Element)body, (String)"serial_record");
        int recordNum = Integer.parseInt(record_num);
        if (0 == recordNum) {
            return detailList;
        }
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = DetailParser.split(serial_record);
        for (int i = 1; i <= recordNum; ++i) {
            String dateStr = splits[fieldNum * i + 1];
            String detailSequence = splits[fieldNum * i + 4];
            String flowSequence = splits[fieldNum * i + 5];
            String accNo = splits[fieldNum * i + 6];
            String drcrf = splits[fieldNum * i + 8];
            String amountStr = splits[fieldNum * i + 10];
            DetailInfo detail = new DetailInfo();
            detail.setReversed1(detailSequence);
            detail.setReversed2(flowSequence);
            String fileName = accNo + "_" + dateStr + "_" + detailSequence + "_" + flowSequence + "_" + amountStr + "_" + drcrf + ".pdf";
            detail.setReversed3(fileName);
            detailList.add(detail);
        }
        return detailList;
    }

    private static String[] split(String serial_record) {
        return StringUtils.split((String)serial_record, (String)"|");
    }
}

