/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.entity;

import java.lang.reflect.Constructor;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.impl.task.BatchDownLoadTask;
import kd.ebg.receipt.business.receipt.impl.task.CreateTask;
import kd.ebg.receipt.business.receipt.impl.task.DownLoadTask;
import kd.ebg.receipt.business.receipt.impl.task.IntegrityTask;
import kd.ebg.receipt.business.receipt.impl.task.MatchTask;
import kd.ebg.receipt.business.receipt.impl.task.ReceiptUploadTask;
import kd.ebg.receipt.business.receipt.impl.task.reconciliation.ReconciliationUploadTask;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public enum HandlerType {
    CREATE("create", new MultiLangEnumBridge("\u521b\u5efa\u56de\u5355\u4efb\u52a1\u5904\u7406\u3002", "HandlerType_0", "ebg-receipt-business"), CreateTask.class.getName()),
    TODAY_CREATE("today_create", new MultiLangEnumBridge("\u5f53\u65e5\u521b\u5efa\u56de\u5355\u4efb\u52a1\u5904\u7406\u3002", "HandlerType_1", "ebg-receipt-business"), CreateTask.class.getName()),
    STATUS("status", new MultiLangEnumBridge("\u56de\u5355\u4efb\u52a1\u72b6\u6001\u5904\u7406\u3002", "HandlerType_2", "ebg-receipt-business"), null),
    DOWNLOAD("download", new MultiLangEnumBridge("\u56de\u5355\u4efb\u52a1\u4e0b\u8f7d\u5904\u7406\u3002", "HandlerType_3", "ebg-receipt-business"), DownLoadTask.class.getName()),
    BATCH_DOWNLOAD("batch_download", new MultiLangEnumBridge("\u56de\u5355\u4efb\u52a1\u4e0b\u8f7d\u5904\u7406\u3002", "HandlerType_3", "ebg-receipt-business"), BatchDownLoadTask.class.getName()),
    TODAY_DOWNLOAD("today_download", new MultiLangEnumBridge("\u5f53\u65e5\u56de\u5355\u4efb\u52a1\u4e0b\u8f7d\u5904\u7406\u3002", "HandlerType_4", "ebg-receipt-business"), DownLoadTask.class.getName()),
    INTEGRITY("integrity", new MultiLangEnumBridge("\u5b8c\u6574\u5ea6\u5904\u7406", "HandlerType_5", "ebg-receipt-business"), IntegrityTask.class.getName()),
    MATCH("match", new MultiLangEnumBridge("\u56de\u5355\u5339\u914d\u5904\u7406", "HandlerType_6", "ebg-receipt-business"), MatchTask.class.getName()),
    UPLOAD("upload", new MultiLangEnumBridge("\u56de\u5355\u6587\u4ef6\u4e0a\u4f20\u5904\u7406\u3002", "HandlerType_7", "ebg-receipt-business"), ReceiptUploadTask.class.getName()),
    RETRY("retry", new MultiLangEnumBridge("\u56de\u5355\u4efb\u52a1\u4e0b\u8f7d\u91cd\u8bd5\u3002", "HandlerType_8", "ebg-receipt-business"), null),
    CREATE_RECONCILIATION("create_reconciliation", null, kd.ebg.receipt.business.receipt.impl.task.reconciliation.CreateTask.class.getName()),
    DOWNLOAD_RECONCILIATION("download_reconciliation", null, kd.ebg.receipt.business.receipt.impl.task.reconciliation.DownLoadTask.class.getName()),
    UPLOAD_RECONCILIATION("upload_reconciliation", null, ReconciliationUploadTask.class.getName());

    public static EBGLogger logger;
    private String name;
    private MultiLangEnumBridge desc;
    private String implClass;

    private HandlerType(String var1, MultiLangEnumBridge var2, String implClass) {
        this.name = var1;
        this.desc = var2;
        this.implClass = implClass;
    }

    public String getName() {
        return this.name;
    }

    public static TaskActuator getTaskByType(ReceiptHandlerRequest request) {
        HandlerType[] handlerTypes;
        for (HandlerType handlerType : handlerTypes = HandlerType.values()) {
            if (!handlerType.getName().equals(request.getType())) continue;
            try {
                Class<?> cls = Class.forName(handlerType.implClass);
                Constructor<?> constructor = cls.getConstructor(ReceiptHandlerRequest.class);
                TaskActuator taskActuator = (TaskActuator)((Object)constructor.newInstance(request));
                return taskActuator;
            }
            catch (Throwable e) {
                logger.monitorError("ebg-HandlerType#getTaskByType-error" + e.getMessage(), e);
            }
        }
        return null;
    }

    static {
        logger = EBGLogger.getInstance().getLogger(HandlerType.class);
    }
}

