/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.framework;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.receipt.business.receipt.entity.ScheduleParameterEnum;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.slf4j.MDC;

public abstract class ScheduleHanlder {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ScheduleHanlder.class);
    protected String name;
    protected ScheduleHanlder nextHandler;
    protected Map<String, Object> paramsMap;
    private List<BankListEntity> bankListEntities;
    private List<BankLogin> bankLoginList;
    private Map<String, List<BankAcnt>> acntListMapByBankLogin;
    private Map<String, List<DownloadListTask>> downloadListTasksOfDownload;
    private Map<String, List<DownloadListTask>> downloadListTasksOfIntegrity;
    private Map<String, List<DownloadListTask>> downloadListTasksOfMatch;
    private Map<String, List<DownloadListTask>> downloadListTasksOfUpload;
    private Map<String, List<ReconciliationInfo>> reconciliationTaskListTasksOfUpload;

    public ScheduleHanlder(String name) {
        this.name = name;
    }

    public boolean preJob() {
        return true;
    }

    public boolean afterJob() {
        return true;
    }

    public List<BankListEntity> getBankListEntities() {
        if (this.bankListEntities == null) {
            String customId = RequestContext.get().getTenantId();
            BankVersionService bankVersionService = BankVersionService.getInstance();
            this.bankListEntities = bankVersionService.findByCustomId(customId);
        }
        return this.bankListEntities;
    }

    public List<BankLogin> getBankLoginList() {
        if (this.bankLoginList == null) {
            String customId = RequestContext.get().getTenantId();
            BankLoginService bankLoginService = BankLoginService.getInstance();
            this.bankLoginList = bankLoginService.getNotDeleteByCustomId(customId);
        }
        return this.bankLoginList;
    }

    public List<BankAcnt> getAcntsListByBankLogin(String bankVersionId, String bankLoginId) {
        String cacheName = String.format("%s", bankVersionId);
        if (this.acntListMapByBankLogin != null && this.acntListMapByBankLogin.containsKey(cacheName)) {
            List<BankAcnt> acntList = this.acntListMapByBankLogin.get(cacheName);
            List<BankAcnt> result = acntList.stream().filter(o -> Objects.equals(o.getBankLoginId(), bankLoginId)).collect(Collectors.toList());
            return result;
        }
        if (this.acntListMapByBankLogin == null) {
            this.acntListMapByBankLogin = Maps.newHashMapWithExpectedSize((int)1);
        }
        String customId = RequestContext.get().getTenantId();
        BankAcntService bankAcntService = BankAcntService.getInstance();
        List bankAcntList = bankAcntService.selectReconciliationByCustomIdAndBankVersion(customId, bankVersionId);
        List<BankAcnt> result = bankAcntList.stream().filter(o -> Objects.equals(o.getBankLoginId(), bankLoginId)).collect(Collectors.toList());
        this.acntListMapByBankLogin.put(cacheName, bankAcntList);
        return result;
    }

    public List<DownloadListTask> getDownloadListTasksOfDownload(String bankVersion, String bankLogin, List<BankAcnt> acnts) {
        Map<String, String> accNoMap = acnts.stream().filter(o -> o != null && EBGStringUtils.isNotEmpty((String)o.getAccNo())).collect(Collectors.toMap(item -> item.getAccNo(), item -> item.getAccNo()));
        String cacheName = String.format("%s", bankVersion);
        if (this.downloadListTasksOfDownload != null && this.downloadListTasksOfDownload.containsKey(cacheName)) {
            List<DownloadListTask> downloadListTasks = this.downloadListTasksOfDownload.get(cacheName);
            List<DownloadListTask> result = downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && o.getBankLoginId().equals(bankLogin)).collect(Collectors.toList());
            return result;
        }
        if (this.downloadListTasksOfDownload == null) {
            this.downloadListTasksOfDownload = Maps.newHashMapWithExpectedSize((int)1);
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>(16);
        statusList.add(TaskStatus.CREATE.getId());
        statusList.add(TaskStatus.COMPLETED.getId());
        String customId = RequestContext.get().getTenantId();
        DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        List downloadListTasks = downloadTaskService.findByCustomIdAndStatusListAndBankVersion(customId, statusList, bankVersion);
        this.downloadListTasksOfDownload.put(cacheName, downloadListTasks);
        List<DownloadListTask> result = downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && o.getBankLoginId().equals(bankLogin)).collect(Collectors.toList());
        return result;
    }

    public List<DownloadListTask> getDownloadListTasksOfIntegrity(String bankVersion, String bankLogin, List<BankAcnt> acnts) {
        Map<String, String> accNoMap = acnts.stream().filter(o -> o != null && EBGStringUtils.isNotEmpty((String)o.getAccNo())).collect(Collectors.toMap(item -> item.getAccNo(), item -> item.getAccNo()));
        String cacheName = String.format("%s", bankVersion);
        if (this.downloadListTasksOfIntegrity != null && this.downloadListTasksOfIntegrity.containsKey(cacheName)) {
            List<DownloadListTask> downloadListTasks = this.downloadListTasksOfIntegrity.get(cacheName);
            List<DownloadListTask> result = downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && o.getBankLoginId().equals(bankLogin)).collect(Collectors.toList());
            return result;
        }
        if (this.downloadListTasksOfIntegrity == null) {
            this.downloadListTasksOfIntegrity = Maps.newHashMapWithExpectedSize((int)1);
        }
        String customId = RequestContext.get().getTenantId();
        ArrayList<Integer> statusList = new ArrayList<Integer>(16);
        statusList.add(TaskStatus.DOWNLOADED.getId());
        statusList.add(TaskStatus.CHECKING.getId());
        DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        List downloadListTasks = downloadTaskService.findByCustomIdAndStatusListAndBankVersion(customId, statusList, bankVersion);
        this.downloadListTasksOfIntegrity.put(cacheName, downloadListTasks);
        List<DownloadListTask> result = downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && o.getBankLoginId().equals(bankLogin)).collect(Collectors.toList());
        return result;
    }

    public List<DownloadListTask> getDownloadListTasksOfMatch(String bankVersion, String bankLogin, List<BankAcnt> acnts) {
        Map<String, String> accNoMap = acnts.stream().filter(o -> o != null && EBGStringUtils.isNotEmpty((String)o.getAccNo())).collect(Collectors.toMap(item -> item.getAccNo(), item -> item.getAccNo()));
        String cacheName = String.format("%s", bankVersion);
        if (this.downloadListTasksOfMatch != null && this.downloadListTasksOfMatch.containsKey(cacheName)) {
            List<DownloadListTask> downloadListTasks = this.downloadListTasksOfMatch.get(cacheName);
            List<DownloadListTask> result = downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && o.getBankLoginId().equals(bankLogin)).collect(Collectors.toList());
            return result;
        }
        if (this.downloadListTasksOfMatch == null) {
            this.downloadListTasksOfMatch = Maps.newHashMapWithExpectedSize((int)1);
        }
        String customId = RequestContext.get().getTenantId();
        ArrayList<Integer> statusList = new ArrayList<Integer>(16);
        statusList.add(TaskStatus.CHECKED.getId());
        statusList.add(TaskStatus.MATCHING.getId());
        DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        List downloadListTasks = downloadTaskService.findByCustomIdAndStatusListAndBankVersion(customId, statusList, bankVersion);
        this.downloadListTasksOfMatch.put(cacheName, downloadListTasks);
        List<DownloadListTask> result = downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && o.getBankLoginId().equals(bankLogin)).collect(Collectors.toList());
        return result;
    }

    public List<DownloadListTask> getDownloadListTasksOfUpload(String bankVersion, String bankLoginId, LocalDate transDate, List<BankAcnt> acnts) {
        Map<String, String> accNoMap = acnts.stream().filter(o -> o != null && EBGStringUtils.isNotEmpty((String)o.getAccNo())).collect(Collectors.toMap(item -> item.getAccNo(), item -> item.getAccNo()));
        String cacheName = String.format("%s", bankVersion);
        if (this.downloadListTasksOfUpload != null && this.downloadListTasksOfUpload.containsKey(cacheName)) {
            List<DownloadListTask> downloadListTasks = this.downloadListTasksOfUpload.get(cacheName);
            List<DownloadListTask> result = downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && Objects.equals(o.getBankLoginId(), bankLoginId)).collect(Collectors.toList());
            return result;
        }
        if (this.downloadListTasksOfUpload == null) {
            this.downloadListTasksOfUpload = Maps.newHashMapWithExpectedSize((int)1);
        }
        String customId = RequestContext.get().getTenantId();
        DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        List downloadListTasks = downloadTaskService.findUnUploadCompleteTaskByBankAndCustomId(customId, bankVersion, transDate, null);
        this.downloadListTasksOfUpload.put(cacheName, downloadListTasks);
        List<DownloadListTask> result = downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && Objects.equals(o.getBankLoginId(), bankLoginId)).collect(Collectors.toList());
        return result;
    }

    public List<ReconciliationInfo> getReconciliationListTasksOfUpload(String bankVersion, String bankLoginId, LocalDate transDate, List<BankAcnt> acnts, boolean isAccNoOfReconciliationByBank) {
        Map<String, String> accNoMap = acnts.stream().filter(o -> o != null && EBGStringUtils.isNotEmpty((String)o.getAccNo())).collect(Collectors.toMap(item -> item.getAccNo(), item -> item.getAccNo()));
        String cacheName = String.format("%s", bankVersion);
        if (this.reconciliationTaskListTasksOfUpload != null && this.reconciliationTaskListTasksOfUpload.containsKey(cacheName)) {
            List<ReconciliationInfo> downloadListTasks = this.reconciliationTaskListTasksOfUpload.get(cacheName);
            List<Object> result = isAccNoOfReconciliationByBank ? downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && Objects.equals(o.getBankLoginId(), bankLoginId)).collect(Collectors.toList()) : downloadListTasks.stream().filter(o -> Objects.equals(o.getBankLoginId(), bankLoginId)).collect(Collectors.toList());
            return result;
        }
        if (this.reconciliationTaskListTasksOfUpload == null) {
            this.reconciliationTaskListTasksOfUpload = Maps.newHashMapWithExpectedSize((int)1);
        }
        String customId = RequestContext.get().getTenantId();
        ReconciliationDownloadTaskService reconciliationDownloadTaskService = (ReconciliationDownloadTaskService)SpringContextUtil.getBean(ReconciliationDownloadTaskService.class);
        List downloadListTasks = reconciliationDownloadTaskService.findUnUploadCompleteTaskByBankVersionAndCustomId(customId, bankVersion, transDate, null);
        this.reconciliationTaskListTasksOfUpload.put(cacheName, downloadListTasks);
        List<Object> result = isAccNoOfReconciliationByBank ? downloadListTasks.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && Objects.equals(o.getBankLoginId(), bankLoginId)).collect(Collectors.toList()) : downloadListTasks.stream().filter(o -> Objects.equals(o.getBankLoginId(), bankLoginId)).collect(Collectors.toList());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        long startTime;
        block8: {
            startTime = System.currentTimeMillis();
            try {
                if (!this.preJob()) break block8;
                try {
                    long endTime1 = System.currentTimeMillis();
                    logger.monitorInfo("ebg-receiptSchedule-{}-preJob\uff1a{} ms", new Object[]{this.name, endTime1 - startTime});
                    this.subProcess();
                }
                catch (Throwable endTime1) {
                    // empty catch block
                }
                try {
                    long endTime2 = System.currentTimeMillis();
                    logger.monitorInfo("ebg-receiptSchedule-{}-subProcess\uff1a{} ms", new Object[]{this.name, endTime2 - startTime});
                    this.afterJob();
                    long endTime3 = System.currentTimeMillis();
                    logger.monitorInfo("ebg-receiptSchedule-{}-afterJob\uff1a{} ms", new Object[]{this.name, endTime3 - startTime});
                }
                catch (Throwable endTime2) {
                    // empty catch block
                }
                if (this.nextHandler != null) {
                    this.nextHandler.process();
                }
            }
            finally {
                this.acntListMapByBankLogin = null;
                this.bankListEntities = null;
                this.bankLoginList = null;
                this.downloadListTasksOfDownload = null;
                this.downloadListTasksOfIntegrity = null;
                this.downloadListTasksOfMatch = null;
                this.downloadListTasksOfUpload = null;
                this.reconciliationTaskListTasksOfUpload = null;
            }
        }
        long endTime = System.currentTimeMillis();
        logger.monitorInfo("ebg-receiptSchedule-{}-total\uff1a{} ms", new Object[]{this.name, endTime - startTime});
    }

    public abstract void subProcess();

    public void setNextHandler(ScheduleHanlder handler) {
        this.nextHandler = handler;
    }

    public void MDC_Schedule() {
        MDC.put((String)"schedule", (String)"true");
    }

    public Map<String, Object> getParamsMap() {
        return this.paramsMap;
    }

    public void setParamsMap(Map<String, Object> paramsMap) {
        this.paramsMap = paramsMap;
    }

    public boolean isNeedExecuteOfBank(String bankVersion) {
        try {
            String executeBankVersions = (String)this.paramsMap.get(ScheduleParameterEnum.EXECUTE_BANK_VERSION.getName());
            String unExecuteBankVersions = (String)this.paramsMap.get(ScheduleParameterEnum.UN_EXECUTE_BANK_VERSION.getName());
            String split_char = ",";
            if (EBGStringUtils.isNotEmpty((String)executeBankVersions)) {
                String[] bankVersions = executeBankVersions.split(split_char);
                List<String> bankVersionList = Arrays.asList(bankVersions);
                return bankVersionList.contains(bankVersion);
            }
            if (EBGStringUtils.isNotEmpty((String)unExecuteBankVersions)) {
                String[] bankVersions = unExecuteBankVersions.split(split_char);
                List<String> bankVersionList = Arrays.asList(bankVersions);
                return !bankVersionList.contains(bankVersion);
            }
        }
        catch (Throwable e) {
            logger.monitorError("isNeedExecuteOfBank:error" + e.getMessage(), e);
        }
        return true;
    }
}

