/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.task;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.defect.ReceiptDefectTypeEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.repository.DetailInfoRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.slf4j.MDC;

public class MatchTask
extends TaskActuator {
    EBGLogger logger = EBGLogger.getInstance().getLogger(MatchTask.class);
    private DownloadTaskService downloadTaskService;
    private DownloadListDetailService downloadListDetailService;
    private DetailInfoRepository detailInfoRepository;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public MatchTask(ReceiptHandlerRequest request) {
        super(request);
    }

    @Override
    public boolean preTask() {
        String cacheKey = String.format("upload_key_%s_%s", RequestContext.get().getAccountId(), Long.toString(this.receiptHandlerRequest.getTaskId()));
        String value = CosmicCache.get((String)cacheKey);
        if (StringUtils.isNotEmpty((String)value) && Objects.equals(value, "uploading")) {
            return false;
        }
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        this.detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String customId = this.receiptHandlerRequest.getCustomId();
        String batchNo = this.receiptHandlerRequest.getBatchSeqId();
        long taskId = this.receiptHandlerRequest.getTaskId();
        String transDate = this.receiptHandlerRequest.getTransDate();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).bankLoginID(bankLoginId).bankVersionID(bankVersionId).logBizSeqID(taskId + "").logRequestSeqID(taskId + "").bizName("receipt").build());
        MDC.put((String)"bankVersion", (String)bankVersionId);
        MDC.put((String)"transDate", (String)transDate);
        String accNo = this.receiptHandlerRequest.getAccNo();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(accNo);
        EBContext.getContext().setBankAcnt(bankAcnt);
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        if (downloadListTask.getStatus().intValue() == TaskStatus.CHECKED.getId()) {
            this.updateTaskStatus(downloadListTask, TaskStatus.MATCHING.getId());
        }
        EBContext.getContext().setType("match");
        return true;
    }

    @Override
    public boolean afterTask() {
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u5339\u914d\u56de\u5355\u4efb\u52a1-\u4fee\u6539\u56de\u5355\u4fe1\u606f");
        String transDateStr = this.receiptHandlerRequest.getTransDate();
        LocalDate transDate = LocalDateUtil.parserDate((String)transDateStr);
        ReceiptCommonAipUtil.handleReceiptInfo((String)this.receiptHandlerRequest.getCustomId(), (String)this.receiptHandlerRequest.getBankVersion(), (String)this.receiptHandlerRequest.getBatchSeqId(), (LocalDate)transDate);
        long taskId = this.receiptHandlerRequest.getTaskId();
        List downloadListDetailList = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        int matchCount = (int)downloadListDetailList.stream().filter(o -> o.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId()).count();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        downloadListTask.setMatchNum(Integer.valueOf(matchCount));
        downloadListTask.setReceiptNum(Integer.valueOf(downloadListDetailList.size()));
        this.updateTaskStatus(downloadListTask, TaskStatus.FINISH.getId());
        MDC.remove((String)"bankVersion");
        MDC.remove((String)"type");
        EBContext.destroy();
        return true;
    }

    public void updateTaskStatus(DownloadListTask task, Integer status) {
        task.setStatus(status);
        task.setCompleteTime(LocalDateTime.now());
        this.downloadTaskService.update(task);
    }

    public void updateTaskDetailStatus(DownloadListDetail detail, Integer status) {
        detail.setStatus(status);
        detail.setCompleteTime(LocalDateTime.now());
        this.downloadListDetailService.update(detail);
    }

    @Override
    public void subProcess() {
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u5339\u914d\u56de\u5355\u4efb\u52a1");
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String accNo = this.receiptHandlerRequest.getAccNo();
        long taskId = this.receiptHandlerRequest.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        LocalDate transDate = downloadListTask.getTransDate();
        this.logger.info("\u5339\u914d\u56de\u5355\u4efb\u52a1\u5f00\u59cb-{}-{}", new Object[]{accNo, transDate});
        List downloadListDetailList = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        List detailInfoList = this.detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionId, transDate, transDate);
        this.logger.info("\u5339\u914d\u56de\u5355\u4efb\u52a1-{}-{}-\u660e\u7ec6\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, detailInfoList.size()});
        HashMap detailInfoMap = Maps.newHashMapWithExpectedSize((int)detailInfoList.size());
        detailInfoList.forEach(o -> detailInfoMap.put(o.getReceiptNo(), o));
        List yesterdayDetails = this.detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionId, transDate.minusDays(1L), transDate.minusDays(1L));
        this.logger.info("\u5339\u914d\u56de\u5355\u4efb\u52a1-{}-{}-\u660e\u7ec6\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, detailInfoList.size()});
        HashMap yesterdayDetailInfoMap = Maps.newHashMapWithExpectedSize((int)detailInfoList.size());
        yesterdayDetails.forEach(o -> yesterdayDetailInfoMap.put(o.getReceiptNo(), o));
        downloadListTask.setTxDetailNum(Integer.valueOf(detailInfoList.size()));
        downloadListTask.setReceiptNum(Integer.valueOf(downloadListDetailList.size()));
        int successCount = 0;
        ArrayList<Long> deleteIds = new ArrayList<Long>(1);
        for (DownloadListDetail detail : downloadListDetailList) {
            boolean isDailyCut;
            String receiptNo = detail.getDetailNo();
            String currentReceiptNo = detail.getDetailNo();
            String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
            String yesterdayDateStr = LocalDateUtil.formatDate((LocalDate)transDate.minusDays(1L));
            String againReceiptNo = receiptNo.replace(String.format("-%s-", transDateStr), String.format("-%s-", yesterdayDateStr));
            boolean bl = isDailyCut = yesterdayDetailInfoMap.containsKey(againReceiptNo) && !detailInfoMap.containsKey(receiptNo);
            if (isDailyCut) {
                receiptNo = againReceiptNo;
            }
            if (detailInfoMap.containsKey(receiptNo) || isDailyCut) {
                detail.setMatchFlag(Integer.valueOf(MatchStatusEnum.SUCCESS.getId()));
                DetailInfo detailInfo = (DetailInfo)detailInfoMap.get(receiptNo);
                if (isDailyCut && detailInfo == null) {
                    detailInfo = (DetailInfo)yesterdayDetailInfoMap.get(againReceiptNo);
                }
                detail.setDetailId(detailInfo.getId());
                ++successCount;
                deleteIds.add(detail.getId());
                if (isDailyCut && detailInfo != null) {
                    detail.setMatchFlag(Integer.valueOf(MatchStatusEnum.SUCCESS.getId()));
                    detail.setDetailNo(againReceiptNo);
                }
            } else {
                this.logger.info("\u56de\u5355\u8bb0\u5f55id:{}-accNo:{}-\u56de\u5355\u65e5\u671f\uff1a{} \u5339\u914d\u4ea4\u6613\u660e\u7ec6\u5931\u8d25", new Object[]{detail.getId(), detail.getAccNo(), detail.getTransDate()});
                detail.setMatchFlag(Integer.valueOf(MatchStatusEnum.FAIL.getId()));
            }
            try {
                this.updateTaskDetailStatus(detail, TaskStatus.FINISH.getId());
            }
            catch (Throwable e) {
                if (!isDailyCut) continue;
                detail.setDetailNo(currentReceiptNo);
                detail.setMatchFlag(Integer.valueOf(MatchStatusEnum.FAIL.getId()));
                this.updateTaskDetailStatus(detail, TaskStatus.FINISH.getId());
            }
        }
        this.receiptInfoJsonService.deleteByDetailIdList(deleteIds);
        if (detailInfoList.size() > downloadListDetailList.size()) {
            downloadListTask.setDefectType(ReceiptDefectTypeEnum.PUSH_DEFECT_RECEIPT.getCode());
        }
        downloadListTask.setRedo(Integer.valueOf(0));
        if (!Objects.equals(downloadListTask.getDefectType(), ReceiptDefectTypeEnum.PUSH_DEFECT_RECEIPT.getCode())) {
            downloadListTask.setDefectType(ReceiptDefectTypeEnum.FINISH.getCode());
        }
        this.updateTaskStatus(downloadListTask, TaskStatus.FINISH.getId());
        if (successCount != downloadListDetailList.size()) {
            this.logger.info("\u56de\u5355\u4efb\u52a1id:{}-accNo:{}-\u56de\u5355\u65e5\u671f\uff1a{} \u5b58\u5728\u90e8\u5206\u4ea4\u6613\u660e\u7ec6\u672a\u5339\u914d\u4e0a", new Object[]{taskId, accNo, transDate});
        } else {
            this.logger.info("\u56de\u5355\u4efb\u52a1id:{}-accNo:{}-\u56de\u5355\u65e5\u671f\uff1a{} \u5339\u914d\u6210\u529f", new Object[]{taskId, accNo, transDate});
        }
    }

    @Override
    public boolean match() {
        return HandlerType.MATCH.getName().equals(this.receiptHandlerRequest.getType());
    }
}

