/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.utils.FrontConnectTest;
import kd.ebg.receipt.common.constant.monitor.ConnectMonitorStatusEnum;
import kd.ebg.receipt.common.constant.monitor.ReceiptPushWayEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptExceptionUtil;
import kd.ebg.receipt.common.model.monitor.ReceiptConnectMonitorInfo;
import kd.ebg.receipt.common.model.receipt.EBConfig;
import kd.ebg.receipt.common.model.repository.monitor.ReceiptConnectMonitorRepository;
import kd.ebg.receipt.common.model.repository.receipt.EBConfigRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptDownloadConnectMonitorUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDownloadConnectMonitorUtils.class);

    public ReceiptConnectMonitorRepository getReceiptConnectMonitorRepository() {
        return (ReceiptConnectMonitorRepository)SpringContextUtil.getBean(ReceiptConnectMonitorRepository.class);
    }

    public EBConfigRepository getEbConfigRepository() {
        return (EBConfigRepository)SpringContextUtil.getBean(EBConfigRepository.class);
    }

    public BankLoginRepository getBankLoginRepository() {
        return BankLoginRepository.getInstance();
    }

    public void testFrontConnect(String ip, String port, Long id) {
        this.testFrontConnect(ip, port, id, true);
    }

    public void testFrontConnect(String ip, String port, Long id, boolean isDelete) {
        String customNo = RequestContext.get().getTenantId();
        if (id != null) {
            List frontProxyIpConfigList = this.getEbConfigRepository().findReceiptConfigByConfigIdAndValue(customNo, "front_proxy_ip", ip);
            List frontProxyPortConfigList = this.getEbConfigRepository().findReceiptConfigByConfigIdAndValue(customNo, "front_proxy_port", port);
            if (frontProxyIpConfigList.isEmpty() || frontProxyPortConfigList.isEmpty()) {
                if (id != null) {
                    if (isDelete) {
                        this.getReceiptConnectMonitorRepository().deleteById(id);
                    } else {
                        throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u6761\u8bb0\u5f55\u6240\u5bf9\u5e94\u7684ip\u548c\u7aef\u53e3\u672a\u88ab\u56de\u5355\u524d\u7f6e\u673a\u914d\u7f6e\u5f15\u7528\u3002", (String)"ReceiptDownloadConnectMonitorUtils_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
                    }
                }
                return;
            }
            JSONObject jsonObject = this.getIntersectionByList(frontProxyIpConfigList, frontProxyPortConfigList);
            if (jsonObject == null) {
                if (id != null) {
                    if (isDelete) {
                        this.getReceiptConnectMonitorRepository().deleteById(id);
                    } else {
                        throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u6761\u8bb0\u5f55\u6240\u5bf9\u5e94\u7684ip\u548c\u7aef\u53e3\u672a\u88ab\u56de\u5355\u524d\u7f6e\u673a\u914d\u7f6e\u5f15\u7528\u3002", (String)"ReceiptDownloadConnectMonitorUtils_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
                    }
                }
                return;
            }
            String bankLoginId = jsonObject.getString("bankLogin");
            String bankVersionId = jsonObject.getString("bankVersion");
            EBContext.getContext().setBankLoginID(bankLoginId);
            EBContext.getContext().setBankVersionID(bankVersionId);
        }
        EBContext.getContext().setCustomID(customNo);
        EBContext.initParameter();
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("name", "");
        paramsMap.put("frontProxyPath", "");
        BankReceiptRequest request = BankReceiptRequest.builder().paramsMap(paramsMap).build();
        HashMap runningParam = Maps.newHashMapWithExpectedSize((int)2);
        runningParam.put("front_proxy_ip", ip);
        runningParam.put("front_proxy_port", port);
        EBContext.getContext().setRunningParams((Map)runningParam);
        FrontConnectTest iBankReceipt = new FrontConnectTest();
        try {
            iBankReceipt.doBiz(request);
            this.updateConnectMonitorTime(ReceiptPushWayEnum.BANK_LOGIN.getCode(), ip, port, ConnectMonitorStatusEnum.SUCCESS.getCode(), null);
        }
        catch (Exception e) {
            this.updateConnectMonitorTime(ReceiptPushWayEnum.BANK_LOGIN.getCode(), ip, port, ConnectMonitorStatusEnum.FAIL.getCode(), e);
            throw new ReceiptException((Throwable)e);
        }
    }

    public void updateConnectMonitorTime(String way, String ip, String port, String monitorStatus, Exception e) {
        ReceiptConnectMonitorInfo receiptConnectMonitorInfo = this.getReceiptConnectMonitorRepository().findInfoByWayAndIpAndPort(way, ip, port);
        if (receiptConnectMonitorInfo != null) {
            receiptConnectMonitorInfo.setMonitor_status(monitorStatus);
            if (e != null) {
                receiptConnectMonitorInfo.setError_msg(ReceiptExceptionUtil.formatException((Throwable)e, (int)400));
            } else {
                receiptConnectMonitorInfo.setError_msg("");
            }
            receiptConnectMonitorInfo.setMonitor_time(LocalDateTime.now());
            this.getReceiptConnectMonitorRepository().update(receiptConnectMonitorInfo);
        }
    }

    public void testSftpConnect(String ip, int port, String username, String cipher, String ftpCertPath) throws Exception {
        try {
            ChannelSftp channelSftp = this.connect(ip, port, username, cipher, ftpCertPath);
            channelSftp.getSession().disconnect();
            channelSftp.disconnect();
            this.updateConnectMonitorTime(ReceiptPushWayEnum.SFTP.getCode(), ip, port + "", ConnectMonitorStatusEnum.SUCCESS.getCode(), null);
        }
        catch (Exception e) {
            this.updateConnectMonitorTime(ReceiptPushWayEnum.SFTP.getCode(), ip, port + "", ConnectMonitorStatusEnum.FAIL.getCode(), e);
            throw new ReceiptException((Throwable)e);
        }
    }

    public ChannelSftp connect(String host, int port, String username, String ftpPassword, String ftpCertPath) throws Exception {
        ChannelSftp sftp = null;
        try {
            JSch jsch = new JSch();
            logger.info("\u51c6\u5907\u5efa\u7acbFTP\u8fde\u63a5\u3002");
            if (!EBGStringUtils.isEmpty((String)ftpCertPath)) {
                jsch.addIdentity(ftpCertPath);
            }
            Session session = jsch.getSession(username, host, port);
            session.setTimeout(5000);
            Properties config = new Properties();
            config.setProperty("StrictHostKeyChecking", "no");
            session.setConfig(config);
            if (!EBGStringUtils.isEmpty((String)ftpPassword)) {
                session.setPassword(ftpPassword);
            }
            session.connect();
            Channel channel = session.openChannel("sftp");
            channel.connect(5000);
            sftp = (ChannelSftp)channel;
            logger.info("Connected to " + host + ".");
        }
        catch (Exception e) {
            logger.error("\u5efa\u7acbFTP\u8fde\u63a5\u51fa\u9519\u3002", (Throwable)e);
            throw e;
        }
        return sftp;
    }

    public void testConnect(Long id) {
        this.testConnect(id, true);
    }

    public void testConnect(Long id, boolean isNeedDelete) {
        ReceiptConnectMonitorInfo receiptConnectMonitorInfo = this.getReceiptConnectMonitorRepository().findById(id.longValue());
        receiptConnectMonitorInfo.setMonitor_time(LocalDateTime.now());
        receiptConnectMonitorInfo.setMonitor_status(ConnectMonitorStatusEnum.SUCCESS.getCode());
        receiptConnectMonitorInfo.setError_msg("");
        String pushWay = receiptConnectMonitorInfo.getReceipt_way();
        String ip = receiptConnectMonitorInfo.getIp();
        int port = Integer.parseInt(receiptConnectMonitorInfo.getPort());
        if (Objects.equals(pushWay, ReceiptPushWayEnum.BANK_LOGIN.getCode())) {
            try {
                EBContext ebContext = EBContext.builder().customID(RequestContext.get().getTenantId()).build();
                EBContext.setContext((EBContext)ebContext);
                this.testFrontConnect(ip, receiptConnectMonitorInfo.getPort(), id, isNeedDelete);
            }
            catch (Throwable e) {
                String errorMsg = e.getMessage();
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u524d\u7f6e\u673a\u4ee3\u7406\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5IP\u7aef\u53e3\u662f\u5426\u586b\u5199\u6b63\u786e\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u901a\u7545\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"ReceiptDownloadConnectMonitorUtils_1", (String)"ebg-receipt-business", (Object[])new Object[0]), errorMsg), (Throwable)e);
            }
        }
        if (Objects.equals(pushWay, ReceiptPushWayEnum.SFTP.getCode())) {
            String username = receiptConnectMonitorInfo.getUser();
            String cipher = receiptConnectMonitorInfo.getCipher();
            String ftpCertPath = receiptConnectMonitorInfo.getPrivate_cert_path();
            try {
                if (isNeedDelete) {
                    this.isMeetConditionDelete(id);
                    this.getReceiptConnectMonitorRepository().deleteById(id);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.testSftpConnect(ip, port, username, cipher, ftpCertPath);
            }
            catch (Throwable e1) {
                String errorMsg = e1.getMessage();
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0csftp\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5IP\u3001\u7aef\u53e3\u3001\u7528\u6237\u540d\u548c\u5bc6\u7801\u662f\u5426\u586b\u5199\u6b63\u786e\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u901a\u7545\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"ReceiptDownloadConnectMonitorUtils_2", (String)"ebg-receipt-business", (Object[])new Object[0]), errorMsg), (Throwable)e1);
            }
        }
    }

    public void isMeetConditionDelete(Long id) {
        JSONObject jsonObject;
        ReceiptConnectMonitorInfo receiptConnectMonitorInfo = this.getReceiptConnectMonitorRepository().findById(id.longValue());
        receiptConnectMonitorInfo.setMonitor_time(LocalDateTime.now());
        receiptConnectMonitorInfo.setMonitor_status(ConnectMonitorStatusEnum.SUCCESS.getCode());
        receiptConnectMonitorInfo.setError_msg("");
        String ip = receiptConnectMonitorInfo.getIp();
        String port = receiptConnectMonitorInfo.getPort();
        String customNo = RequestContext.get().getTenantId();
        List<EBConfig> frontProxyIpConfigList = new ArrayList(16);
        List frontProxyPortConfigList = new ArrayList(16);
        if (Objects.equals(receiptConnectMonitorInfo.getReceipt_way(), ReceiptPushWayEnum.SFTP.getCode())) {
            frontProxyIpConfigList = this.getEbConfigRepository().findReceiptConfigByConfigIdAndValue(customNo, "bank_ftp_ip", ip);
            frontProxyPortConfigList = this.getEbConfigRepository().findReceiptConfigByConfigIdAndValue(customNo, "bank_ftp_port", port);
            List userList = this.getEbConfigRepository().findReceiptConfigByConfigIdAndValue(customNo, "ftp_user_name", receiptConnectMonitorInfo.getUser());
            if (userList.size() == 0) {
                return;
            }
            if (frontProxyIpConfigList.size() > 0 && frontProxyPortConfigList.size() > 0) {
                HashMap frontProxyIpConfigMap = Maps.newHashMapWithExpectedSize((int)16);
                frontProxyIpConfigList.forEach(o -> frontProxyIpConfigMap.put(o.getBankLoginID(), o));
                HashMap frontProxyPortConfigMap = Maps.newHashMapWithExpectedSize((int)16);
                frontProxyPortConfigList.forEach(o -> frontProxyPortConfigMap.put(o.getBankLoginID(), o));
                int usedCount = 0;
                for (EBConfig e : userList) {
                    String bankLoginId = e.getBankLoginID();
                    if (!frontProxyIpConfigMap.containsKey(bankLoginId) || !frontProxyPortConfigMap.containsKey(bankLoginId)) continue;
                    ++usedCount;
                }
                if (usedCount == 0) {
                    return;
                }
            }
        }
        if (Objects.equals(receiptConnectMonitorInfo.getReceipt_way(), ReceiptPushWayEnum.BANK_LOGIN.getCode())) {
            frontProxyIpConfigList = this.getEbConfigRepository().findReceiptConfigByConfigIdAndValue(customNo, "front_proxy_ip", ip);
            frontProxyPortConfigList = this.getEbConfigRepository().findReceiptConfigByConfigIdAndValue(customNo, "front_proxy_port", port);
        }
        if (!frontProxyIpConfigList.isEmpty() && !frontProxyPortConfigList.isEmpty() && (jsonObject = this.getIntersectionByList(frontProxyIpConfigList, frontProxyPortConfigList)) != null) {
            StringBuilder errorMsg = new StringBuilder();
            String bankLoginId = jsonObject.getString("bankLogin");
            errorMsg.append("ip\uff1a").append(ip).append(ResManager.loadKDString((String)"\u7aef\u53e3\uff1a", (String)"ReceiptDownloadConnectMonitorUtils_3", (String)"ebg-receipt-business", (Object[])new Object[0])).append(port).append(ResManager.loadKDString((String)"\u5df2\u7ecf\u88ab", (String)"ReceiptDownloadConnectMonitorUtils_4", (String)"ebg-receipt-business", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u524d\u7f6e\u673a", (String)"ReceiptDownloadConnectMonitorUtils_5", (String)"ebg-receipt-business", (Object[])new Object[0])).append(bankLoginId).append(ResManager.loadKDString((String)"\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664", (String)"ReceiptDownloadConnectMonitorUtils_6", (String)"ebg-receipt-business", (Object[])new Object[0]));
            throw new ReceiptException(errorMsg.toString());
        }
    }

    public JSONObject getIntersectionByList(List<EBConfig> frontProxyIpConfigList, List<EBConfig> frontProxyPortConfigList) {
        BankLoginKey key = new BankLoginKey();
        key.setCustomId(RequestContext.get().getTenantId());
        for (EBConfig config : frontProxyIpConfigList) {
            String bankVersion = config.getBankVersionID();
            String bankLogin = config.getBankLoginID();
            for (EBConfig portConfig : frontProxyPortConfigList) {
                if (!Objects.equals(bankVersion, portConfig.getBankVersionID()) || !Objects.equals(bankLogin, portConfig.getBankLoginID())) continue;
                key.setBankLoginId(bankLogin);
                if (this.getBankLoginRepository().findEnableBankLogin(key) == null) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("bankVersion", (Object)bankVersion);
                jsonObject.put("bankLogin", (Object)bankLogin);
                return jsonObject;
            }
        }
        return null;
    }
}

