/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.common;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.receipt.formplugin.service.info.InfoService;

public class EbgAddBankListPlugin
extends AbstractTreeListPlugin {
    private static final String ENTITY_KEY_BANK = "aqap_bank";
    private static final String ENTITY_KEY_BANK_LIST = "aqap_bank_list";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        TreeListModel model = (TreeListModel)this.getTreeListView().getTreeModel();
        model.getQueryParas().put("order", "sort_num asc, number asc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"add_bank", (CharSequence)formOperate.getOperateKey())) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)ENTITY_KEY_BANK_LIST, (boolean)true, (int)0, (boolean)true);
            StyleCss style = new StyleCss();
            style.setWidth("1000");
            style.setHeight("600");
            listShowParameter.getOpenStyle().setInlineStyleCss(style);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u65b0\u589e\u542f\u7528", (String)"EbgAddBankListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectCollections = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            Map<String, DynamicObject> map = this.getAvailableBankVersionMap();
            Map<String, String> bankNameMap = this.getBankNameMap();
            for (ListSelectedRow row : selectCollections) {
                String number = row.getNumber();
                String name = row.getName();
                String bankName = bankNameMap.get(number);
                DynamicObject bankVersionData = map.get(number);
                if (bankVersionData != null) {
                    if ("1".equals(bankVersionData.get("enable")) && "C".equals(bankVersionData.get("status"))) continue;
                    this.update(bankVersionData, number, name, bankName);
                    continue;
                }
                this.save(number, name, bankName);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    DynamicObjectCollection getAvailableBankVersionDatas() {
        QFilter qFilter = QFilter.of((String)"status=? and enable=?", (Object[])new Object[]{"C", "1"});
        return QueryServiceHelper.query((String)ENTITY_KEY_BANK, (String)"id, number, name, bank_name, status, enable", (QFilter[])qFilter.toArray());
    }

    Map<String, DynamicObject> getAvailableBankVersionMap() {
        DynamicObjectCollection bankVersionDatas = this.getAvailableBankVersionDatas();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        bankVersionDatas.stream().forEach(bankVersionData -> map.put((String)bankVersionData.get("number"), (DynamicObject)bankVersionData));
        return map;
    }

    Map<String, String> getBankNameMap() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        List<BankVersionInfo> bankVersionInfos = this.infoService.getBankVersionInfoList();
        bankVersionInfos.stream().forEach(bankVersionInfo -> map.put(bankVersionInfo.getBankVersionID(), bankVersionInfo.getBankName()));
        return map;
    }

    void save(String number, String name, String bankName) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_BANK);
        dataEntity.set("status", (Object)"C");
        dataEntity.set("enable", (Object)"1");
        dataEntity.set("number", (Object)number);
        dataEntity.set("name", (Object)name);
        dataEntity.set("bank_name", (Object)bankName);
        SaveServiceHelper.saveOperate((String)ENTITY_KEY_BANK, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
    }

    void update(DynamicObject bankVersionData, String number, String name, String bankName) {
        bankVersionData.set("number", (Object)number);
        bankVersionData.set("name", (Object)name);
        bankVersionData.set("status", (Object)"C");
        bankVersionData.set("enable", (Object)"1");
        bankVersionData.set("bank_name", (Object)bankName);
        SaveServiceHelper.save((IDataEntityType)bankVersionData.getDataEntityType(), (Object[])new DynamicObject[]{bankVersionData});
    }
}

