/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import org.apache.commons.lang3.StringUtils;

public class ReceiptTaskStatisticsPlugin
extends AbstractFormPlugin {
    private BankVersionService bankVersionService = BankVersionService.getInstance();
    private int runing_task_num = 0;
    private int success_task_num = 0;
    private int fail_task_num = 0;
    private int task_num_count = 0;
    private int receipt_acnt_count = 0;

    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        this.showData();
    }

    private void fillDefaultValue() {
        String transDateStr = this.getFromParentPageCache("trans_date");
        if (StringUtils.isNotBlank((CharSequence)transDateStr)) {
            this.getModel().setValue("trans_date", (Object)new Date(Long.parseLong(transDateStr)));
        } else {
            Date today = new Date();
            Date transDate = DateUtil.getLastDay((Date)today, (int)1);
            this.getModel().setValue("trans_date", (Object)transDate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("trans_date".equals(key)) {
            Date date = (Date)this.getModel().getValue(key);
            if (date != null) {
                this.putIntoParentPageCache(key, String.valueOf(date.getTime()));
            }
            this.showData();
        }
    }

    private void showData() {
        this.loadData(this.getTransDate());
        Label label1 = (Label)this.getControl("runing_task_num");
        label1.setText(this.runing_task_num + "");
        Label label2 = (Label)this.getControl("success_task_num");
        label2.setText(this.success_task_num + "");
        Label label3 = (Label)this.getControl("fail_task_num");
        label3.setText(this.fail_task_num + "");
        Label label4 = (Label)this.getControl("task_num_count");
        label4.setText(this.task_num_count + "");
        Label label5 = (Label)this.getControl("receipt_acnt_count");
        label5.setText(this.receipt_acnt_count + "");
    }

    private void loadData(Date transDate) {
        String customId = RequestContext.get().getTenantId();
        List<Long> bankVersionIds = this.getAllEnableBankVersionIds(customId);
        if (CollectionUtils.isEmpty(bankVersionIds)) {
            return;
        }
        QFilter[] qFilters = new QFilter[4];
        qFilters[0] = new QFilter("custom_id", "=", (Object)customId);
        qFilters[1] = new QFilter("bank_version.id", "in", bankVersionIds);
        qFilters[2] = QFilter.of((String)"trans_date>= ? and trans_date<=?", (Object[])new Object[]{LocalDateUtil.getFirstTimeByDate((Date)transDate), LocalDateUtil.getLastTimeByDate((Date)transDate)});
        DynamicObjectCollection taskNumResult = QueryServiceHelper.query((String)"receipt_info", (String)"sum(receipt_acnt_num) as receipt_acnt_count, sum(task_num) as task_num_count", (QFilter[])qFilters);
        int successStatus = TaskStatus.FINISH.getId();
        int failStatus = TaskStatus.FAILED.getId();
        DynamicObjectCollection statusNumResult = QueryServiceHelper.query((String)"receipt_download_task", (String)("sum(case when status='" + successStatus + "' then 1 else 0 end) as success_task_num,  sum(case when status='" + failStatus + "'  then 1 else 0 end) as fail_task_num,  sum(case when (status != '" + successStatus + "' and status != '" + failStatus + "') then 1 else 0 end) as runing_task_num"), (QFilter[])qFilters);
        if (!CollectionUtils.isEmpty((Collection)taskNumResult)) {
            this.task_num_count = ((DynamicObject)taskNumResult.get(0)).getInt("task_num_count");
            this.receipt_acnt_count = ((DynamicObject)taskNumResult.get(0)).getInt("receipt_acnt_count");
        }
        if (!CollectionUtils.isEmpty((Collection)statusNumResult)) {
            this.success_task_num = ((DynamicObject)statusNumResult.get(0)).getInt("success_task_num");
            this.fail_task_num = ((DynamicObject)statusNumResult.get(0)).getInt("fail_task_num");
            this.runing_task_num = ((DynamicObject)statusNumResult.get(0)).getInt("runing_task_num");
        }
    }

    private List<Long> getAllEnableBankVersionIds(String customId) {
        List bankVersionList = this.bankVersionService.findByCustomId(customId);
        if (CollectionUtils.isEmpty((Collection)bankVersionList)) {
            return null;
        }
        ArrayList<Long> bankVersionIdList = new ArrayList<Long>(16);
        for (BankListEntity bankListEntity : bankVersionList) {
            bankVersionIdList.add(Long.parseLong(bankListEntity.getId()));
        }
        return bankVersionIdList;
    }

    private Date getTransDate() {
        Date transDate = (Date)this.getModel().getValue("trans_date");
        if (transDate == null) {
            Date today = new Date();
            transDate = DateUtil.getLastDay((Date)today, (int)1);
        }
        return transDate;
    }

    private String getFromParentPageCache(String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            return pageCache.get(((Object)((Object)this)).getClass().getSimpleName() + "-" + key);
        }
        return null;
    }

    private void putIntoParentPageCache(String key, String value) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put(((Object)((Object)this)).getClass().getSimpleName() + "-" + key, value);
        }
    }
}

