/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.paramsconfig;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.upload.UploadOption;
import kd.bos.util.ConfigurationUtil;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.model.bank.ShowByFieldAndVal;
import kd.ebg.egf.common.utils.AESUtil;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.receipt.business.receipt.utils.ReceiptDownloadConnectMonitorUtils;
import kd.ebg.receipt.common.constant.monitor.ReceiptPushWayEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.monitor.ReceiptConnectMonitorService;
import kd.ebg.receipt.common.model.repository.UserCertRepository;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.PrivateCertUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.constant.OperateLogType;
import kd.ebg.receipt.formplugin.plugin.paramsconfig.JumpRemoteFilter;
import kd.ebg.receipt.formplugin.pojo.bizinfo.BankLoginInfo;
import kd.ebg.receipt.formplugin.pojo.receipt.InterceptorResultInfo;
import kd.ebg.receipt.formplugin.repository.EbcBankLoginRepository;
import kd.ebg.receipt.formplugin.repository.EbcBankVersionRepository;
import kd.ebg.receipt.formplugin.service.info.InfoService;
import kd.ebg.receipt.formplugin.util.FieldType;
import kd.ebg.receipt.formplugin.util.FieldUtil;
import kd.ebg.receipt.formplugin.util.OperateLogUtils;
import kd.ebg.receipt.formplugin.util.StringUtil;
import kd.ebg.receipt.formplugin.util.StringUtils;

public class ReceiptBankLoginFormPlugin
extends AbstractBillPlugIn
implements ClickListener,
UploadListener {
    private static final String ENTITY_KEY = "aqap_bank_login_config";
    private static final String CONTAINER_KEY_CONTAINER = "conentpanel";
    private static final String TEST_CONNECT_BUTTON = "testconnect";
    private static final String TEST_CONNECT_OPERATION_KEY = "test_connect";
    private static final String OPEN_REMOTE_KEY = "open_remote";
    private static final String REMOTE_BUTTON = "remote";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private EbcBankLoginRepository ebcBankLoginRepository = (EbcBankLoginRepository)SpringContextUtil.getBean(EbcBankLoginRepository.class);
    private EbcBankVersionRepository ebcBankVersionRepository = (EbcBankVersionRepository)SpringContextUtil.getBean(EbcBankVersionRepository.class);
    private BankLoginConfigService bankLoginConfigService = BankLoginConfigService.getInstance();
    private UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
    private ReceiptConnectMonitorService receiptConnectMonitorService = (ReceiptConnectMonitorService)SpringContextUtil.getBean(ReceiptConnectMonitorService.class);
    private static final String cipher = "******";
    private static final String cacheKeyPre = "password_";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptBankLoginFormPlugin.class);
    private static final String ATTACHMENTPANELKEY = "attachmentPanelKey";
    private static final String UPLOAD_FILED_NAME_MAP_KEY = "upload_filed_name_map_key";

    public void propertyChanged(PropertyChangedArgs e) {
        String bankVersion;
        String fieldValue;
        String fieldKey = e.getProperty().getName();
        this.isShowOrHideByConfig();
        if (StringUtils.equals("receipt_achieve_way", fieldKey)) {
            this.setFieldShowOrHide();
        }
        if (StringUtils.equals("pushWay", fieldKey)) {
            this.setFieldShowOrHideWhithPush();
        }
        if (StringUtils.equals("receipt_push_channel", fieldKey)) {
            this.setFieldShowOrHideWhithPush();
        }
        if (StringUtils.equals("receipt_download_way", fieldKey)) {
            this.setFieldShowOrHideByFieldKey(fieldKey, "false", new String[]{"filereceivepath"});
        }
        if (StringUtils.equals("ccipPushMode", fieldKey)) {
            this.setFieldShowOrHideByFieldKey(fieldKey, "true", new String[]{"receipt_achieveway_config"});
            fieldValue = (String)this.getModel().getValue(fieldKey);
            if (Objects.equals(fieldValue, "false")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TEST_CONNECT_BUTTON});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{REMOTE_BUTTON});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TEST_CONNECT_BUTTON});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{REMOTE_BUTTON});
            }
        }
        if (StringUtils.equals("is_active_push", fieldKey)) {
            this.setFieldShowOrHideByFieldKey(fieldKey, "true", new String[]{"receipt_user_no"});
        }
        if (StringUtils.equals("receipt_proxy_download_switch", fieldKey)) {
            this.setFieldShowOrHideByFieldKey(fieldKey, "true", new String[]{"receipt_proxy_file_port"});
        }
        if (StringUtils.equals("isSupportReconciliation", fieldKey) && (bankVersion = this.getBankVersion()).equals("ICBC_OPA")) {
            this.setFieldShowOrHideByFieldKey("isSupportReconciliation", "true", new String[]{"reconciliation_path"});
        }
        if (StringUtils.equals("is_url_download", fieldKey)) {
            this.setFieldShowOrHideByFieldKey("is_url_download", "false", new String[]{"receipt_achieveway_config"});
            fieldValue = (String)this.getModel().getValue(fieldKey);
            if (Objects.equals(fieldValue, "true")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TEST_CONNECT_BUTTON});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{REMOTE_BUTTON});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TEST_CONNECT_BUTTON});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{REMOTE_BUTTON});
            }
        }
        if (StringUtils.equals("bocom_receipt_way_choose", fieldKey)) {
            this.setFieldShowOrHideByFieldKey(fieldKey, "bank_proxy", new String[]{"receipt_achieveway_config", TEST_CONNECT_BUTTON, REMOTE_BUTTON});
        }
    }

    public void setFieldShowOrHide() {
        String receiptAchieveWay = "";
        try {
            receiptAchieveWay = (String)this.getModel().getValue("receipt_achieve_way");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("bank_login".equals(receiptAchieveWay)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bank_ftp_ip", "btn_ftp_cert_path", "bank_ftp_port", "ftp_path", "ftp_user_name", "ftp_password", "ftp_cert_path"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"front_proxy_ip", "front_proxy_port", "front_proxy_path"});
        } else if ("sftp".equals(receiptAchieveWay)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bank_ftp_ip", "btn_ftp_cert_path", "bank_ftp_port", "ftp_path", "ftp_user_name", "ftp_password", "ftp_cert_path"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"front_proxy_ip", "front_proxy_port", "front_proxy_path"});
        }
    }

    public void isShowOrHideByConfig() {
        List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(this.getBankVersion());
        List newBankLoginInfos = bankLoginInfos.stream().filter(b -> b.getShowByFieldAndVal() != null).collect(Collectors.toList());
        if (newBankLoginInfos != null) {
            for (BankLoginInfo bankLoginInfo : newBankLoginInfos) {
                String val = "";
                try {
                    ShowByFieldAndVal showByFieldAndVal = bankLoginInfo.getShowByFieldAndVal();
                    val = (String)this.getModel().getValue(showByFieldAndVal.getFieldName());
                    String showVal = showByFieldAndVal.getFieldVal();
                    this.getView().setVisible(Boolean.valueOf(val.equalsIgnoreCase(showVal)), new String[]{bankLoginInfo.getBankConfigId().toLowerCase(Locale.ENGLISH)});
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void setFieldShowOrHideByFieldKey(String fieldKey, String shownByValue, String[] showFieldKeys) {
        try {
            String fieldValue = (String)this.getModel().getValue(fieldKey);
            if (Objects.equals(shownByValue, fieldValue)) {
                this.getView().setVisible(Boolean.valueOf(true), showFieldKeys);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), showFieldKeys);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setFieldShowOrHideWhithPush() {
        String bankVersion = this.getBankVersion();
        String pushWay = "";
        try {
            pushWay = (String)this.getModel().getValue("pushWay");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Objects.equals("SPDB_DC", bankVersion)) {
            if (Objects.equals(pushWay, "API")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bisignip", "bisignport", "bisafeip", "bisafefileport", "bisafetesttime"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MetaDataConfigType.RECEIPT_ACHIEVEWAY_CONFIG.getName()});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TEST_CONNECT_BUTTON});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{REMOTE_BUTTON});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bisignip", "bisignport", "bisafeip", "bisafefileport", "bisafetesttime"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{MetaDataConfigType.RECEIPT_ACHIEVEWAY_CONFIG.getName()});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TEST_CONNECT_BUTTON});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{REMOTE_BUTTON});
            }
        }
        if (!this.showTestConnectButton(bankVersion)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TEST_CONNECT_BUTTON});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REMOTE_BUTTON});
        }
        if (Objects.equals("HFB_DC", bankVersion)) {
            try {
                String receipt_push_channel = (String)this.getModel().getValue("receipt_push_channel");
                if (Objects.equals("JS", receipt_push_channel)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"receipt_ip", "receipt_port", "receipt_proxy_ip", "receipt_proxy_port", "sign_cipher", "receipt_uri"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"receipt_ip", "receipt_port", "receipt_proxy_ip", "receipt_proxy_port", "sign_cipher", "receipt_uri"});
                }
            }
            catch (Exception receipt_push_channel) {
                // empty catch block
            }
        }
        if (Objects.equals("BOC_NET", bankVersion)) {
            this.setFieldShowOrHideByFieldKey("is_active_push", "true", new String[]{"receipt_user_no"});
        }
        if (bankVersion.equals("ICBC_OPA")) {
            this.setFieldShowOrHideByFieldKey("isSupportReconciliation", "true", new String[]{"reconciliation_path"});
            this.setFieldShowOrHideByFieldKey("is_support_today_receipt", "true", new String[]{"receipt_channel_no"});
        }
        this.setFieldShowOrHideByFieldKey("ccipPushMode", "true", new String[]{"receipt_achieveway_config", TEST_CONNECT_BUTTON, REMOTE_BUTTON});
        this.setFieldShowOrHideByFieldKey("receipt_proxy_download_switch", "true", new String[]{"receipt_proxy_file_port"});
        if (bankVersion.equals("TLYH_DC")) {
            this.setFieldShowOrHideByFieldKey("is_url_download", "false", new String[]{"receipt_achieveway_config"});
            String fieldValue = (String)this.getModel().getValue("is_url_download");
            if (Objects.equals(fieldValue, "true")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TEST_CONNECT_BUTTON});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{REMOTE_BUTTON});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TEST_CONNECT_BUTTON});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{REMOTE_BUTTON});
            }
        }
        if (StringUtils.equals(bankVersion, "BOCOM_DC")) {
            this.setFieldShowOrHideByFieldKey("bocom_receipt_way_choose", "bank_proxy", new String[]{"receipt_achieveway_config", TEST_CONNECT_BUTTON, REMOTE_BUTTON});
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        this.createDynamicPanel();
        this.getPageCache().put("hasAddToContainer", "true");
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("BankLoginFormPlugin", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        String bankVersion = this.getBankVersion();
        DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"aqap_bank", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankVersion)});
        String bankVersionName = (String)data.get("name.zh_CN");
        List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(this.getBankVersion());
        bankLoginInfos.stream().forEach(bankLoginInfo -> {
            if (StringUtils.isNotEmpty(bankLoginInfo.getBankConfigValue())) {
                this.getModel().getDataEntity().set(bankLoginInfo.getBankConfigId(), (Object)bankLoginInfo.getBankConfigValue());
            }
        });
        this.getModel().setValue("custom_id", (Object)RequestContext.get().getTenantId());
        Integer maxVersionValue = (Integer)this.getView().getFormShowParameter().getCustomParam("maxVersionValue");
        if (maxVersionValue == null) {
            maxVersionValue = this.bankLoginConfigService.getMaxVersionValue(bankVersion, RequestContext.get().getTenantId());
        }
        this.getModel().getDataEntity().set("number", (Object)(bankVersion + "-" + maxVersionValue));
        this.getModel().getDataEntity().set("name", (Object)(bankVersionName + maxVersionValue));
        this.getModel().getDataEntity().set("group", (Object)data);
        this.setFieldShowOrHide();
        this.setFieldShowOrHideWhithPush();
        this.isShowOrHideByConfig();
    }

    public void afterLoadData(EventObject e) {
        String bankLogin = (String)this.getModel().getValue("number");
        if (StringUtils.isNotEmpty(bankLogin)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)bankLogin), new QFilter("config_type", "=", (Object)"receipt")};
            DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_KEY, (String)"id, bank_config_id, bank_config_value", (QFilter[])qFilters);
            if (datas.size() > 0) {
                HashSet dbDataSet = new HashSet(1);
                datas.stream().forEach(data -> {
                    String configid = data.getString("bank_config_id");
                    String value = data.getString("bank_config_value");
                    String cacheKey = cacheKeyPre + configid;
                    if (this.getView().getPageCache().get(cacheKey) != null) {
                        this.getView().getPageCache().put(cacheKey, value);
                        value = cipher;
                    }
                    try {
                        this.getModel().getDataEntity().set(configid, (Object)value);
                        dbDataSet.add(configid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.getBankLoginInfoList(this.getBankVersion()).stream().forEach(bankLoginInfo -> {
                        if (!dbDataSet.contains(bankLoginInfo.getBankConfigId()) && StringUtils.isNotEmpty(bankLoginInfo.getBankConfigValue())) {
                            this.getModel().getDataEntity().set(bankLoginInfo.getBankConfigId(), (Object)bankLoginInfo.getBankConfigValue());
                        }
                    });
                });
            } else {
                List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(this.getBankVersion());
                bankLoginInfos.stream().forEach(bankLoginInfo -> {
                    if (StringUtils.isNotEmpty(bankLoginInfo.getBankConfigValue())) {
                        this.getModel().getDataEntity().set(bankLoginInfo.getBankConfigId(), (Object)bankLoginInfo.getBankConfigValue());
                    }
                });
            }
        }
        this.setFieldShowOrHide();
        this.setFieldShowOrHideWhithPush();
        this.isShowOrHideByConfig();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String bankVersion = this.getBankVersion();
        List<FlexPanelAp> flexPanelApList = this.createDynamicPanel();
        Container myFldPanel = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        flexPanelApList.stream().forEach(fieldsetPanelAp -> {
            myFldPanel.getItems().addAll(((Container)fieldsetPanelAp.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(myFldPanel.getItems());
        });
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(this.getBankVersion());
        bankLoginInfos.stream().forEach(bankLoginInfo -> {
            if (StringUtils.equals(bankLoginInfo.getBankConfigId().toLowerCase(Locale.ENGLISH), e.getKey()) || StringUtils.equals("btn_" + bankLoginInfo.getBankConfigId().toLowerCase(Locale.ENGLISH), e.getKey())) {
                if ("upload".equals(bankLoginInfo.getInputType()) && e.getKey().startsWith("btn_")) {
                    Button button = new Button();
                    button.setKey("btn_" + bankLoginInfo.getBankConfigId());
                    button.setOperationKey("upload");
                    button.setView(this.getView());
                    e.setControl((Control)button);
                } else {
                    String key = bankLoginInfo.getBankConfigId();
                    if (Objects.equals(bankLoginInfo.getInputType(), ConfigInputType.PASSWORD.getInputType())) {
                        key = key.toUpperCase(Locale.ENGLISH);
                    }
                    TextEdit textEdit = new TextEdit();
                    textEdit.setKey(key);
                    textEdit.setView(this.getView());
                    e.setControl((Control)textEdit);
                }
                return;
            }
        });
    }

    public String getBankVersion() {
        if (this.getView() == null) {
            return "";
        }
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if ("ADDNEW".equals(baseShowParameter.getStatus().name())) {
            JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("tree_parent_id");
            if (jsonObject == null) {
                return (String)baseShowParameter.getCustomParam("bankVersion");
            }
            return this.getBankVersion(jsonObject);
        }
        Long bankLoginid = (Long)baseShowParameter.getPkId();
        return this.ebcBankLoginRepository.getBankVersionByBankLoginID(bankLoginid);
    }

    public String getBankVersion(JSONObject jsonObject) {
        String groupKey = jsonObject.getString("value");
        return this.ebcBankVersionRepository.getBankVersionByID(groupKey);
    }

    private List<FlexPanelAp> createDynamicPanel() {
        ArrayList<FlexPanelAp> result = new ArrayList<FlexPanelAp>(16);
        String hasAddToContainer = this.getPageCache().get("hasAddToContainer");
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(this.getBankVersion());
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        bankLoginInfos.stream().forEach(bankLoginInfo -> {
            String type = bankLoginInfo.getType() == null ? "default" : bankLoginInfo.getType();
            ArrayList<BankLoginInfo> bankLoginInfoList = (ArrayList<BankLoginInfo>)map.get(type);
            if (bankLoginInfoList == null) {
                bankLoginInfoList = new ArrayList<BankLoginInfo>(16);
                map.put(type, bankLoginInfoList);
            }
            bankLoginInfoList.add((BankLoginInfo)bankLoginInfo);
        });
        Container container = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        for (Map.Entry entry : map.entrySet()) {
            String type = (String)entry.getKey();
            FlexPanelAp flex = this.createFlexPanelAp(type);
            this.addFieldsetPanelApItems(flex, (List)map.get(type));
            if (hasAddToContainer == null) {
                ArrayList<Map> array = new ArrayList<Map>(16);
                array.add(flex.createControl());
                container.addControls(array);
            }
            result.add(flex);
        }
        return result;
    }

    List<BankLoginInfo> getBankLoginInfoList(String bankVersion) {
        return this.infoService.getBankLoginInfoList(bankVersion).stream().filter(c -> "receipt".equals(MetaDataConfigType.getTypeByName((String)c.getType()))).collect(Collectors.toList());
    }

    public FlexPanelAp createFlexPanelAp(String type) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(type);
        flex.setCollapsible(true);
        flex.setName(new LocaleString("default".equals(type) ? ResManager.loadKDString((String)"\u57fa\u7840\u914d\u7f6e", (String)"ReceiptBankLoginFormPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]) : MetaDataConfigType.getDescByName((String)type)));
        flex.setGrow(1);
        flex.setShrink(0);
        Style style = new Style();
        Border border = new Border();
        border.setTop("10px #E2E7EF solid");
        style.setBorder(border);
        flex.setStyle(style);
        return flex;
    }

    public void addFieldsetPanelApItems(FlexPanelAp flex, List<BankLoginInfo> bankLoginInfos) {
        for (BankLoginInfo bankLoginInfo : bankLoginInfos) {
            FieldAp fieldAp;
            String key = bankLoginInfo.getBankConfigId();
            boolean isPassword = false;
            String name = FieldUtil.getName(bankLoginInfo.getMlBankConfigName(), bankLoginInfo.getBankConfigName());
            String desc = FieldUtil.getDesc(bankLoginInfo.getMlDesc(), bankLoginInfo.getDesc());
            List<String> sourceNames = FieldUtil.getSourceNames(bankLoginInfo.getMlSourceNames(), bankLoginInfo.getSourceNames());
            if (ConfigInputType.SELECT.getInputType().equals(bankLoginInfo.getInputType())) {
                fieldAp = FieldUtil.createComboField(name, bankLoginInfo.getBankConfigId(), bankLoginInfo.isReadOnly(), !bankLoginInfo.isNullable(), desc, bankLoginInfo.getSourceValues(), sourceNames);
                flex.getItems().add(fieldAp);
                continue;
            }
            if (ConfigInputType.INTEGER.getInputType().equals(bankLoginInfo.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, bankLoginInfo.getBankConfigId(), !bankLoginInfo.isNullable(), bankLoginInfo.isReadOnly(), FieldType.INTEGER, desc);
                FieldUtil.setIntegerFieldApDataScope(fieldAp, bankLoginInfo.getMinValueNum(), bankLoginInfo.getMaxValueNum());
                flex.getItems().add(fieldAp);
                continue;
            }
            if (ConfigInputType.PASSWORD.getInputType().equals(bankLoginInfo.getInputType())) {
                isPassword = true;
                String cacheKey = cacheKeyPre + bankLoginInfo.getBankConfigId();
                if (StringUtils.isEmpty(this.getView().getPageCache().get(cacheKey))) {
                    this.getView().getPageCache().put(cacheKey, "");
                }
                key = key.toUpperCase(Locale.ENGLISH);
            }
            fieldAp = FieldUtil.createTextField(name, key, bankLoginInfo.isReadOnly(), !bankLoginInfo.isNullable(), desc, isPassword);
            FieldUtil.setFieldApMaxLength((TextField)fieldAp.getField(), bankLoginInfo.getMaxLength());
            flex.getItems().add(fieldAp);
            if (!ConfigInputType.UPLOAD.getInputType().equals(bankLoginInfo.getInputType())) continue;
            ButtonAp buttonAp = FieldUtil.createButtonAp(key);
            flex.getItems().add(buttonAp);
        }
    }

    private TextProp buildTextPorp(String key, String name, boolean isPassword) {
        TextProp textProp = new TextProp();
        textProp.setName(key);
        textProp.setDisplayName(new LocaleString(name));
        if (isPassword) {
            textProp.setPassword(true);
        }
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(this.getBankVersion());
        bankLoginInfos.stream().forEach(bankLoginInfo -> {
            String key = bankLoginInfo.getBankConfigId();
            boolean isPassword = false;
            if (Objects.equals(bankLoginInfo.getInputType(), ConfigInputType.PASSWORD.getInputType())) {
                key = key.toUpperCase(Locale.ENGLISH);
                isPassword = true;
            }
            TextProp textProp = this.buildTextPorp(key, bankLoginInfo.getBankConfigName(), isPassword);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        List<String> attachmentPanelKeys = this.getAttachmentPanelKey();
        attachmentPanelKeys.stream().forEach(key -> {
            Button button = (Button)this.getView().getControl(key);
            if (button != null) {
                button.addClickListener((ClickListener)this);
                button.addUploadListener((UploadListener)this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        InterceptorResultInfo interceptor;
        String port;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        IDataModel model = this.getModel();
        String bankLogin = (String)model.getValue("number");
        String bankVersion = (String)model.getDataEntity().get("group.number");
        if (StringUtils.equals(TEST_CONNECT_OPERATION_KEY, formOperate.getOperateKey())) {
            String pushWay = (String)model.getDataEntity().get("receipt_achieve_way");
            ReceiptDownloadConnectMonitorUtils receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
            String pushWayCode = ReceiptPushWayEnum.getEnumByDesc((String)pushWay).getCode();
            if (Objects.equals(pushWayCode, ReceiptPushWayEnum.BANK_LOGIN.getCode())) {
                try {
                    EBContext ebContext = EBContext.builder().customID(RequestContext.get().getTenantId()).bankLoginID(bankLogin).bankVersionID(bankVersion).build();
                    EBContext.setContext((EBContext)ebContext);
                    String ip = (String)model.getDataEntity().get("front_proxy_ip");
                    port = (String)model.getDataEntity().get("front_proxy_port");
                    receiptDownloadConnectMonitorUtils.testFrontConnect(ip, port, null);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"ReceiptBankLoginFormPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(kd.ebg.egf.common.utils.string.StringUtils.norm((String)String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u524d\u7f6e\u673a\u4ee3\u7406\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5IP\u7aef\u53e3\u662f\u5426\u586b\u5199\u6b63\u786e\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u901a\u7545\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"ReceiptBankLoginFormPlugin_5", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), e.getMessage())));
                }
                finally {
                    EBContext.destroy();
                }
            }
            if (Objects.equals(pushWayCode, ReceiptPushWayEnum.SFTP.getCode())) {
                try {
                    String ip = (String)model.getDataEntity().get("bank_ftp_ip");
                    String port2 = (String)model.getDataEntity().get("bank_ftp_port");
                    String user = (String)model.getDataEntity().get("ftp_user_name");
                    String value = (String)model.getDataEntity().get("ftp_password");
                    value = cipher.equals(value) ? this.getView().getPageCache().get("password_ftp_password") : AESUtil.encrypt((String)value);
                    String certPath = (String)model.getDataEntity().get("ftp_cert_path");
                    value = AESUtil.unencryptedDesEncrypt((String)value, null);
                    String bankLoginId = bankLogin;
                    String privateFilePath = certPath;
                    String fileName = bankLoginId + "_private.ppk";
                    StringBuilder filePath = new StringBuilder();
                    String storageRootPath = FileCommonUtils.checkPath((String)ConfigurationUtil.getString((String)"user.dir"));
                    filePath.append(storageRootPath).append(File.separator).append("receipt").append(File.separator).append(RequestContext.get().getAccountId());
                    filePath.append(File.separator).append(bankLoginId);
                    filePath.append(File.separator).append("private");
                    String filePathPre = filePath.toString();
                    StringBuilder fullPrivateFilePathBuilder = new StringBuilder(filePathPre).append(File.separator).append(fileName);
                    String fullPrivateFilePath = fullPrivateFilePathBuilder.toString();
                    File decodeFile = FileCommonUtils.getFileByPath((String)fullPrivateFilePath);
                    if (decodeFile.exists()) {
                        boolean isDelete = decodeFile.delete();
                        logger.info("\u6587\u4ef6-{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{decodeFile.getName(), isDelete});
                    }
                    certPath = PrivateCertUtils.getPrivatePath((String)"ftp_cert_path", (String)bankLoginId, (String)privateFilePath, (String)fileName);
                    receiptDownloadConnectMonitorUtils.testSftpConnect(ip, Integer.parseInt(port2), user, value, certPath);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"ReceiptBankLoginFormPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(kd.ebg.egf.common.utils.string.StringUtils.norm((String)String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0csftp\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5IP\u3001\u7aef\u53e3\u3001\u7528\u6237\u540d\u548c\u5bc6\u7801\u662f\u5426\u586b\u5199\u6b63\u786e\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u901a\u7545\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"ReceiptBankLoginFormPlugin_6", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), e.getMessage())));
                }
            }
        }
        String configType = "receipt";
        if (StringUtils.equals("save", formOperate.getOperateKey())) {
            String message;
            List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(this.getBankVersion());
            String statusName = ((BaseShowParameter)this.getView().getFormShowParameter()).getStatus().name();
            if (this.showTestConnectButton(bankVersion)) {
                String pushWay = (String)model.getDataEntity().get("receipt_achieve_way");
                String pushWayCode = ReceiptPushWayEnum.getEnumByDesc((String)pushWay).getCode();
                port = "";
                if (Objects.equals(pushWayCode, ReceiptPushWayEnum.SFTP.getCode())) {
                    port = (String)model.getDataEntity().get("bank_ftp_port");
                }
                if (Objects.equals(pushWayCode, ReceiptPushWayEnum.BANK_LOGIN.getCode())) {
                    port = (String)model.getDataEntity().get("front_proxy_port");
                }
                if (EBGStringUtils.isNotEmpty((String)port) && !this.checkValueIsIntType(port)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7aef\u53e3\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"ReceiptBankLoginFormPlugin_7", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (Objects.equals("CMB_OPA", bankVersion)) {
                String download_url = (String)model.getValue("download_url");
                String download_proxy_url = (String)model.getValue("download_proxy_url");
                if (EBGStringUtils.isNotEmpty((String)download_url) && EBGStringUtils.isEmpty((String)download_proxy_url) || EBGStringUtils.isEmpty((String)download_url) && EBGStringUtils.isNotEmpty((String)download_proxy_url)) {
                    message = ResManager.loadKDString((String)"\u3010\u56de\u5355\u4e0b\u8f7d\u7684\u57df\u540d\u3011\u3001\u3010\u56de\u5355\u4e0b\u8f7d\u57df\u540d\u7684\u4ee3\u7406\u670d\u52a1\u3011\uff0c\u9700\u540c\u65f6\u975e\u7a7a\u6216\u540c\u65f6\u4e3a\u7a7a\uff0c\u65e0\u5fc5\u8981\u65f6\u53ef\u4ee5\u90fd\u4e0d\u7528\u914d\u7f6e\u3002", (String)"ReceiptBankLoginFormPlugin_8", (String)"ebg-receipt-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                    args.setCancel(true);
                    return;
                }
            }
            try {
                String fieldValue = (String)this.getModel().getValue("receipt_proxy_download_switch");
                if (Objects.equals("true", fieldValue)) {
                    String filePort = (String)this.getModel().getValue("receipt_proxy_file_port");
                    if (EBGStringUtils.isEmpty((String)filePort)) {
                        message = ResManager.loadKDString((String)"\u901a\u8fc7\u524d\u7f6e\u673a\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u65f6\uff0c\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\u5982\u4e0b\u4fe1\u606f\uff1a1\u3001\u79c1\u6709\u4e91\u7528\u6237\u53ef\u9009\u62e9\u4e0d\u901a\u8fc7\u524d\u7f6e\u673a\u4ee3\u7406\u83b7\u53d6\u56de\u5355 2\u3001\u5982\u9700\u901a\u8fc7\u524d\u7f6e\u673a\u4ee3\u7406\u83b7\u53d6\u56de\u5355\uff0c\u8bf7\u786e\u8ba4\u524d\u7f6e\u673a\u670d\u52a1\u5668\u4e0a\u662f\u5426\u90e8\u7f72\u91d1\u8776\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f 2\u3001\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u662f\u5426\u542f\u52a8\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u7aef\u53e3 3\u3001\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptBankLoginFormPlugin_9", (String)"ebg-receipt-formplugin", (Object[])new Object[0]);
                        this.getView().showErrorNotification(message);
                        args.setCancel(true);
                        return;
                    }
                    if (EBGStringUtils.isNotEmpty((String)filePort) && !this.checkValueIsIntType(filePort)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7aef\u53e3\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"ReceiptBankLoginFormPlugin_7", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
            }
            catch (Throwable fieldValue) {
                // empty catch block
            }
            String customID = RequestContext.get().getTenantId();
            ArrayList<String> operateLogList = new ArrayList<String>(1);
            OperateLogUtils operateLogUtils = new OperateLogUtils();
            ArrayList dynamicObjectList = new ArrayList(1);
            bankLoginInfos.stream().forEach(bankLoginInfo -> {
                String key = bankLoginInfo.getBankConfigId();
                String value = (String)model.getValue(key);
                dynamicObjectList.add(this.packDynamicObject((BankLoginInfo)bankLoginInfo, bankLogin, bankVersion, value, customID, configType));
                if (ConfigInputType.PASSWORD.getInputType().equals(bankLoginInfo.getInputType()) && this.getView().getPageCache().get(cacheKeyPre + bankLoginInfo.getBankConfigId()) != null) {
                    value = cipher.equals(value) ? this.getView().getPageCache().get(cacheKeyPre + bankLoginInfo.getBankConfigId()) : AESUtil.encrypt((String)value);
                }
                String name = FieldUtil.getName(bankLoginInfo.getMlBankConfigName(), bankLoginInfo.getBankConfigName());
                operateLogList.add(operateLogUtils.bankLoginOperateLog(name, bankLoginInfo.getBankConfigId(), value, bankVersion, bankLogin));
                Map<String, DynamicObject> cerMap = this.getCerDataMap();
                if ("upload".equals(bankLoginInfo.getInputType())) {
                    if (cerMap.get(key) != null) {
                        this.updateCer(cerMap.get(key), (BankLoginInfo)bankLoginInfo, bankVersion, bankLogin, customID, this.getPageCache().get(key + "content"), value);
                    } else if (this.getPageCache().get(key + "content") != null) {
                        this.addCer((BankLoginInfo)bankLoginInfo, bankVersion, bankLogin, customID, this.getPageCache().get(key + "content"), value);
                    }
                }
            });
            if ("EDIT".equals(statusName)) {
                this.delete(bankLogin, configType);
            }
            if (!dynamicObjectList.isEmpty()) {
                this.batchSave(dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
            }
            this.receiptConnectMonitorService.insertMonitorRecordByBankVersionAndBankLogin(bankVersion, bankLogin);
            operateLogUtils.saveLogByList(operateLogList, this.getView().getEntityId(), OperateLogType.SAVE.getCnName());
        }
        if (StringUtils.equals(OPEN_REMOTE_KEY, formOperate.getOperateKey()) && !(interceptor = JumpRemoteFilter.interceptor(this.getModel(), this.getView())).isSuccess()) {
            this.getView().showErrorNotification(kd.ebg.egf.common.utils.string.StringUtils.norm((String)interceptor.getMessage()));
            args.setCancel(true);
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public boolean checkValueIsIntType(String value) {
        if (EBGStringUtils.isNotEmpty((String)value)) {
            try {
                int valueInt = Integer.parseInt(value);
                logger.info("vaule:{}", (Object)valueInt);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    DynamicObject[] getCerDatas() {
        String bankLoginID = (String)this.getModel().getValue("number");
        String customID = RequestContext.get().getTenantId();
        return this.userCertRepository.getBankLoginCerDatas(bankLoginID, customID);
    }

    Map<String, DynamicObject> getCerDataMap() {
        DynamicObject[] cerDatas = this.getCerDatas();
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        if (cerDatas != null && cerDatas.length > 0) {
            for (DynamicObject cerData : cerDatas) {
                map.put((String)cerData.get("bank_config_id"), cerData);
            }
        }
        return map;
    }

    void delete(String bankLogin, String configType) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)bankLogin), new QFilter("config_type", "=", (Object)configType)};
        DeleteServiceHelper.delete((String)ENTITY_KEY, (QFilter[])qFilters);
    }

    void addCer(BankLoginInfo bankLoginInfo, String bankVersion, String bankLogin, String customID, String value, String fileName) {
        this.initEBContext();
        this.userCertRepository.addBankLoginCert(bankLoginInfo.getBankConfigId(), JsonUtil.toJsonLine((Object)bankLoginInfo.getMlBankConfigName()), bankVersion, bankLogin, customID, value, fileName);
        this.removeEBContext();
    }

    void updateCer(DynamicObject cerData, BankLoginInfo bankLoginInfo, String bankVersion, String bankLogin, String customID, String value, String fileName) {
        this.initEBContext();
        this.userCertRepository.updateBankLoginCert(cerData, bankLoginInfo.getBankConfigId(), JsonUtil.toJsonLine((Object)bankLoginInfo.getMlBankConfigName()), bankVersion, bankLogin, customID, value, fileName);
        this.removeEBContext();
    }

    DynamicObject packDynamicObject(BankLoginInfo bankLoginInfo, String bankLogin, String bankVersion, String value, String customID, String configType) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY);
        dataEntity.set("number", (Object)bankLogin);
        dataEntity.set("bank_config_id", (Object)bankLoginInfo.getBankConfigId());
        String name = FieldUtil.getName(bankLoginInfo.getMlBankConfigName(), bankLoginInfo.getBankConfigName());
        dataEntity.set("name", (Object)name);
        dataEntity.set("bank_version_id", (Object)bankVersion);
        if (ConfigInputType.PASSWORD.getInputType().equals(bankLoginInfo.getInputType()) && this.getView().getPageCache().get(cacheKeyPre + bankLoginInfo.getBankConfigId()) != null) {
            value = cipher.equals(value) ? this.getView().getPageCache().get(cacheKeyPre + bankLoginInfo.getBankConfigId()) : AESUtil.encrypt((String)value);
        }
        if (kd.ebg.egf.common.utils.string.StringUtils.isNotEmpty((String)value)) {
            dataEntity.set("bank_config_value", (Object)value);
        }
        dataEntity.set("nullable", (Object)bankLoginInfo.isNullable());
        dataEntity.set("readonly", (Object)bankLoginInfo.isReadOnly());
        dataEntity.set("custom_id", (Object)customID);
        dataEntity.set("config_type", (Object)configType);
        dataEntity.set("input_type", (Object)(EBGStringUtils.isNotEmpty((String)bankLoginInfo.getInputType()) ? bankLoginInfo.getInputType() : "text"));
        return dataEntity;
    }

    OperationResult batchSave(DynamicObject[] dataEntity) {
        OperationResult result = SaveServiceHelper.saveOperate((String)ENTITY_KEY, (DynamicObject[])dataEntity, (OperateOption)OperateOption.create());
        return result;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        List<String> attachmentPanelKeys = this.getAttachmentPanelKey();
        if (!CollectionUtils.isEmpty(attachmentPanelKeys)) {
            for (String uploadKey : attachmentPanelKeys) {
                if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)source.getKey(), (CharSequence)uploadKey)) continue;
                UploadOption option = new UploadOption();
                option.setMultiple(false);
                option.setTitle(this.getUploadNameMap(uploadKey));
                option.setSuffix(".p12,.cer,.pem,.crt,.pfx,.p7b,.txt");
                option.setLimitSize(0x200000L);
                option.setLimitCount(1);
                this.getView().showUpload(option, uploadKey);
            }
        }
    }

    public void upload(UploadEvent evt) {
        String customID = RequestContext.get().getTenantId();
        String fieldKey = evt.getCallbackKey().replaceFirst("btn_", "");
        LinkedHashMap linkedHashMap = (LinkedHashMap)evt.getUrls()[0];
        Object fileName = linkedHashMap.get("name");
        String url = linkedHashMap.get("url").toString();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        fileService.download(url, (OutputStream)bos, "httpclient");
        byte[] byteArray = bos.toByteArray();
        try {
            String fileContent = DesUtil.encryptProxyCert((byte[])byteArray, (String)customID);
            this.getPageCache().put(fieldKey + "content", fileContent);
            this.getModel().setValue(fieldKey, fileName);
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u8bc1\u4e66\u5f02\u5e38\u3002", (String)"ReceiptBankLoginFormPlugin_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
        }
    }

    List<String> getAttachmentPanelKey() {
        List fileUploadConfigItemInfoList;
        if (this.getPageCache().get(ATTACHMENTPANELKEY) != null) {
            String keys = this.getPageCache().get(ATTACHMENTPANELKEY);
            return StringUtil.isNil(keys) ? new ArrayList(16) : Arrays.asList(keys.split(","));
        }
        ArrayList<String> result = new ArrayList<String>(16);
        List<BankLoginInfo> infos = this.getBankLoginInfoList(this.getBankVersion());
        String str = "";
        if (!CollectionUtils.isEmpty(infos) && !CollectionUtils.isEmpty(fileUploadConfigItemInfoList = infos.stream().filter(p -> "upload".equals(p.getInputType())).collect(Collectors.toList()))) {
            for (BankLoginInfo p2 : fileUploadConfigItemInfoList) {
                str = str + "btn_" + p2.getBankConfigId() + ",";
                result.add("btn_" + p2.getBankConfigId());
            }
            str = str.substring(0, str.length() - 1);
        }
        this.getPageCache().put(ATTACHMENTPANELKEY, str);
        return result;
    }

    String getUploadNameMap(String key) {
        List fileUploadConfigItemInfoList;
        if (this.getPageCache().get(UPLOAD_FILED_NAME_MAP_KEY) != null) {
            String keys = this.getPageCache().get(UPLOAD_FILED_NAME_MAP_KEY);
            return this.getUploadName(keys, key);
        }
        List<BankLoginInfo> infos = this.getBankLoginInfoList(this.getBankVersion());
        StringBuilder str = new StringBuilder();
        if (!CollectionUtils.isEmpty(infos) && !CollectionUtils.isEmpty(fileUploadConfigItemInfoList = infos.stream().filter(p -> "upload".equals(p.getInputType())).collect(Collectors.toList()))) {
            for (BankLoginInfo p2 : fileUploadConfigItemInfoList) {
                str.append("btn_").append(p2.getBankConfigId()).append("-").append(p2.getBankConfigName()).append(",");
            }
            str = str.delete(0, str.length() - 1);
        }
        this.getPageCache().put(UPLOAD_FILED_NAME_MAP_KEY, str.toString());
        return this.getUploadName(str.toString(), key);
    }

    String getUploadName(String str, String key) {
        String[] arr;
        if (StringUtil.isNil(str)) {
            return "";
        }
        for (String s : arr = str.split(",")) {
            String[] k = s.split("-");
            if (!k[0].equals(key)) continue;
            return k[1];
        }
        return "";
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    public boolean showTestConnectButton(String bankVersion) {
        List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(bankVersion);
        for (BankLoginInfo bankLoginInfo : bankLoginInfos) {
            if (!Objects.equals(bankLoginInfo.getBankConfigId(), "receipt_achieve_way")) continue;
            return true;
        }
        return false;
    }

    private void initEBContext() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext == null) {
            ebContext = EBContext.builder().build();
            EBContext.setContext((EBContext)ebContext);
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        ebContext.setFormId(formId);
    }

    private void removeEBContext() {
        EBContext.destroy();
    }
}

