/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.task;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.model.repository.receipt.DownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptDetailListPlugin
extends AbstractListPlugin {
    private DownloadListDetailRepository downloadListDetailRepository = (DownloadListDetailRepository)SpringContextUtil.getBean(DownloadListDetailRepository.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long taskId = (Long)((ListShowParameter)this.getView().getFormShowParameter()).getCustomParam("taskId");
        if (taskId != null) {
            e.getQFilters().add(new QFilter("refid", "=", (Object)String.valueOf(taskId)));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ArrayList<DynamicObject> needResetUploadTaskList;
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"reupload", (CharSequence)formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            needResetUploadTaskList = new ArrayList<DynamicObject>(16);
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject dynamicObject = this.downloadListDetailRepository.selectById(fid);
                if (dynamicObject != null && UploadStatusEnum.UPLOAD_FAIL.getId() == dynamicObject.getInt("upload_flag")) {
                    dynamicObject.set("upload_flag", (Object)UploadStatusEnum.UN_UPLOAD.getId());
                    dynamicObject.set("upload_redo", (Object)0);
                    dynamicObject.set("upload_exp_msg", (Object)"");
                    dynamicObject.set("upload_time", (Object)-1);
                    needResetUploadTaskList.add(dynamicObject);
                }
            });
            if (!CollectionUtils.isEmpty(needResetUploadTaskList)) {
                SaveServiceHelper.save((DynamicObject[])needResetUploadTaskList.toArray(new DynamicObject[needResetUploadTaskList.size()]));
                this.getView().invokeOperation("refresh");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u4e0a\u4f20\u5931\u8d25\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReceiptDetailListPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"edit_receipt_no", (CharSequence)formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            Long fid;
            if (listSelectedRowCollection.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u4e0a\u4f20\u6210\u529f\u4e14\u5339\u914d\u5931\u8d25\u7684\u5355\u6761\u8bb0\u5f55\u3002", (String)"ReceiptDetailListPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            needResetUploadTaskList = new ArrayList(16);
            AtomicInteger selectCount = new AtomicInteger();
            for (ListSelectedRow selectedRow2 : listSelectedRowCollection) {
                fid = (Long)selectedRow2.getPrimaryKeyValue();
                DynamicObject dynamicObject = this.downloadListDetailRepository.selectById(fid);
                if (dynamicObject == null) continue;
                if (MatchStatusEnum.FAIL.getId() == dynamicObject.getInt("match_flag") && UploadStatusEnum.UPLOAD_SUCCESS.getId() == dynamicObject.getInt("upload_flag")) {
                    needResetUploadTaskList.add(dynamicObject);
                    selectCount.set(selectCount.get() + 1);
                }
                if (MatchStatusEnum.SUCCESS.getId() != dynamicObject.getInt("match_flag") && UploadStatusEnum.UPLOAD_SUCCESS.getId() == dynamicObject.getInt("upload_flag")) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u4e0a\u4f20\u6210\u529f\u4e14\u5339\u914d\u5931\u8d25\u7684\u5355\u6761\u8bb0\u5f55\u3002", (String)"ReceiptDetailListPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (needResetUploadTaskList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u4e0a\u4f20\u6210\u529f\u5e76\u4e14\u5339\u914d\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReceiptDetailListPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (needResetUploadTaskList.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u4e0a\u4f20\u6210\u529f\u4e14\u5339\u914d\u5931\u8d25\u7684\u5355\u6761\u8bb0\u5f55\u3002", (String)"ReceiptDetailListPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!CollectionUtils.isEmpty(needResetUploadTaskList)) {
                DynamicObject dynamicObject = (DynamicObject)needResetUploadTaskList.get(0);
                String receiptNo = dynamicObject.getString("detail_no");
                fid = dynamicObject.getLong("id");
                this.showEditMatchNoPage(fid, receiptNo);
            }
        }
    }

    public void showEditMatchNoPage(Long fid, String receiptNo) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("recordId", (Object)fid);
        showParameter.setCustomParam("old_receipt_no", (Object)receiptNo);
        showParameter.setFormId("receipt_match_update");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        if (closedCallBackEvent.getReturnData() != null && "success".equals(result = (String)closedCallBackEvent.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

