/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.task;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.receipt.formplugin.service.CommonService;
import kd.ebg.receipt.formplugin.util.LocalDateUtils;

public class ReceiptDownloadTaskSortPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDownloadTaskSortPlugin.class);
    private static final String SELECT_ALL_PROPERTIES = "id,bank_login.number,acc_no.number,bank_version.number,batch_no,trans_date,status,complete_time,exp_msg,redo,receipt_num,detail_num,custom_id,todays_flag,modifytime,createtime,match_num,upload_num,upload_flag,detail_flag,defect_type,suggestion,zip_names,zip_names_tag,file_num,sort";
    private static final String FIELD_KEY_BANK_ACNT = "acc_no";
    private static final String ENTITY_KEY_BANK_LOGIN = "aqap_bank_login";
    private EbcBankAcntRepository ebcBankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);
    private DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    private CommonService commonService = (CommonService)SpringContextUtil.getBean(CommonService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit acntFieldEdit = (BasedataEdit)this.getView().getControl(FIELD_KEY_BANK_ACNT);
        if (acntFieldEdit != null) {
            acntFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_KEY_BANK_ACNT)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
            QFilter qFilter = new QFilter("has_receipt", "=", (Object)"1");
            qFilters.add(qFilter);
            QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
            qFilters.add(qFilter1);
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"submit_sort", (CharSequence)formOperate.getOperateKey())) {
            LocalDate endLocalDate;
            Date startDate = (Date)this.getModel().getDataEntity().get("trans_start_date");
            if (startDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptDownloadTaskSortPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Date endDate = (Date)this.getModel().getDataEntity().get("trans_end_date");
            if (endDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptDownloadTaskSortPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            LocalDate startLocalDate = LocalDateUtils.date2LocalDate(startDate);
            if (!startLocalDate.isBefore(endLocalDate = LocalDateUtils.date2LocalDate(endDate)) && !startLocalDate.isEqual(endLocalDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u9700\u8981\u5927\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"ReceiptDownloadTaskSortPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getDataEntity().get(FIELD_KEY_BANK_ACNT);
            if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptDownloadTaskSortPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List accountList = dynamicObjectCollection.stream().map(t -> t.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            ArrayList<Long> accNos = new ArrayList<Long>(1);
            for (DynamicObject dynamicObject : accountList) {
                Long id = dynamicObject.getLong("id");
                accNos.add(id);
            }
            int sort = (Integer)this.getModel().getDataEntity().get("sort");
            DynamicObject[] tasks = this.getTaskByTransDateAndAccNo(startLocalDate, endLocalDate, accNos);
            this.updateTaskSort(tasks, sort);
            this.getPageCache().put("sort_task_by_hand_success", "true");
        }
    }

    public DynamicObject[] getTaskByTransDateAndAccNo(LocalDate startDate, LocalDate endDate, List<Long> accNos) {
        QFilter start_trans_date = new QFilter("trans_date", ">=", (Object)startDate);
        QFilter end_trans_date = new QFilter("trans_date", "<=", (Object)endDate);
        QFilter acc_no = new QFilter(FIELD_KEY_BANK_ACNT, "in", accNos);
        QFilter status = new QFilter("status", "in", (Object)new String[]{"1", "3", "6"});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"receipt_download_task", (String)"id,sort,modifytime", (QFilter[])new QFilter[]{start_trans_date, end_trans_date, acc_no, status});
        return dynamicObjects;
    }

    public void updateTaskSort(DynamicObject[] dynamicObjects, int sort) {
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("sort", (Object)sort);
                dynamicObject.set("modifytime", (Object)new Date());
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        if ("true".equals(this.getPageCache().get("sort_task_by_hand_success"))) {
            this.getView().returnDataToParent((Object)"create_success");
        }
    }
}

