/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.model.repository.receipt.ReceiptInfoRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.common.EbgBankVersionFilterContainerPlugin;
import kd.ebg.receipt.formplugin.plugin.util.ShowPageUtil;

public class ReceiptInfoListPlugin
extends EbgBankVersionFilterContainerPlugin {
    private ReceiptInfoRepository receiptInfoRepository = (ReceiptInfoRepository)SpringContextUtil.getBean(ReceiptInfoRepository.class);

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap)) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (!fieldName.equals("trans_date") || paramMap.get("trans_date") == null) continue;
                ArrayList l = new ArrayList(16);
                l.add(paramMap.get("trans_date"));
                l.add(paramMap.get("trans_date"));
                commonFilterColumn.setDefaultValues(l);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    int result = row.getInt("receipt_acnt_num") - row.getInt("task_num");
                    if (result < 0) {
                        result = 0;
                    }
                    row.set("need_create_num", (Object)result);
                }
                return rows;
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"modify", (CharSequence)formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            Long receiptInfoId = (Long)listSelectedRowCollection.get(0).getPrimaryKeyValue();
            DynamicObject dynamicObject = this.receiptInfoRepository.findOneById(receiptInfoId.longValue());
            if (dynamicObject != null) {
                int result = dynamicObject.getInt("receipt_acnt_num") - dynamicObject.getInt("task_num");
                if (result <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f\u4e0d\u5b58\u5728\u5f85\u5efa\u4efb\u52a1\u3002", (String)"ReceiptInfoListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                } else {
                    HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
                    customParams.put("bank_version_id", dynamicObject.getString("bank_version.number"));
                    customParams.put("trans_date", DateUtil.formatDate((Date)dynamicObject.getDate("trans_date"), (String)"yyyy-MM-dd"));
                    ShowPageUtil.showBaseFormPage("receipt_task_need_create", customParams, this.getView(), (IFormPlugin)this, ShowType.Modal);
                }
            }
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
    }
}

