/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.service.info;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.receipt.common.framework.properties.PropertyName;
import kd.ebg.receipt.common.utils.BeanFactory;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.formplugin.exception.EBBizException;
import kd.ebg.receipt.formplugin.pojo.bizinfo.BankInfo;
import kd.ebg.receipt.formplugin.pojo.bizinfo.BankLoginInfo;
import kd.ebg.receipt.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.receipt.formplugin.pojo.bizinfo.EBJobBean;
import kd.ebg.receipt.formplugin.pojo.bizinfo.PropertyConfigInfo;
import kd.ebg.receipt.formplugin.pojo.bizinfo.PropertyConfigItemInfo;
import kd.ebg.receipt.formplugin.pojo.bizinfo.ServiceInfo;
import kd.ebg.receipt.formplugin.service.info.BizInfoStore;
import kd.ebg.receipt.formplugin.util.JsonUtil;
import kd.ebg.receipt.mservice.boot.configuration.FrameworkInfoConfiguration;

@Service
public class InfoService {
    private static final Log logger = LogFactory.getLog(InfoService.class);
    private static AtomicReference<ServiceInfo> serviceInfoAtomicReference = new AtomicReference();
    private static Long lastUpdateTime = 1L;
    private static final Long UPDATEPEROID = 6000L;
    private static String banksInfo = "";
    @Autowired
    private List<BizInfoStore> infoGetters;

    public List<BizInfoStore> getInfoGetters() {
        return this.infoGetters;
    }

    public void setInfoGetters(List<BizInfoStore> infoGetters) {
        this.infoGetters = infoGetters;
    }

    private synchronized void init() {
        FrameworkInfoConfiguration infoConfiguration = (FrameworkInfoConfiguration)BeanFactory.getBean(FrameworkInfoConfiguration.class);
        if (infoConfiguration.isFinished() || FileCommonUtils.isTestEnv()) {
            Map map = infoConfiguration.getFrameworkInfoMap();
            if (map != null) {
                String result = (String)map.get("eb_frameworkInfos_receipt");
                serviceInfoAtomicReference.set(JsonUtil.fromJson(result, ServiceInfo.class));
            }
        } else {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5e94\u7528\u542f\u52a8\u8fd8\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"InfoService_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
        }
    }

    private void ensureInit() {
        this.init();
    }

    public JSONObject getBankVersionInfo() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        result.put("bankVersions", (Object)array);
        serviceInfo.getBankVersions().forEach(version -> {
            JSONObject bankVersion = new JSONObject();
            bankVersion.put("bankVersionID", (Object)version.getBankVersionID());
            bankVersion.put("bankVersionName", (Object)version.getBankVersionName());
            bankVersion.put("bankVersionDescription", (Object)version.getBankVersionDescription());
            bankVersion.put("version", (Object)version.getVersion());
            bankVersion.put("isSupportReconciliation", (Object)version.isSupportReconciliation());
            bankVersion.put("isReconciliationOfAccNo", (Object)version.isReconciliationOfAccNo());
            array.add((Object)bankVersion);
        });
        return result;
    }

    public List<BankInfo> getBankAll() {
        this.ensureInit();
        return serviceInfoAtomicReference.get().getBanks();
    }

    public List<EBJobBean> getAllJobBeans() {
        this.ensureInit();
        return serviceInfoAtomicReference.get().getJobBeans();
    }

    public JSONObject getBanksInfo() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        result.put("banks", (Object)array);
        serviceInfo.getBanks().forEach(bankInfo -> {
            JSONObject bank = new JSONObject();
            bank.put("bankShortName", (Object)bankInfo.getBankShortName());
            bank.put("bankName", (Object)bankInfo.getBankName());
            bank.put("bankDescription", (Object)bankInfo.getBankDescription());
            JSONArray keyWords = new JSONArray();
            bankInfo.getBankNameKeyWords().forEach(arg_0 -> ((JSONArray)keyWords).add(arg_0));
            array.add((Object)bank);
        });
        return result;
    }

    public Map<String, String> getBankNamePairs() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        HashMap bankNamePairs = Maps.newHashMapWithExpectedSize((int)8);
        serviceInfo.getBanks().forEach(bankInfo -> bankNamePairs.put(bankInfo.getBankShortName(), bankInfo.getBankName()));
        return bankNamePairs;
    }

    public JSONObject getLoginConfig(String bankVersionID) {
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        result.put("loginConfigs", (Object)array);
        BankVersionInfo versionInfo = this.getBankVersionInfo(bankVersionID);
        versionInfo.getLogins().forEach(arg_0 -> ((JSONArray)array).add(arg_0));
        return result;
    }

    public PropertyConfigInfo getBankConfig(String bankVersionID) {
        BankVersionInfo versionInfo = this.getBankVersionInfo(bankVersionID);
        return versionInfo.getPropertyConfigInfo();
    }

    public String getBusinessName(String bankVersionID) {
        PropertyConfigInfo propertyConfigInfo = this.getBankConfig(bankVersionID);
        if (propertyConfigInfo != null) {
            return propertyConfigInfo.getPropertyName();
        }
        return "";
    }

    public String getBusinessName() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        return serviceInfo.getBankVersions().get(0).getPropertyConfigInfo().getPropertyName();
    }

    public List<BankVersionInfo> getBankVersionInfoList() {
        this.ensureInit();
        return serviceInfoAtomicReference.get().getBankVersions();
    }

    public PropertyConfigInfo getBankBusinessConfig(String bankVersionID) {
        PropertyConfigInfo propertyConfigInfo = this.getBankConfig(bankVersionID);
        List<PropertyConfigItemInfo> configItemInfos = propertyConfigInfo.getConfigItems().stream().filter(configItemInfo -> !configItemInfo.isAccNo()).collect(Collectors.toList());
        propertyConfigInfo.setConfigItems(configItemInfos);
        return propertyConfigInfo;
    }

    public PropertyConfigInfo getBankAcntConfig(String bankVersionID) {
        PropertyConfigInfo propertyConfigInfo = this.getBankConfig(bankVersionID);
        List<PropertyConfigItemInfo> configItemInfos = propertyConfigInfo.getConfigItems().stream().filter(configItemInfo -> configItemInfo.isAccNo()).collect(Collectors.toList());
        propertyConfigInfo.setConfigItems(configItemInfos);
        return propertyConfigInfo;
    }

    public PropertyConfigInfo getSystemConfig() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        List<PropertyConfigInfo> propertyConfigs = serviceInfo.getPropertyConfigs();
        for (PropertyConfigInfo info : propertyConfigs) {
            if (!"access".equals(info.getPropertyConfigID())) continue;
            return info;
        }
        return null;
    }

    public List<PropertyConfigItemInfo> getBankAcntAddtionOpts(String bankVersionID) {
        ArrayList<PropertyConfigItemInfo> bankAcntAddtionOpts = new ArrayList<PropertyConfigItemInfo>(16);
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        List<PropertyConfigInfo> propertyConfigs = serviceInfo.getPropertyConfigs();
        for (PropertyConfigInfo propertyConfig : propertyConfigs) {
            if (!propertyConfig.getPropertyConfigID().equals(bankVersionID)) continue;
            List<PropertyConfigItemInfo> configItems = propertyConfig.getConfigItems();
            for (PropertyConfigItemInfo configItem : configItems) {
                if (!configItem.isAccNo()) continue;
                bankAcntAddtionOpts.add(configItem);
            }
        }
        return bankAcntAddtionOpts;
    }

    public PropertyConfigInfo getCommonBusinessConfig() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        List<PropertyConfigInfo> propertyConfigs = serviceInfo.getPropertyConfigs();
        for (PropertyConfigInfo info : propertyConfigs) {
            if (!"common_business".equals(info.getPropertyConfigID()) || !Objects.equals(info.getPropertyName(), PropertyName.COMMON_BUSINESS.name())) continue;
            return info;
        }
        return null;
    }

    public BankVersionInfo getBankVersionInfo(String bankVersionID) {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        return serviceInfo.getBankVersions().stream().filter(v -> v.getBankVersionID().equals(bankVersionID)).findFirst().orElseThrow(() -> new EBBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7684 bankVersionID\uff1a%s", (String)"InfoService_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), bankVersionID)));
    }

    public List<BankLoginInfo> getBankLoginInfoList(String bankVersionID) {
        BankVersionInfo bankVersionInfo = this.getBankVersionInfo(bankVersionID);
        if (bankVersionInfo != null) {
            return bankVersionInfo.getLogins();
        }
        return null;
    }

    public String getBankLoginConfigSourceName(String bankVersionID, String key, String value) {
        List<String> sourceValues;
        String sourceName = value;
        BankLoginInfo bankLoginConfig = this.getBankLoginConfig(bankVersionID, key);
        if (bankLoginConfig != null && CollectionUtil.isNotEmpty(sourceValues = bankLoginConfig.getSourceValues())) {
            for (int i = 0; i < sourceValues.size(); ++i) {
                if (!sourceValues.get(i).equalsIgnoreCase(value)) continue;
                sourceName = CollectionUtil.isEmpty(bankLoginConfig.getSourceNames()) ? bankLoginConfig.getMlSourceNames().get(i).loadKDString() : bankLoginConfig.getSourceNames().get(i);
            }
        }
        return sourceName;
    }

    private BankLoginInfo getBankLoginConfig(String bankVersionID, String key) {
        List<BankLoginInfo> bankLoginConfigList = this.getBankLoginInfoList(bankVersionID);
        for (BankLoginInfo bankLoginConfig : bankLoginConfigList) {
            if (!bankLoginConfig.getBankConfigId().equalsIgnoreCase(key)) continue;
            return bankLoginConfig;
        }
        return null;
    }
}

