/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.util;

import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.sdk.annotation.SdkDeprecated;

public class StringUtil {
    public static final int PAD_STYLE_LEFT = 1;
    public static final int PAD_STYLE_RIGTH = 2;
    public static final int PAD_STYLE_BOTH = 3;
    private static final char[] BASE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".toCharArray();
    private static final Pattern KSM_ORDER_NUMBER_PATTERN = Pattern.compile("R20\\d{2}(0[1-9]|1[0-2])([0-2]\\d|3[0-1])-\\d{4}");

    public static boolean isNil(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotNil(String string) {
        return !StringUtil.isNil(string);
    }

    public static boolean isNil(Collection<String> strings) {
        return strings == null || strings.size() == 0;
    }

    public static boolean isNil(String[] strings) {
        return strings == null || strings.length == 0;
    }

    public static boolean isNotNil(String[] strings) {
        return !StringUtil.isNil(strings);
    }

    public static boolean isNotNil(Collection<String> strings) {
        return !StringUtil.isNil(strings);
    }

    public static List<String> createList(String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < strings.length; ++i) {
            list.add(strings[i]);
        }
        return list;
    }

    public static String[] createArray(List<String> strings) {
        String[] array = new String[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            array[i] = strings.get(i);
        }
        return array;
    }

    public static String trim(String string) {
        if (string == null) {
            return string;
        }
        return string.trim();
    }

    public static boolean isInStrings(String target, String ... conditions) {
        for (String condition : conditions) {
            if (!target.equals(condition)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumber(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher match = pattern.matcher(str);
        return match.matches();
    }

    public static String insertEnterToString(String str, int lineSize) {
        if (str == null || "".equals(str)) {
            return null;
        }
        if (lineSize >= str.length() || lineSize <= 0) {
            return str;
        }
        StringBuilder resultStr = new StringBuilder();
        while (str.length() > lineSize) {
            resultStr.append(str.substring(0, lineSize)).append("\n\r");
            str = str.substring(lineSize);
        }
        resultStr.append(str);
        return resultStr.toString();
    }

    public static String subString(String str, int length) {
        if (StringUtil.isNil(str) || length <= 0) {
            return str;
        }
        return str.length() < length ? str : str.substring(0, length);
    }

    public static String subStringHTML(String param, int length, String end) {
        StringBuilder result = new StringBuilder();
        int n = 0;
        boolean isCode = false;
        boolean isHTML = false;
        for (int i = 0; i < param.length(); ++i) {
            char temp = param.charAt(i);
            if (temp == '<') {
                isCode = true;
            } else if (temp == '&') {
                isHTML = true;
            } else if (temp == '>' && isCode) {
                --n;
                isCode = false;
            } else if (temp == ';' && isHTML) {
                isHTML = false;
            }
            if (!isCode && !isHTML) {
                ++n;
                if ((temp + "").getBytes().length > 1) {
                    ++n;
                }
            }
            result.append(temp);
            if (n >= length) break;
        }
        result.append(end);
        String temp_result = result.toString().replaceAll("(>)[^<>]*(<?)", "$1$2");
        temp_result = temp_result.replaceAll("</?(AREA|BASE|BASEFONT|BODY|BR|COL|COLGROUP|DD|DT|FRAME|HEAD|HR|HTML|IMG|INPUT|ISINDEX|LI|LINK|META|OPTION|P|PARAM|TBODY|TD|TFOOT|TH|THEAD|TR|area|base|basefont|body|br|col|colgroup|dd|dt|frame|head|hr|html|img|input|isindex|li|link|meta|option|p|param|tbody|td|tfoot|th|thead|tr)[^<>]*/?>", "");
        temp_result = temp_result.replaceAll("<([a-zA-Z]+)[^<>]*>(.*?)</\\1>", "$2");
        Pattern p = Pattern.compile("<([a-zA-Z]+)[^<>]*>");
        Matcher m = p.matcher(temp_result);
        ArrayList<String> endHTML = new ArrayList<String>(16);
        while (m.find()) {
            endHTML.add(m.group(1));
        }
        for (int i = endHTML.size() - 1; i >= 0; --i) {
            result.append("</");
            result.append(endHTML.get(i));
            result.append(">");
        }
        return result.toString();
    }

    public static String limitStringByBytes(String value, int len) {
        if (StringUtil.isNil(value) || len <= 0) {
            return value;
        }
        if (value.getBytes().length <= len) {
            return value;
        }
        return new String(value.getBytes(), 0, len);
    }

    public static boolean validStringByBytes(String value, int len) {
        if (StringUtil.isNil(value) || len <= 0) {
            return true;
        }
        return value.getBytes().length <= len;
    }

    public static String blankWhenNull(String str) {
        return str == null ? "" : str;
    }

    public static String dashWhenNull(String str) {
        return str == null || "".equals(str.trim()) ? "\u2014\u2014" : str;
    }

    public static String getStringAfter(String s, String after) {
        int beginIndex = s.indexOf(after);
        if (s.length() == beginIndex + 1 || beginIndex == -1) {
            return "";
        }
        return s.substring(beginIndex + 1);
    }

    public static String right(String s, int length) {
        if (s == null) {
            return null;
        }
        assert (length > 0) : "length must greater than zero";
        if (s.length() <= length) {
            return s;
        }
        return s.substring(s.length() - length, s.length());
    }

    public static String listToString(List<String> productTagList, String split) {
        if (productTagList == null || productTagList.isEmpty()) {
            return null;
        }
        StringBuilder r = new StringBuilder();
        for (String item : productTagList) {
            if (r.length() == 0) {
                r.append(item);
                continue;
            }
            if (item == null || item.length() <= 0) continue;
            r.append(split).append(item);
        }
        return r.toString();
    }

    public static String listToString(List<String> productTagList) {
        return StringUtil.listToString(productTagList, ",");
    }

    public static boolean isNullOrEmpty(String str) {
        return null == str || 0 == str.trim().length();
    }

    public static String pad(String str, String padStr, int padTimes, int padStyle) {
        assert (str != null) : ResManager.loadKDString((String)"\u586b\u5145\u76ee\u6807\u4e3a\u7a7a", (String)"StringUtil_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]);
        assert (StringUtil.isNotNil(padStr)) : ResManager.loadKDString((String)"\u586b\u5145\u5b57\u7b26\u4e32\u4e3a\u7a7a\u3002", (String)"StringUtil_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]);
        assert (padTimes >= 0) : ResManager.loadKDString((String)"\u586b\u5145\u6b21\u6570\u5c0f\u4e8e0\u3002", (String)"StringUtil_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]);
        StringBuilder actualPadStr = new StringBuilder();
        for (int i = 0; i < padTimes; ++i) {
            actualPadStr.append(padStr);
        }
        if (1 == padStyle) {
            return actualPadStr.append(str).toString();
        }
        if (2 == padStyle) {
            StringBuilder result = new StringBuilder();
            result.append(str).append((CharSequence)actualPadStr);
            return result.toString();
        }
        if (3 == padStyle) {
            StringBuilder result = new StringBuilder();
            String actualPad = actualPadStr.toString();
            result.append(actualPad);
            result.append(str);
            result.append(actualPad);
            return result.toString();
        }
        assert (false) : ResManager.loadKDString((String)"\u4e0d\u80fd\u8bc6\u522b\u586b\u5145\u6a21\u5f0f\u3002", (String)"StringUtil_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]);
        return str;
    }

    public static String pad(String str, int padTimes) {
        return StringUtil.pad(str, " ", padTimes, 3);
    }

    public static List<String> partition(String s, int len) {
        ArrayList<String> ss = new ArrayList<String>(16);
        if (s.length() > len) {
            do {
                ss.add(s.substring(0, len));
            } while ((s = s.substring(len)).length() > len);
        }
        ss.add(s);
        return ss;
    }

    public static String removeSameString(String s) {
        StringTokenizer token = new StringTokenizer(s, ",");
        StringBuilder resultString = new StringBuilder();
        LinkedHashSet<Object> stringSet = new LinkedHashSet<Object>();
        int countTokens = token.countTokens();
        for (int i = 0; i < countTokens; ++i) {
            stringSet.add(token.nextElement());
        }
        Iterator it = stringSet.iterator();
        while (it.hasNext()) {
            resultString.append((String)it.next()).append(",");
        }
        if (StringUtil.isNotNil(resultString.toString())) {
            String result = resultString.substring(0, resultString.length() - 1);
            return result;
        }
        return resultString.toString();
    }

    public static String obj2xml(Object obj) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(o);
        e.setPersistenceDelegate(BigDecimal.class, new DefaultPersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                BigDecimal bd = (BigDecimal)oldInstance;
                return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{bd.toString()});
            }
        });
        e.writeObject(obj);
        e.flush();
        e.close();
        return o.toString();
    }

    public static String replaceComma(String str) {
        if (StringUtil.isNil(str)) {
            return str;
        }
        return str.replace(",", "\uff0c");
    }

    @SdkDeprecated
    public static String[] split(String originalString, int splitByteLength) {
        ArrayList<String> vector = new ArrayList<String>();
        String strText = "";
        byte[] arrByte = null;
        int intStartIndex = 0;
        int intEndIndex = 0;
        int index = 0;
        int fixCount = 0;
        String[] arrReturn = null;
        if (originalString == null) {
            return new String[0];
        }
        if (originalString.equals("")) {
            return new String[0];
        }
        if (originalString.trim().equals("")) {
            return new String[]{""};
        }
        if (splitByteLength <= 1) {
            return new String[]{originalString};
        }
        arrByte = originalString.getBytes();
        intEndIndex = 0;
        while (true) {
            intStartIndex = intEndIndex;
            intEndIndex = intStartIndex + splitByteLength;
            if (intStartIndex >= arrByte.length) break;
            if (intEndIndex > arrByte.length) {
                intEndIndex = arrByte.length;
                strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex);
                vector.add(strText);
                break;
            }
            fixCount = 0;
            strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex);
            byte[] bytes = strText.getBytes();
            for (index = intEndIndex - 1; index >= intStartIndex && arrByte[index] != bytes[index - intStartIndex]; --index) {
                ++fixCount;
            }
            if (fixCount > 0) {
                if (fixCount >= intEndIndex) {
                    fixCount = 0;
                }
                strText = new String(arrByte, intStartIndex, (intEndIndex -= fixCount) - intStartIndex);
            }
            vector.add(strText);
        }
        arrReturn = new String[vector.size()];
        vector.toArray(arrReturn);
        return arrReturn;
    }

    public static String arrayToString(Object[] list, String splitStr) {
        if (list == null) {
            return "";
        }
        StringBuilder row = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            if (list[i] == null) {
                stringBuilder.append(splitStr);
            } else {
                stringBuilder.append(list[i]).append(splitStr);
            }
            row.append((CharSequence)stringBuilder);
        }
        String rowStr = row.substring(0, row.length() - splitStr.length());
        return rowStr;
    }

    public static String objToStr(Object obj) {
        return obj == null ? "" : String.valueOf(obj);
    }

    public static String getChineseCharacter(String str) {
        String regEx = "[\\u4e00-\\u9fa5]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        StringBuilder result = new StringBuilder();
        while (m.find()) {
            result.append(m.group(0));
        }
        return result.toString();
    }

    public static String[] splitNoteNo(String noteNo) {
        if (noteNo == null) {
            noteNo = "";
        }
        String[] invoiceInfo = new String[2];
        if (noteNo.contains("-")) {
            invoiceInfo[0] = noteNo.split("-")[0];
            invoiceInfo[1] = noteNo.split("-")[1];
        } else {
            invoiceInfo[0] = "";
            invoiceInfo[1] = noteNo;
        }
        return invoiceInfo;
    }

    public static String dealNullAndTrimString(String str) {
        if (str == null || str.equals("")) {
            return "";
        }
        return str.trim();
    }

    public static List<String> split(String str) {
        return StringUtil.split(str, ",");
    }

    public static List<String> split(String str, String regex) {
        String[] arr;
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isNil(str)) {
            return list;
        }
        if (StringUtil.isNil(regex)) {
            list.add(str);
            return list;
        }
        for (String a : arr = str.split(regex)) {
            if (StringUtil.isNil(a.trim())) continue;
            list.add(a.trim());
        }
        return list;
    }

    public static boolean isEmail(String email) {
        String regex = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(email);
        return m.find();
    }

    public static boolean isChinaPhoneLegal(String str) {
        String regExp = "^((13[0-9])|(14[5,7,9])|(15[0-3,5-9])|(166)|(17[3,5,6,7,8])|(18[0-9])|(19[8,9]))\\d{8}$";
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static String convertIntToString(int srcInteger, int totalLength) {
        StringBuilder targetStr = new StringBuilder();
        int count = totalLength - Integer.toString(srcInteger).length();
        for (int i = 0; i < count; ++i) {
            targetStr.append("0");
        }
        targetStr.append(srcInteger);
        return targetStr.toString();
    }

    public static String convertBigDecimalToString(BigDecimal value) {
        if (value == null) {
            return "0.00";
        }
        value = value.setScale(2, 4);
        return value.toString();
    }

    public static boolean equals(String oldValue, String newValue) {
        if (oldValue == null) {
            return newValue == null ? true : newValue.equals(oldValue);
        }
        return oldValue.equals(newValue);
    }

    public static String replaceSpecialtyStr(String str, String pattern, String replace) {
        if (StringUtil.isNil(str)) {
            return null;
        }
        if (StringUtil.isNil(pattern)) {
            pattern = "\\s*|\t|\r|\n";
        }
        if (StringUtil.isNil(replace)) {
            replace = "";
        }
        return Pattern.compile(pattern).matcher(str).replaceAll(replace);
    }

    public static String replaceSpecialtyStr(String str) {
        return StringUtil.replaceSpecialtyStr(str, null, null);
    }

    public static String replaceExtraSpace(String str) {
        if ((str = str.replaceAll("\r+|\n+|\t+", " ").replaceAll(" +", " ")).startsWith(" ")) {
            str = str.substring(1);
        }
        if (str.endsWith(" ")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String obj2Str(Object o) {
        return o == null ? "" : o.toString();
    }

    public static boolean equalsIgnoreCase(String srcStr, String targetStr) {
        if (srcStr == null && targetStr == null) {
            return false;
        }
        if (srcStr != null) {
            return srcStr.equalsIgnoreCase(targetStr);
        }
        return targetStr.equalsIgnoreCase(srcStr);
    }

    public static boolean isValidFeedbackNumber(String feedbackNumber) {
        return KSM_ORDER_NUMBER_PATTERN.matcher(feedbackNumber).matches();
    }

    public static List limitByIndexAndSize(List list, int index, int pageSize) {
        if (list.isEmpty()) {
            return new ArrayList(1);
        }
        int startIndex = index * pageSize;
        int endIndex = (index + 1) * pageSize;
        if (list.size() < endIndex) {
            endIndex = list.size();
        }
        if (startIndex >= list.size()) {
            return new ArrayList(1);
        }
        return list.subList(startIndex, endIndex);
    }
}

