/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt.api;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseTradeQhisdRequestV1;
import com.icbc.api.response.MybankEnterpriseTradeQhisdResponseV1;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.api.DetailPage;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.utils.GetStore;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.utils.ICBC_OPA_Packer;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.utils.ICBC_OPA_Parser;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.model.DetailInfo;
import net.sf.json.JSONObject;

public class DetailImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public List<DetailInfo> detail(String accNo, LocalDate transDate, String bankCurrency) {
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        header.setBankCurrency(bankCurrency);
        BankDetailRequest bankDetailRequest = new BankDetailRequest();
        bankDetailRequest.setStartDate(transDate);
        bankDetailRequest.setEndDate(transDate);
        bankDetailRequest.setHeader(header);
        bankDetailRequest.setBankCurrency(bankCurrency);
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/trade/qhisd/V1";
        DefaultIcbcClient client = GetStore.getClient();
        DetailPage page = new DetailPage();
        String pageTag = page.getFirstPageTag();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        try {
            MybankEnterpriseTradeQhisdResponseV1 response;
            do {
                MybankEnterpriseTradeQhisdRequestV1.MybankEnterpriseTradeQhisdRequestBizV1 bizContent = ICBC_OPA_Packer.packer(bankDetailRequest, pageTag);
                MybankEnterpriseTradeQhisdRequestV1 request = new MybankEnterpriseTradeQhisdRequestV1();
                request.setServiceUrl(BASE_URL + URI);
                request.setBizContent((BizContent)bizContent);
                this.logger.info("\u660e\u7ec6\u67e5\u8be2\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)request).toString());
                response = (MybankEnterpriseTradeQhisdResponseV1)client.execute((IcbcRequest)request);
                this.logger.info("\u660e\u7ec6\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                detailList.addAll(ICBC_OPA_Parser.parse(bankDetailRequest, response));
            } while (!page.isLastPage(pageTag = page.getNextPageTag(response)));
            return detailList;
        }
        catch (Exception e) {
            this.logger.error("detail error :", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

