/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt.batch;

import com.google.common.collect.Sets;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.FileFilter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.ICBCOpaCommConfig;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.ICBCOpaFileParser;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.utils.TodayReceiptUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BatchBankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BatchBankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        String bankLogin;
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.PROCESSING.getId()) {
            return false;
        }
        if (request.getTransDate().equals(LocalDate.now())) {
            return false;
        }
        if (!RequestContextUtils.receiptFormatIsFile() && !FileCommonUtils.isTestEnv()) {
            return false;
        }
        String bankVersion = EBContext.getContext().getBankVersionID();
        return RequestContextUtils.isSupportBatchDownloadByBankLogin((String)bankVersion, (String)(bankLogin = EBContext.getContext().getBankLoginID())) && request.getTransDate().isBefore(LocalDate.now());
    }

    public boolean isRemoveDetailBefore() {
        return true;
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        List<Object> result = new ArrayList(16);
        result = this.doJob_pushMode(downloadListTask);
        return BankReceiptHandleResponseEB.success(result);
    }

    public Map<String, List<DownloadListDetail>> getGroupList(List<DownloadListDetail> downloadListDetails) {
        Map groupList = super.getGroupList(downloadListDetails);
        return groupList;
    }

    public List<DownloadListTask> getTasksByTransDateAndBankLogin(LocalDate transDate, String customId, String bankLoginId) {
        List taskList = this.downloadTaskService.findByCustomIdAndBankLoginAndTransDateAndStatus(customId, bankLoginId, transDate, transDate, TaskStatusEnum.PROCESSING.getId());
        return taskList;
    }

    public DownloadListTask getTasksByTransDateAndAccNoAndBank(LocalDate transDate, String accNo, String bankVersion) {
        List taskList = this.downloadTaskService.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersion, transDate, transDate);
        if (taskList.isEmpty()) {
            return null;
        }
        return (DownloadListTask)taskList.get(0);
    }

    public List<DownloadListDetail> doJob_pushMode(DownloadListTask task) {
        List<DownloadListDetail> result = this.getFileList(task);
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
        }
        return result;
    }

    private List<DownloadListDetail> getFileList(DownloadListTask task) {
        PDFFilter fitler;
        File[] files;
        File accFile;
        PDFFilter fitler2;
        File[] files2;
        LocalDate transDate;
        ArrayList<DownloadListDetail> fileList = new ArrayList<DownloadListDetail>(16);
        String bankVersionId = task.getBankVersionId();
        String accNo = task.getAccNo();
        String bankLoginId = task.getBankLoginId();
        LocalDate localDate = transDate = task.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        String sftp_path = ftpProperties.getFtpPath();
        String ftpPath = sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
        ChannelSftp sftp = null;
        String tempPath = FileStorageUtil.getFileBakPath((String)bankVersionId) + File.separator + transDateStr;
        String unZipDir = FileStorageUtil.getFileBatchBakPathByTransDate((String)bankVersionId, (String)transDateStr);
        ICBCOpaCommConfig config = (ICBCOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(ICBCOpaCommConfig.class, bankLoginId);
        String pushFileType = config.getPushFileType();
        String filterTransDate = transDateStr;
        String tempUpZipDir = unZipDir;
        List<DownloadListTask> downloadListTasks = this.getTasksByTransDateAndBankLogin(task.getTransDate(), task.getCustomNo(), task.getBankLoginId());
        File unZipFile = FileCommonUtils.getFileByPath((String)unZipDir);
        HashSet existReceiptMap = Sets.newHashSetWithExpectedSize((int)1);
        ICBCOpaFileParser icbcOpaFileParser = new ICBCOpaFileParser();
        if (unZipFile.exists() && (files2 = unZipFile.listFiles(fitler2 = new PDFFilter(transDateStr, pushFileType))) != null && files2.length > 0) {
            for (File receiptFile : files2) {
                icbcOpaFileParser.setFileName(receiptFile.getName());
                String receiptAccNo = icbcOpaFileParser.getAccNo();
                existReceiptMap.add(receiptAccNo);
            }
        }
        boolean isNeedDownloadZip = false;
        for (DownloadListTask downloadListTask : downloadListTasks) {
            if (existReceiptMap.contains(downloadListTask.getAccNo())) continue;
            isNeedDownloadZip = true;
            break;
        }
        if (isNeedDownloadZip) {
            block18: {
                try {
                    List<String> filenames;
                    if (ftpProperties.getReceiptAchieveWay().equals("sftp")) {
                        Vector vector;
                        if (SFTPUtils.getInstance().isAbort(sftp)) {
                            sftp = SFTPUtils.getInstance().getSftp();
                        }
                        if (sftp == null || !EBGStringUtils.isNotEmpty((String)ftpPath) || (vector = sftp.ls(ftpPath)).isEmpty()) break block18;
                        String fileName = "";
                        boolean isCdPath = true;
                        for (int i = 0; i < vector.size(); ++i) {
                            ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)vector.get(i);
                            fileName = file.getFilename();
                            if (!fileName.endsWith(".zip")) continue;
                            try {
                                String fileDate = "";
                                fileDate = Objects.equals(pushFileType, "BJ_VERSION") ? fileName.split("_")[0] : fileName.split("_")[1];
                                String ld = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                                Date modifyTime = TodayReceiptUtils.getInstance().getSftpModifyTime(file);
                                LocalDate modifyDate = LocalDateUtil.date2LocalDate((Date)modifyTime);
                                if ((EBGStringUtils.isEmpty((String)fileDate) || !fileDate.contains(ld)) && !fileName.contains(ld) || modifyDate.equals(transDate) || !fileName.endsWith(".zip") || fileName.contains("_DZD_Month")) continue;
                                if (!isCdPath) {
                                    ftpPath = "";
                                }
                                RequestContextUtils.setZipName((String)fileName);
                                boolean flag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, fileName, tempPath, sftp);
                                if (!flag) continue;
                                isCdPath = false;
                                if (!GZFileUtils.unZipFiles((String)(tempPath + File.separator + fileName), (String)unZipDir)) continue;
                                FileCommonUtils.getFileByPath((String)(tempPath + File.separator + fileName)).delete();
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        break block18;
                    }
                    if (ftpProperties.getReceiptAchieveWay().equals("bank_login") && (filenames = this.getFileByName(transDateStr, task.getAccNo(), task.getTransDate(), ".zip")) != null && filenames.size() > 0) {
                        for (String filename : filenames) {
                            if (filename.contains("_DZD_Month")) continue;
                            RequestContextUtils.setZipName((String)filename);
                            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, task.getTransDate());
                            boolean flag = bankReceiptApiUtil.downloadReceiptFile(filename, tempPath);
                            PDFFilter fitler3 = new PDFFilter(filterTransDate, pushFileType);
                            this.handleFiles(filename, transDateStr, flag, fitler3, tempPath, tempUpZipDir);
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u884c\u7535\u5b50\u56de\u5355\u6587\u4ef6\u5217\u8868\u4efb\u52a1\uff0cSFTP\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002\u8bf7\u68c0\u67e5\u56de\u5355\u5e73\u53f0SFTP\u914d\u7f6e\u4fe1\u606f\u548cSFTP\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u884c\uff0c\u5e76\u4f7f\u7528SFTP\u5de5\u5177\u786e\u8ba4\u662f\u5426\u53ef\u8fde\u901a\u3002", (String)"BankReceiptFetchListImpl_7", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]), e.getMessage());
                        throw new ReceiptException(msg, e.getCause());
                    }
                    catch (Throwable throwable) {
                        SFTPUtils.getInstance().close(sftp);
                        throw throwable;
                    }
                }
            }
            SFTPUtils.getInstance().close(sftp);
        }
        if ((accFile = FileCommonUtils.getFileByPath((String)tempUpZipDir)).exists() && (files = accFile.listFiles(fitler = new PDFFilter(filterTransDate, pushFileType))).length > 0) {
            for (int j = 0; j < files.length; ++j) {
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileName(files[j].getName());
                detail.setBankFilePath(files[j].getPath());
                fileList.add(detail);
            }
        }
        return fileList;
    }

    private void handleFiles(String fileName, String transDate, boolean flag, PDFFilter fitler, String tempPath, String tempUpZipDir) {
        if (flag) {
            String bankVersionId = EBContext.getContext().getBankVersionID();
            String unZipDir = FileStorageUtil.getFileBatchBakPathByTransDate((String)bankVersionId, (String)transDate);
            if (GZFileUtils.unZipFiles((String)(tempPath + File.separator + fileName), (String)unZipDir)) {
                FileCommonUtils.getFileByPath((String)(tempPath + File.separator + fileName)).delete();
            }
        }
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate, String suffix) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString, suffix);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    static class PDFFilter
    implements FileFilter {
        private String transDate;
        private String pushFileType;

        public PDFFilter(String transDate, String pushFileType) {
            this.transDate = transDate;
            this.pushFileType = pushFileType;
        }

        @Override
        public boolean accept(File file) {
            ICBCOpaFileParser icbcOpaFileParser = new ICBCOpaFileParser();
            icbcOpaFileParser.setFileName(file.getName());
            if (icbcOpaFileParser.getFileSplitLength() == 3) {
                return false;
            }
            if (Objects.equals(this.pushFileType, "OFD")) {
                return file.getName().contains(this.transDate) && file.getName().toLowerCase(Locale.ENGLISH).contains(".ofd");
            }
            return file.getName().contains(this.transDate) && file.getName().toLowerCase(Locale.ENGLISH).contains(".pdf");
        }
    }
}

