/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt.utils;

import com.icbc.api.request.MybankEnterpriseTradeLdownebillqryRequestV1;
import com.icbc.api.request.MybankEnterpriseTradeQhisdRequestV1;
import java.time.LocalDate;
import java.util.Date;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.api.TestDateUtil;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;

public class ICBC_OPA_Packer {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_OPA_Packer.class);

    public static MybankEnterpriseTradeQhisdRequestV1.MybankEnterpriseTradeQhisdRequestBizV1 packer(BankDetailRequest rqst, String pageTag) {
        MybankEnterpriseTradeQhisdRequestV1.MybankEnterpriseTradeQhisdRequestBizV1 bizContent = new MybankEnterpriseTradeQhisdRequestV1.MybankEnterpriseTradeQhisdRequestBizV1();
        String accNo = rqst.getAcnt().getAccNo();
        Date date = new Date();
        bizContent.setTransCode("QHISD");
        bizContent.setTranDate(TestDateUtil.getDate());
        bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
        bizContent.setLanguage("zh_CN");
        bizContent.setfSeqno(Sequence.gen18Sequence());
        bizContent.setAccountNo(accNo);
        bizContent.setCurrency(rqst.getBankCurrency());
        bizContent.setBeginDate(LocalDateUtil.formatDate((LocalDate)rqst.getStartDate(), (String)"yyyyMMdd"));
        bizContent.setEndDate(LocalDateUtil.formatDate((LocalDate)rqst.getEndDate(), (String)"yyyyMMdd"));
        bizContent.setNextTag(pageTag);
        return bizContent;
    }

    public static MybankEnterpriseTradeLdownebillqryRequestV1.MybankEnterpriseTradeLdownebillqryRequestBizV1 packerReceipt(String accNo, String onlySequence, String fileType, String bankCurrency, String transDateStr) {
        MybankEnterpriseTradeLdownebillqryRequestV1.MybankEnterpriseTradeLdownebillqryRequestBizV1 bizContent = new MybankEnterpriseTradeLdownebillqryRequestV1.MybankEnterpriseTradeLdownebillqryRequestBizV1();
        Date date = new Date();
        bizContent.setTransCode("LDOWNEBILL");
        bizContent.setTranDate(TestDateUtil.getDate());
        bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
        bizContent.setLanguage("zh_CN");
        bizContent.setfSeqNo(Sequence.gen18Sequence());
        bizContent.setAccountNo(accNo);
        bizContent.setCurrency(bankCurrency);
        bizContent.setEbillSerialNo(onlySequence);
        bizContent.setFileType(fileType);
        bizContent.setWorkDate(transDateStr);
        return bizContent;
    }
}

