/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbcb.dc.services.login;

import java.util.Date;
import java.util.Objects;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.receipt.banks.nbcb.dc.services.NBCBEBankDataHelper;
import kd.ebg.receipt.banks.nbcb.dc.services.login.AbstractLoginImpl;
import kd.ebg.receipt.banks.nbcb.dc.services.login.LoginAndOutPacker;
import kd.ebg.receipt.banks.nbcb.dc.services.login.LoginAndOutParser;
import kd.ebg.receipt.banks.nbcb.dc.services.receipt.NBCBDcCommConfig;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class LoginAndOut
extends AbstractLoginImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(LoginAndOut.class);
    private static LoginAndOut loginAndOut = null;
    private String loginSessionId = null;
    private Date lastLoginTime;
    private long sessionTime = 600000L;

    @Override
    public String pack() {
        String sequenceComm = Sequence.gen16Sequence();
        String loginMsg = LoginAndOutPacker.packLoginMsg(sequenceComm);
        return loginMsg;
    }

    @Override
    public String parse(String s) {
        String sequenceComm = Sequence.gen16Sequence();
        return LoginAndOutParser.parserSessionId(s, sequenceComm);
    }

    @Override
    public String getConnectionURI() {
        return "directlink/httpAccess";
    }

    @Override
    public int getTimeout() {
        return 1800;
    }

    public static synchronized LoginAndOut getLoginAndOut() {
        if (null == loginAndOut) {
            loginAndOut = new LoginAndOut();
        }
        return loginAndOut;
    }

    public synchronized void setNeedNewLoginSession() {
        this.loginSessionId = null;
    }

    public synchronized String loginSessionId4Pay() throws EBServiceException {
        Date now = new Date();
        if (null == this.loginSessionId || now.getTime() - this.lastLoginTime.getTime() > this.sessionTime) {
            this.loginSessionId = this.getNewLoginSession();
            this.lastLoginTime = new Date();
        }
        return this.loginSessionId;
    }

    public synchronized String loginSessionId4Query() throws EBServiceException {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        NBCBDcCommConfig nbcbDcCommConfig = (NBCBDcCommConfig)EBConfigBuilder.getInstance().buildConfig(NBCBDcCommConfig.class, bankLoginId);
        if (!Objects.equals(nbcbDcCommConfig.getIsNeedLogin(), "true")) {
            return "-1";
        }
        Date now = new Date();
        if (null == this.loginSessionId || now.getTime() - this.lastLoginTime.getTime() > this.sessionTime) {
            this.loginSessionId = this.getNewLoginSession();
            this.lastLoginTime = now;
        }
        return this.loginSessionId;
    }

    private String getNewLoginSession() throws EBServiceException {
        return super.doBiz();
    }

    public void configFactory(ConnectionFactory factory) {
        NBCBEBankDataHelper.configConnection(factory);
    }
}

