/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbcb.dc.services.receipt.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.nbcb.dc.services.NBCBEBankDataHelper;
import kd.ebg.receipt.banks.nbcb.dc.services.login.LoginAndOut;
import kd.ebg.receipt.banks.nbcb.dc.services.sign.SignService;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class AccountReceiptQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(AccountReceiptQueryImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String sessionId = LoginAndOut.getLoginAndOut().loginSessionId4Query();
        String userID = RequestContextUtils.getBankParameterValue((String)"userID");
        String serialNo = bankReceiptRequest.getRequestStr();
        String requestStr = this.receiptDetailPack(accNo, transDate, userID, sessionId, serialNo);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String detailPars = AccountReceiptQueryImpl.receiptDetailPars(responseStr);
        return BankReceiptResponseEB.success((Object)detailPars);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "srv193_accountReceiptQuery";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u67e5\u8be2", (String)"AccountReceiptQueryImpl_0", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]);
    }

    public String receiptDetailPack(String accNo, LocalDate transDate, String userID, String sessionId, String serialNo) {
        Element root = this.getRoot(userID, sessionId, "srv193_accountReceiptQuery", "01", "receiptDetail");
        Element opReq = JDomUtils.addChild((Element)root, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"ZHHA", (String)accNo);
        JDomUtils.addChild((Element)ReqParam, (String)"ZZH", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"CXRQ", (String)transDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        String signData = SignService.sign(opReq);
        JDomUtils.addChild((Element)root, (String)"signData", (String)signData);
        return JDomUtils.doc2Str((Document)new Document(root), (String)"", (String)"UTF-8", (boolean)false);
    }

    public Element getRoot(String userID, String sessionId, String serviceId, String functionId, String functionName) {
        Element root = JDomExtUtils.createRoot((String)"NBCBEBankData");
        JDomUtils.addChild((Element)root, (String)"sessionId", (String)sessionId);
        JDomUtils.addChild((Element)root, (String)"serviceId", (String)serviceId);
        JDomUtils.addChild((Element)root, (String)"customerId", (String)userID);
        JDomUtils.addChild((Element)root, (String)"softwareId", (String)"002");
        JDomUtils.addChild((Element)root, (String)"functionId", (String)functionId);
        JDomUtils.addChild((Element)root, (String)"functionName", (String)functionName);
        return root;
    }

    public static String receiptDetailPars(String response) {
        if ("".equals(response)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"AccountReceiptQueryImpl_1", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]));
        }
        Element root = JDomUtils.str2DocUTF8((String)response).getRootElement();
        String retCode = JDomUtils.getUnNullChildText((Element)root, (String)"retCode");
        String errorMsg = JDomUtils.getUnNullChildText((Element)root, (String)"errorMsg");
        if ("0000".equals(retCode) || "000000".equals(retCode)) {
            Element opRep = JDomUtils.getUnNullChildElement((Element)root, (String)"opRep");
            Element opResult = JDomUtils.getUnNullChildElement((Element)opRep, (String)"opResult");
            String YDDM = JDomUtils.getUnNullChildText((Element)opResult, (String)"YDDM");
            String SBYY = JDomUtils.getUnNullChildText((Element)opResult, (String)"SBYY");
            if ("0000".equals(YDDM) || "000000".equals(YDDM)) {
                String serialNo = JDomUtils.getUnNullChildText((Element)opResult, (String)"JYXH");
                return serialNo;
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u56de\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u5e94\u7b54\u4ee3\u7801\uff1a%s\u3002", (String)"AccountReceiptQueryImpl_6", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), YDDM) + String.format(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"AccountReceiptQueryImpl_7", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), SBYY));
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u56de\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u8fd4\u56de\u7801\uff1a%s\u3002", (String)"AccountReceiptQueryImpl_8", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), retCode) + String.format(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"AccountReceiptQueryImpl_9", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), errorMsg));
    }

    public void configFactory(ConnectionFactory factory) {
        NBCBEBankDataHelper.configConnection(factory);
    }
}

