/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ljb.dc.service.receipt.fetch;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ljb.dc.service.receipt.api.BankReceiptQueryApi;
import kd.ebg.receipt.banks.ljb.dc.service.receipt.api.GetReceiptFileApi;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        List downloadListDetailList = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        Map<String, DownloadListDetail> existMap = downloadListDetailList.stream().filter(o -> o.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()).collect(Collectors.toMap(DownloadListDetail::getFileName, o -> o));
        BankReceiptQueryApi bankReceiptQueryApi = new BankReceiptQueryApi();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        BankHeader header = new BankHeader();
        header.setAcnt(request.getAcnt());
        bankReceiptRequest.setHeader(header);
        BankReceiptResponseEB receiptResponseEB = bankReceiptQueryApi.doBiz(bankReceiptRequest);
        if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
            List detailInfoList = (List)receiptResponseEB.getData();
            RequestContextUtils.setRunningParam((String)"savePath", (String)bakPath);
            for (DetailInfo detailInfo : detailInfoList) {
                String fileName = detailInfo.getReversed1();
                String receiptFilePath = detailInfo.getExplanation();
                String json = detailInfo.getJson();
                if (existMap.containsKey(fileName)) {
                    DownloadListDetail downloadListDetail = existMap.get(fileName);
                    downloadListDetail.setReceiptJson(json);
                    result.add(downloadListDetail);
                    continue;
                }
                try {
                    File receiptFile;
                    String url = this.getDownloadUrl(receiptFilePath);
                    if (EBContext.getContext().getProxyType() != null) {
                        RequestContextUtils.setRunningParam((String)"fileName", (String)fileName);
                        GetReceiptFileApi getReceiptFileApi = new GetReceiptFileApi();
                        BankReceiptRequest receiptRequest = BankReceiptRequest.builder().receiptFileName(fileName).receiptDownloadURL(url).build();
                        getReceiptFileApi.doBiz(receiptRequest);
                    } else {
                        DownloadUtils.download((String)url, (String)fileName, (String)bakPath);
                    }
                    if (!(receiptFile = FileCommonUtils.getFileByPath((String)bakPath, (String)fileName)).exists()) continue;
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    downloadListDetail.setFileName(fileName);
                    downloadListDetail.setReceiptJson(json);
                    result.add(downloadListDetail);
                }
                catch (Throwable e) {
                    logger.error(receiptFilePath + "\u4e0b\u8f7d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), e);
                }
            }
            return BankReceiptHandleResponseEB.success(result);
        }
        throw new ReceiptException(receiptResponseEB.getMessage());
    }

    public String getDownloadUrl(String fileName) {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        return String.format("%s://%s:%s/api/file/downloadFileRemote?fileName=%s", protocol, ip, port, fileName);
    }
}

