/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zjws.opa.service.receipt.fetch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.detail.DetailInfoOnReceipt;
import kd.ebg.egf.common.utils.FetchDataUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.zjws.opa.service.receipt.api.BankReceiptApplyImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        return request.getTaskStatus().intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bankCurrency = request.getHeader().getAcnt().getCurrency();
        List detailInfoList = FetchDataUtils.queryDetailFromReceipt((String)request.getBankVersionId(), (String)request.getBankLoginId(), (String)accNo, (LocalDate)transDate, (String)bankCurrency);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)detailInfoList.size());
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(detailInfoList.size());
        BankReceiptApplyImpl bankReceiptApply = new BankReceiptApplyImpl();
        bankReceiptApply.getBizDesc();
        bankReceiptApply.getDeveloper();
        bankReceiptApply.getBizCode();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        bankReceiptRequest.setHeader(request.getHeader());
        for (DetailInfoOnReceipt detailInfoOnReceipt : detailInfoList) {
            DownloadListDetail downloadListDetail;
            String jsonStr = detailInfoOnReceipt.getJsonMap();
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String acSrlNo = jsonObject.getString("acSrlNo");
            bankReceiptRequest.setRequestStr(acSrlNo);
            String cdFlag = jsonObject.getString("tradeInOutFla");
            String amount = jsonObject.getString("tradeAmt");
            String fileName = this.packFileName(accNo, transDateStr, cdFlag, amount, acSrlNo, countMap);
            if (existMap.containsKey(fileName)) {
                downloadListDetail = (DownloadListDetail)existMap.get(fileName);
                downloadListDetail.setReceiptJson(jsonStr);
                result.add(downloadListDetail);
                continue;
            }
            downloadListDetail = new DownloadListDetail();
            BankReceiptResponseEB receiptResponseEB = bankReceiptApply.doBiz(bankReceiptRequest);
            if (receiptResponseEB.getCode() != BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) continue;
            String boNo = (String)receiptResponseEB.getData();
            String fileLink = String.format("%s%s_%s.pdf", accNo, PropertiesConstantsUtils.getValue((String)"RECEIPT"), boNo);
            downloadListDetail.setFileName(fileName);
            downloadListDetail.setFileLink(fileLink);
            downloadListDetail.setReceiptJson(jsonStr);
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String packFileName(String accNo, String transDateStr, String cdFlag, String Amount, String serialNo, Map<String, Integer> countMap) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(accNo).append("_");
        fileName.append(transDateStr).append("_");
        fileName.append(cdFlag).append("_");
        fileName.append(Amount).append("_");
        fileName.append(serialNo);
        if (countMap.containsKey(fileName.toString())) {
            int recount = countMap.get(fileName.toString());
            countMap.put(fileName.toString(), recount + 1);
            fileName.append("_").append(String.format("%04d", recount + 1));
        } else {
            countMap.put(fileName.toString(), 0);
        }
        fileName.append(".pdf");
        return fileName.toString();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean isBreak() {
        return true;
    }
}

