/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ebg.cus.util;

import java.lang.reflect.Constructor;
import java.time.LocalDate;
import java.util.List;
import kd.sdk.ebg.cus.api.ISDKFetchData;
import kd.sdk.ebg.cus.api.ISDKFetchReceiptData;
import kd.sdk.ebg.cus.bean.bank.receipt.SDKReceiptDetail;
import kd.sdk.ebg.cus.bean.biz.detail.SDKDetailInfo;
import kd.sdk.ebg.trd.exception.SDKException;

public class SDKFetchDataUtil {
    private static ISDKFetchData isdkFetchData;
    private static ISDKFetchReceiptData isdkFetchReceiptData;

    private static synchronized void initReceipt() throws SDKException {
        if (isdkFetchReceiptData == null) {
            try {
                Constructor<?> constructor = Class.forName("kd.ebg.receipt.banks.cus.other.FetchDataImpl").getConstructor(new Class[0]);
                isdkFetchReceiptData = (ISDKFetchReceiptData)constructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new SDKException("ISDKFetchReceiptData error", e);
            }
        }
    }

    private static synchronized void init() throws SDKException {
        if (isdkFetchData == null) {
            try {
                Constructor<?> constructor = Class.forName("kd.ebg.aqap.banks.cus.other.FetchDataImpl").getConstructor(new Class[0]);
                isdkFetchData = (ISDKFetchData)constructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new SDKException("ISDKFetchData error", e);
            }
        }
    }

    public static String getBankLoginConfigValue(String configID) throws SDKException {
        SDKFetchDataUtil.init();
        if (isdkFetchData != null) {
            return isdkFetchData.getBankLoginConfigValues(configID);
        }
        return "";
    }

    public static String getBankBusinessConfigValue(String configID) throws SDKException {
        SDKFetchDataUtil.init();
        if (isdkFetchData != null) {
            return isdkFetchData.getBankBusinessConfigValue(configID);
        }
        return "";
    }

    public static String getBankAcntConfigValue(String accNo, String configID) throws SDKException {
        SDKFetchDataUtil.init();
        if (isdkFetchData != null) {
            return isdkFetchData.getBankAcntConfigValue(accNo, configID);
        }
        return "";
    }

    public static void setCurrentPage(int val) throws SDKException {
        SDKFetchDataUtil.init();
        if (isdkFetchData != null) {
            isdkFetchData.setCurrentPage(val);
        }
    }

    public static int getCurrentPage() throws SDKException {
        SDKFetchDataUtil.init();
        if (isdkFetchData != null) {
            return isdkFetchData.getCurrentPage();
        }
        throw new SDKException("ISDKFetchData getCurrentPage error");
    }

    public static void setLastPage(boolean val) throws SDKException {
        SDKFetchDataUtil.init();
        if (isdkFetchData != null) {
            isdkFetchData.setLastPage(val);
        }
    }

    public static boolean isLastPage() throws SDKException {
        SDKFetchDataUtil.init();
        if (isdkFetchData != null) {
            return isdkFetchData.isLastPage();
        }
        throw new SDKException("ISDKFetchData isLastPage error");
    }

    public static void setDevParam(String val) throws SDKException {
        SDKFetchDataUtil.init();
        if (isdkFetchData != null) {
            isdkFetchData.setDevParam(val);
        }
    }

    public static String getDevParam() throws SDKException {
        SDKFetchDataUtil.init();
        if (isdkFetchData != null) {
            return isdkFetchData.getDevParam();
        }
        throw new SDKException("ISDKFetchData getDevParam error");
    }

    public static String getReceiptFileStoragePath(String accNo, LocalDate transDate) throws SDKException {
        SDKFetchDataUtil.initReceipt();
        if (isdkFetchReceiptData != null) {
            return isdkFetchReceiptData.getReceiptFileStoragePath(accNo, transDate);
        }
        throw new SDKException("ISDKFetchReceiptData getReceiptFileStoragePath error");
    }

    public static List<SDKReceiptDetail> getReceiptDetailById(long taskId) throws SDKException {
        SDKFetchDataUtil.initReceipt();
        if (isdkFetchReceiptData != null) {
            return isdkFetchReceiptData.getReceiptDetailById(taskId);
        }
        throw new SDKException("ISDKFetchReceiptData getReceiptDetailById error");
    }

    public static boolean downloadFileByPathAndName(String parentPath, String fileName, String savePath) throws SDKException {
        SDKFetchDataUtil.initReceipt();
        if (isdkFetchReceiptData != null) {
            return isdkFetchReceiptData.downloadFileByPathAndName(parentPath, fileName, savePath);
        }
        throw new SDKException("ISDKFetchReceiptData downloadFileByPathAndName error");
    }

    public static List<SDKDetailInfo> getTransDetail(String accNo, LocalDate transDate, String bankCurrency) throws SDKException {
        SDKFetchDataUtil.initReceipt();
        if (isdkFetchReceiptData != null) {
            return isdkFetchReceiptData.getTransDetail(accNo, transDate, bankCurrency);
        }
        throw new SDKException("ISDKFetchReceiptData getTransDetail error");
    }
}

