/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.opa.service;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.opa.service.Check;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class ParserRsp {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(ParserRsp.class);

    public static BankResponse parseRsp(String rspStr) {
        if (null == rspStr || rspStr.indexOf("</packet>") == -1) {
            String err = ResManager.loadKDString((String)"\u94f6\u884c\u53d1\u56de\u7684\u54cd\u5e94\u62a5\u6587\uff08\u7b7e\u540d\uff09\u683c\u5f0f\u9519\u8bef\uff0c\u6ca1\u6709\u4ee5'</packet>'\u7ed3\u5c3e.", (String)"ParserRsp_0", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]);
            log.error(err);
            throw EBExceiptionUtil.serviceException((String)err);
        }
        BankResponse rsp = new BankResponse();
        int retcodeS = Check.getSignIndex(rspStr, "<returnCode>");
        int retcodeE = Check.getSignIndex(rspStr, "</returnCode>");
        String responseCode = rspStr.substring(retcodeS + "<returnCode>".length(), retcodeE);
        rsp.setResponseCode(responseCode);
        if (!"AAAAAAA".equals(responseCode)) {
            int retMsgS = Check.getSignIndex(rspStr, "<returnMsg>");
            int retMsgE = Check.getSignIndex(rspStr, "</returnMsg>");
            String responseMessage = rspStr.substring(retMsgS + "<returnMsg>".length(), retMsgE);
            rsp.setResponseMessage(responseMessage);
        } else {
            rsp.setResponseMessage("");
        }
        return rsp;
    }
}

