/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opa.service.apply;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opa.service.apply.ApplyImpl;
import kd.ebg.aqap.banks.gdb.opa.service.apply.ApplyPacker;
import kd.ebg.aqap.banks.gdb.opa.util.Parser;
import kd.ebg.aqap.banks.gdb.opa.util.SMUtil;
import kd.ebg.aqap.banks.gdb.opa.util.SendUtil;
import kd.ebg.aqap.business.apply.atomic.AbstractQueryApplyImpl;
import kd.ebg.aqap.business.apply.atomic.IQueryApply;
import kd.ebg.aqap.business.apply.bank.BankQueryApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankQueryApplyResponse;
import kd.ebg.aqap.common.constant.ApplyStatusEnum;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryApplyImpl
extends AbstractQueryApplyImpl
implements IQueryApply {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ApplyImpl.class);

    public String pack(BankQueryApplyRequest bankQueryApplyRequest) {
        return ApplyPacker.pack("S", bankQueryApplyRequest.getAcnt().getAccNo(), SMUtil.getUserPublicKey());
    }

    public EBBankQueryApplyResponse doBiz(BankQueryApplyRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = SendUtil.send(this.getBizCode(), rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankQueryApplyResponse parse(BankQueryApplyRequest bankQueryApplyRequest, String s) {
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        Parser.parseHeader(jsonObject.getJSONObject("Header"), this.getBizDesc());
        JSONObject body = jsonObject.getJSONObject("Body");
        String sysRetCode = body.getString("bizRetCode");
        String sysRetInfo = body.getString("bizRetInfo");
        if (!"000000".equals(sysRetCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21%1$s\u4e1a\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u8fd4\u56de\u7801:%2$s,\u5f02\u5e38\u4fe1\u606f\uff1a%3$s", (String)"QueryApplyImpl_5", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), this.getBizDesc(), sysRetCode, sysRetInfo);
            logger.info(errorMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String authStatus = body.getString("authStatus");
        EBBankQueryApplyResponse result = new EBBankQueryApplyResponse();
        result.setThirdVoucher(bankQueryApplyRequest.getThirdVoucher());
        result.setAccNo(bankQueryApplyRequest.getAccountNo());
        Integer status = this.buildStatus(authStatus);
        result.setStatus(status + "");
        result.setDesc(ApplyStatusEnum.getNameById((int)status));
        String entCstNo = body.getString("entCstNo");
        BankLoginConfigService service = (BankLoginConfigService)SpringContextUtil.getBean(BankLoginConfigService.class);
        service.saveBankLoginConfig("cst_no", entCstNo, bankQueryApplyRequest.getAcnt().getBankLoginId(), bankQueryApplyRequest.getAcnt().getCustomID());
        logger.info("\u5ba2\u6237\u53f7{}\u66f4\u65b0\u5230\u524d\u7f6e\u673a\u914d\u7f6e\u6210\u529f\uff01", (Object)entCstNo);
        return result;
    }

    public Integer buildStatus(String bankStatus) {
        if ("1".equalsIgnoreCase(bankStatus)) {
            return ApplyStatusEnum.SUCCESS.getId();
        }
        if ("0".equalsIgnoreCase(bankStatus)) {
            return ApplyStatusEnum.PENDING_GRANT.getId();
        }
        if ("2".equalsIgnoreCase(bankStatus)) {
            return ApplyStatusEnum.FAIL.getId();
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u6388\u6743\u72b6\u6001[%s]\uff01", (String)"QueryApplyImpl_6", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), bankStatus));
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "serviceApplyAuth";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u7b7e\u7ea6\u7ed3\u679c", (String)"QueryApplyImpl_4", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]);
    }
}

