/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ghb.dc.services.payment.company;

import kd.ebg.aqap.banks.ghb.dc.services.utils.GHB_DC_Packer;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

class PayPacker {
    PayPacker() {
    }

    public static String packPay(PaymentInfo paymentInfos) {
        return PayPacker.createMessage(paymentInfos);
    }

    private static String createMessage(PaymentInfo paymentInfo) {
        String amount = paymentInfo.getAmount().setScale(2, 4).toString();
        String encoding = RequestContextUtils.getCharset();
        String transCode = "ZTSA63F01";
        String reqSeqNo = paymentInfo.getBankDetailSeqId();
        Element root = GHB_DC_Packer.createHead(reqSeqNo, transCode);
        JDomUtils.addChild((Element)root, (String)"PAYACCTNO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)root, (String)"RCVACCTNO", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)root, (String)"RCVACCTNAME", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)root, (String)"RCVACCTFLAG", (String)(paymentInfo.is2Individual() ? "1" : "2"));
        String chnl = "3";
        chnl = paymentInfo.is2SameBank() ? "3" : (paymentInfo.is2Urgent() ? "1" : "0");
        JDomUtils.addChild((Element)root, (String)"CHNL", (String)chnl);
        String bankNo = paymentInfo.getIncomeCnaps();
        if ("3".equals(chnl)) {
            JDomUtils.addChild((Element)root, (String)"RCVBANKNO", (String)"");
        } else {
            JDomUtils.addChild((Element)root, (String)"RCVBANKNO", (String)bankNo);
        }
        JDomUtils.addChild((Element)root, (String)"CCY", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)root, (String)"TRNAMT", (String)amount);
        JDomUtils.addChild((Element)root, (String)"MEMOCD", (String)"ZZ");
        JDomUtils.addChild((Element)root, (String)"REMARK", (String)paymentInfo.getExplanation());
        return JDomUtils.root2String((Element)root, (String)encoding);
    }
}

