/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdnx.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdnx.dc.services.SDNX_DC_Packer;
import kd.ebg.aqap.banks.sdnx.dc.services.SDNX_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public void configFactory(ConnectionFactory factory) {
        StringBuilder uri = new StringBuilder("/eweb/b2econnect.do");
        String signFlag = RequestContextUtils.getBankParameterValue((String)"signData");
        String accessnum = RequestContextUtils.getBankParameterValue((String)"password");
        if (StringUtils.isEmpty((String)signFlag) || "0".equalsIgnoreCase(signFlag)) {
            uri.append("?userPassword=").append(accessnum).append("&SIGDATA=0");
        } else {
            uri.append("?userPassword=").append(accessnum).append("&SIGDATA=1");
        }
        factory.setUri(uri.toString());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QRCB001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5c71\u4e1c\u519c\u4fe1\u793e\u67e5\u8be2\u5f53\u65e5\u4f59\u989d(QRCB001)\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest req) {
        Element root = SDNX_DC_Packer.getCommonHeader("QRCB001", RequestContextUtils.getRequestContext().getBankRequestSeq(), LocalDateTime.now());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)req.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayerCurrency", (String)req.getBankCurrency());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest req, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = SDNX_DC_Parser.parserCommonHeader(root);
        if (null == bankResponse.getResponseCode() || !"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u51fa\u9519\u3002", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]));
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element map = JDomUtils.getChildElement((Element)body, (String)"Map");
        String AcName = JDomUtils.getChildText((Element)map, (String)"AcName");
        BalanceInfo bankInfo = new BalanceInfo();
        this.setBalanceDateTime(bankInfo, LocalDateTime.now());
        this.setBankAcnt(bankInfo, req.getAcnt());
        this.setBankCurrency(bankInfo, req.getBankCurrency());
        if (null == AcName || !req.getAcnt().getAccName().equals(AcName)) {
            bankInfo.setError(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u8d26\u53f7\u4e0d\u5339\u914d\u3002", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]));
            return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{bankInfo}));
        }
        String balance = JDomUtils.getChildText((Element)map, (String)"CurrentBalance");
        String avabBalance = JDomUtils.getChildText((Element)map, (String)"AvailBalance");
        this.setAvailableBalance(bankInfo, avabBalance);
        this.setCurrentBalance(bankInfo, balance);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{bankInfo}));
    }
}

