/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdnx.dc.services.payment.inner;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdnx.dc.services.SDNX_DC_Packer;
import kd.ebg.aqap.banks.sdnx.dc.services.SDNX_DC_Parser;
import kd.ebg.aqap.banks.sdnx.dc.services.payment.inner.SameBankQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SameBankPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SameBankQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "QRCB003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"SameBankPayImpl_0", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u7b14\u4ed8\u6b3e\u3002", (String)"SameBankPayImpl_1", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]));
        }
        Element root = SDNX_DC_Packer.getCommonHeader("QRCB003", info.getBankBatchSeqId(), LocalDateTime.now());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayeeAcNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"PayeeAcName", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"Amount", (String)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
        JDomUtils.addChild((Element)body, (String)"Currency", (String)info.getCurrency());
        JDomUtils.addChild((Element)body, (String)"payUse", (String)info.getExplanation());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = SDNX_DC_Parser.parserCommonHeader(root);
        if (null == bankResponse.getResponseCode() || !"000000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
            Element map = JDomUtils.getChildElement((Element)body, (String)"Map");
            String orderState = JDomUtils.getChildText((Element)map, (String)"orderState");
            String orderFlowDescript = JDomUtils.getChildText((Element)map, (String)"orderFlowDescript");
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SameBankPayImpl_2", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]), (String)orderState, (String)orderFlowDescript);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder uri = new StringBuilder("/eweb/b2econnect.do");
        String signFlag = RequestContextUtils.getBankParameterValue((String)"signData");
        String accessnum = RequestContextUtils.getBankParameterValue((String)"password");
        if (StringUtils.isEmpty((String)signFlag) || "0".equalsIgnoreCase(signFlag)) {
            uri.append("?userPassword=").append(accessnum).append("&SIGDATA=0");
        } else {
            uri.append("?userPassword=").append(accessnum).append("&SIGDATA=1");
        }
        factory.setUri(uri.toString());
    }
}

