/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.areacode;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.banks.cmb.opa.area.CMBArea;
import kd.ebg.aqap.banks.cmb.opa.area.CMBStore;
import kd.ebg.aqap.banks.cmb.opa.service.balance.HisBalanceImpl;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class AreaCodeImpl
extends AbstractBankXmlImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);
    public static volatile AreaCodeImpl instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AreaCodeImpl getInstance() {
        if (null != instance) return instance;
        Class<CMBStore> clazz = CMBStore.class;
        synchronized (CMBStore.class) {
            if (null != instance) return instance;
            instance = new AreaCodeImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getAreaCode(String accno) {
        if (this.canDoIt()) {
            try {
                String requestStr = this.pack(accno);
                String responseStr = PostUtil.sendMsg(requestStr);
                return this.parse(responseStr);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5206\u884c\u53f7\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u884c\u53f7\u5931\u8d25:%s\u3002", (String)"AreaCodeImpl_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u9650\u6d41 \u8c03\u7528\u9891\u7387\u4e3a : %s\u6beb\u79d2\u3002", (String)"AreaCodeImpl_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), this.getInterval()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getAreaCode(BankAcnt acnt) {
        String accNo = acnt.getAccNo();
        String branchNo = acnt.getAreaCode();
        if (StringUtils.isEmpty((String)branchNo)) {
            CMBArea cmbArea;
            String province = acnt.getProvince();
            String city = acnt.getCity();
            if (!StringUtils.isEmpty((String)city)) {
                cmbArea = CMBStore.getInstance().matchCity(city);
                if (cmbArea == null) {
                    logger.error("\u901a\u8fc7matchCity\u65b9\u6cd5\u67e5\u8be2\u5206\u884c\u53f7\u5931\u8d25");
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u884c\u53f7\u5931\u8d25\u3002", (String)"AreaCodeImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
                }
                branchNo = cmbArea.getBranchBankCode();
            } else if (!StringUtils.isEmpty((String)province)) {
                cmbArea = CMBStore.getInstance().matchProvince(province);
                if (cmbArea == null) {
                    logger.error("\u901a\u8fc7matchProvince\u65b9\u6cd5\u67e5\u8be2\u5206\u884c\u53f7\u5931\u8d25");
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u884c\u53f7\u5931\u8d25\u3002", (String)"AreaCodeImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
                }
                branchNo = cmbArea.getBranchBankCode();
            } else {
                branchNo = this.getAreaCode(accNo);
            }
            if (StringUtils.isNotEmpty((String)branchNo)) {
                ObjectPropertyService objectPropertyService = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
                objectPropertyService.saveAcntProperties("bank_area_code", branchNo, accNo);
            }
        }
        return branchNo;
    }

    public long getBankInterval() {
        return 0L;
    }

    public String pack(String accno) {
        JSONObject body = new JSONObject();
        body.put("fctval", (Object)accno);
        String bizCode = "NTACCBBK";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        JSONObject json = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(json, logger, bizCode);
    }

    public String parse(String responseStr) {
        String res = MsgParser.getReceMsg(responseStr, logger);
        return this.parseAreaCode(res);
    }

    public String parseAreaCode(String res) {
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a", (String)"AreaCodeImpl_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray array = body.getJSONArray("ntaccbbkz");
        String areaCode = "";
        for (int i = 0; i < array.size(); ++i) {
            JSONObject detail = array.getJSONObject(i);
            String accnbr = detail.getString("fctval");
            areaCode = detail.getString("bbknbr");
        }
        return areaCode;
    }
}

