/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.balancereconciliation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractQueryBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IQueryBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankQueryBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankQueryBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryBalanceReconciliationImpl
extends AbstractQueryBalanceReconciliationImpl
implements IQueryBalanceReconciliation {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBalanceReconciliationImpl.class);

    public EBBankQueryBalanceReconciliationResponse doBiz(BankQueryBalanceReconciliationRequest request) {
        try {
            String rqstStr = this.pack(request);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(request, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankQueryBalanceReconciliationRequest request) {
        BalanceReconciliationDetail detail = request.getDetail();
        JSONObject body = new JSONObject();
        JSONArray ntnstqryx = new JSONArray();
        JSONObject ntnstqryx1 = new JSONObject();
        ntnstqryx.add((Object)ntnstqryx1);
        String reqnbr = detail.getSys("reqnbr");
        if (StringUtils.isEmpty((String)reqnbr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f59\u989d\u5bf9\u8d26\u7ed3\u679c\u5931\u8d25\uff0c\u53cd\u9988\u4f59\u989d\u5bf9\u8d26\u65f6\u672a\u83b7\u53d6\u5230\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u5b57\u6bb5reqnbr\u3002", (String)"QueryBalanceReconciliationImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        ntnstqryx1.put("reqnbr", (Object)reqnbr);
        ntnstqryx1.put("eacnbr", (Object)detail.getAccNo());
        ntnstqryx1.put("yermth", (Object)detail.getMonth());
        ntnstqryx1.put("endmth", (Object)detail.getMonth());
        ntnstqryx1.put("cntflg", (Object)"");
        body.put("ntnstqryx", (Object)ntnstqryx);
        String bizCode = this.getBizCode();
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(req, this.logger, bizCode);
    }

    public EBBankQueryBalanceReconciliationResponse parse(BankQueryBalanceReconciliationRequest BankQueryBalanceReconciliationRequest2, String s) {
        BalanceReconciliationDetail detail = BankQueryBalanceReconciliationRequest2.getDetail();
        String res = MsgParser.getReceMsg(s, this.logger);
        BankResponse response = MsgParser.getResponse(res, this.logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"QueryBalanceReconciliationImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject root = JSONObject.parseObject((String)res);
        JSONObject resp = root.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntnstqryz = body.getJSONArray("ntnstqryz");
        if (ntnstqryz == null || ntnstqryz.size() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56dentoprrtnz\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"QueryBalanceReconciliationImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        JSONObject jsonObject = ntnstqryz.getJSONObject(0);
        String reqSts = jsonObject.getString("stscod");
        String errtxt = jsonObject.getString("errtxt");
        if ("5".equalsIgnoreCase(reqSts)) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUCCESS, (String)reqSts, (String)"");
        } else if ("1".equalsIgnoreCase(reqSts) || "3".equalsIgnoreCase(reqSts)) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUBMITED, (String)reqSts, (String)"");
        } else {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.UNKNOWN, (String)reqSts, (String)errtxt);
        }
        return new EBBankQueryBalanceReconciliationResponse(detail);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NTNSTQRY2";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u4f59\u989d\u5bf9\u8d26\u7ed3\u679c\u3002", (String)"QueryBalanceReconciliationImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(BankQueryBalanceReconciliationRequest request) {
        return true;
    }
}

