/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.curandfixed.notice2cur;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;

public class CurAndFixedImpl
extends AbstractCAFImpl
implements ICurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CurAndFixedImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        String bizCode = "NTSMANTF";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        BankAcnt acnt = bankCurAndFixedRequest.getHeader().getAcnt();
        JSONObject ntsmantfx = new JSONObject();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0);
        String busmod = BankBusinessConfig.getCurAndNotiiBusMod(acnt.getAccNo());
        ntsmantfx.put("buscod", (Object)"N08020");
        ntsmantfx.put("busmod", (Object)busmod);
        String areaCode = AreaCodeImpl.getInstance().getAreaCode(acnt);
        ntsmantfx.put("bbknbr", (Object)areaCode);
        ntsmantfx.put("accnbr", (Object)curAndFixedInfo.getAccNo());
        ntsmantfx.put("fixbbk", (Object)curAndFixedInfo.getFixedAcntBankNo());
        ntsmantfx.put("fixacc", (Object)curAndFixedInfo.getFixedAccNo());
        ntsmantfx.put("ccynbr", (Object)curAndFixedInfo.getCurrency());
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal add = amount.add(new BigDecimal(curAndFixedInfo.getAmount()));
        if (add.compareTo(new BigDecimal("500000")) < 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"<Check>\u652f\u53d6\u901a\u77e5\u8d26\u6237\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e500000</Check>\u3002", (String)"CurAndFixedImpl_9", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        ntsmantfx.put("trsamt", (Object)curAndFixedInfo.getAmount());
        ntsmantfx.put("yurref", (Object)PaymentUtil.addKDFlag(curAndFixedInfo.getBatchSeqId()));
        JSONArray array = new JSONArray();
        array.add((Object)ntsmantfx);
        JSONObject body = new JSONObject();
        body.put("ntsmantfx", (Object)array);
        JSONObject request = JsonUtil.getrequest(head, body);
        if (EBContext.getContext().isUnitTest()) {
            return "";
        }
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public EBBankCurAndFixedResponse doBiz(BankCurAndFixedRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        String res = MsgParser.getReceMsg(s, logger);
        return this.parse(res, bankCurAndFixedRequest);
    }

    public EBBankCurAndFixedResponse parse(String res, BankCurAndFixedRequest bankCurAndFixedRequest) {
        JSONObject object;
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%S\u3002", (String)"CurAndFixedImpl_12", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntsmantfz = body.getJSONArray("ntsmantfz");
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        if (!ntsmantfz.isEmpty() && !(object = ntsmantfz.getJSONObject(0)).isEmpty()) {
            Date date;
            String infdat = object.getString("infdat");
            String expdat = object.getString("expdat");
            try {
                date = DateTimeUtils.parseDate((String)infdat, (String)"yyyyMMdd");
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            Instant instant = date.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDateTime localDate = instant.atZone(zoneId).toLocalDateTime();
            CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
            curAndFixedInfo.setEndDate(expdat);
            curAndFixedInfo.setTranDate(localDate);
        }
        ebBankCurAndFixedResponse.setDetails(bankCurAndFixedRequest.getCafInfos());
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

