/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.other;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.payment.BusModUtil;
import kd.ebg.aqap.banks.cmb.opa.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

class PayPacker {
    PayPacker() {
    }

    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);
        String busMod = BankBusinessConfig.getcmb_cmp_NTAGCAPY_busmodBusmod(paymentInfos[0].getAccNo());
        if (StringUtils.isEmpty((String)busMod)) {
            logger.info("\u94f6\u4f01\u672a\u7ef4\u62a4\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\uff0c\u4ece\u94f6\u884c\u83b7\u53d6");
            busMod = BusModUtil.getBusMod("N03020");
            String busModName = ResManager.loadKDString((String)"\u4ee3\u53d1\u5176\u4ed6\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7", (String)"PayPacker_10", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
            if (StringUtils.isEmpty((String)busMod)) {
                throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"%s\u4e3a\u7a7a\uff0c\u8bf7\u767b\u9646\u7f51\u94f6\u6216\u8005\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"PayPacker_14", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), busModName));
            }
            if (busMod.contains(",")) {
                throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"%1$s\u6709\u591a\u4e2a%2$s\uff0c\u8bf7\u4e8e\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u4e2d\u624b\u52a8\u914d\u7f6e\u552f\u4e00\u7684\u2018%3$s\u2019\u3002", (String)"PayPacker_16", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), busModName, busMod, busModName));
            }
            ObjectPropertyService objectPropertyService = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
            objectPropertyService.saveAcntProperties("cmb_cmp_NTAGCAPY_busmod", busMod, paymentInfos[0].getAccNo());
        }
        JSONObject body = new JSONObject();
        JSONObject ntbusmody = new JSONObject();
        ntbusmody.put("busmod", (Object)busMod);
        JSONArray array0 = new JSONArray();
        array0.add((Object)ntbusmody);
        body.put("ntbusmody", (Object)array0);
        JSONArray array = new JSONArray();
        BigDecimal totalAmt = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            PaymentInfo info = paymentInfos[i];
            JSONObject ntqacinfx = new JSONObject();
            ntqacinfx.put("trxseq", (Object)BusModUtil.getSerialNo(info.getBankSerialNo()));
            ntqacinfx.put("accnbr", (Object)info.getIncomeAccNo());
            ntqacinfx.put("accnam", (Object)info.getIncomeAccName());
            ntqacinfx.put("trsamt", (Object)info.getAmount().toString());
            ntqacinfx.put("trsdsp", (Object)info.getExplanation());
            if (info.is2SameBank()) {
                ntqacinfx.put("bnkflg", (Object)"Y");
            } else {
                ntqacinfx.put("bnkflg", (Object)"N");
                ntqacinfx.put("eacbnk", (Object)info.getIncomeBankName());
                ntqacinfx.put("eaccty", (Object)info.getIncomeCity());
            }
            totalAmt = totalAmt.add(info.getAmount());
            array.add((Object)ntqacinfx);
        }
        body.put("ntagcdtly1", (Object)array);
        JSONObject ntagcagcx1 = new JSONObject();
        ntagcagcx1.put("begtag", (Object)"Y");
        ntagcagcx1.put("endtag", (Object)"Y");
        ntagcagcx1.put("ttlamt", (Object)totalAmt.toString());
        ntagcagcx1.put("ttlcnt", (Object)paymentInfos.length);
        ntagcagcx1.put("ttlnum", (Object)"1");
        ntagcagcx1.put("curamt", (Object)totalAmt.toString());
        ntagcagcx1.put("curcnt", (Object)paymentInfos.length);
        ntagcagcx1.put("ccynbr", (Object)paymentInfos[0].getCurrency());
        ntagcagcx1.put("bbknbr", (Object)paymentInfos[0].getAreaCode());
        ntagcagcx1.put("accnbr", (Object)paymentInfos[0].getAccNo());
        ntagcagcx1.put("ccymkt", (Object)"0");
        ntagcagcx1.put("trstyp", (Object)BankBusinessConfig.getPayType(paymentInfos[0].getAccNo()));
        if (StringUtils.isEmpty((String)paymentInfos[0].getExplanation())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6458\u8981\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u94f6\u884c\u6d41\u6c34\u3002", (String)"PayPacker_11", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        ntagcagcx1.put("nusage", (Object)paymentInfos[0].getExplanation());
        if (null != paymentInfos[0].getBookingTime() && paymentInfos[0].getBookingTime().isAfter(LocalDateTime.now())) {
            ntagcagcx1.put("eptdat", (Object)paymentInfos[0].getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setBookPayFlag((PaymentInfo[])paymentInfos);
        }
        if (paymentInfos.length == 1) {
            ntagcagcx1.put("yurref", (Object)PaymentUtil.getBankDetailSeqId(paymentInfos[0]));
        } else {
            ntagcagcx1.put("yurref", (Object)PaymentUtil.getBankBatchSeqId(paymentInfos));
        }
        ntagcagcx1.put("dmanbr", (Object)(StringUtils.isEmpty((String)paymentInfos[0].getAgentAccNo()) ? "" : paymentInfos[0].getAgentAccNo()));
        if (BankBusinessConfig.isNeedChecked()) {
            ntagcagcx1.put("grtflg", (Object)"Y");
        } else {
            ntagcagcx1.put("grtflg", (Object)"N");
        }
        body.put("ntagcagcx1", (Object)ntagcagcx1);
        String bizCode = "NTAGCAPY";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }
}

