/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.oversea;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.payment.oversea.QueryOverseaPayImpl;
import kd.ebg.aqap.banks.cmb.opa.service.payment.oversea.upload.AttachmentUploadImpl;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OverseaPayImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OverseaPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String rsqt;
        try {
            rsqt = this.pack(request);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bf7\u6c42\u8fde\u63a5\u94f6\u884c\u524d\u5f02\u5e38:%s\u3002", (String)"CompanyPaymentImpl_10", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), ex.getMessage()), (Throwable)ex);
        }
        EBBankPayResponse response = null;
        try {
            String rspStr = PostUtil.sendMsgForPay(rsqt);
            response = this.parse(request, rspStr);
            return response;
        }
        catch (Throwable t) {
            EBContext.getContext().setThrowableAfterSend(t);
            EBExceiptionUtil.serviceException((Throwable)t);
            return response;
        }
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryOverseaPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String setId = "";
        try {
            setId = new AttachmentUploadImpl().uploadFile(paymentInfo);
        }
        catch (Throwable t) {
            this.logger.warn("Fail to upload the attachment files of oversea pay.", new Object[]{t});
        }
        JSONObject body = new JSONObject();
        JSONArray opertRequest = new JSONArray();
        JSONObject opertRequest1 = new JSONObject();
        opertRequest1.put("busMode", (Object)BankBusinessConfig.getOverseaPayBusmod(paymentInfo.getAccNo()));
        opertRequest1.put("transChannel", (Object)"DRT");
        opertRequest1.put("applyNo", (Object)paymentInfo.getBankDetailSeqID());
        opertRequest1.put("transType", (Object)"O");
        opertRequest1.put("remitType", (Object)"TT");
        opertRequest1.put("sendCurrency", (Object)CurrencyUtils.convert2Bank((String)paymentInfo.getPayCurrency()));
        opertRequest1.put("transAmt", (Object)paymentInfo.getActualAmount().setScale(2).toPlainString());
        boolean diffCurrency = paymentInfo.isDiffCurrency();
        if (diffCurrency) {
            opertRequest1.put("sendType", (Object)"X");
        } else {
            opertRequest1.put("sendType", (Object)"O");
        }
        opertRequest1.put("sendAccount", (Object)paymentInfo.getAccNo());
        if (diffCurrency) {
            opertRequest1.put("sendAccountCurrency", (Object)"10");
            opertRequest1.put("feeAccountCurrency", (Object)"10");
        }
        opertRequest1.put("feeAccount", (Object)paymentInfo.getAccNo());
        opertRequest1.put("remittanceAccount", (Object)paymentInfo.getIncomeAccNo());
        opertRequest1.put("remittanceName", (Object)paymentInfo.getIncomeAccName());
        CountryISOCode incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
        if (incomeIsoCode == null) {
            incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        opertRequest1.put("residentCountry", (Object)incomeIsoCode.geteChart3());
        opertRequest1.put("remittanceSwiftCode", (Object)paymentInfo.getIncomeSwiftCode());
        String feeMode = "O";
        if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "B";
        } else if ("03".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "S";
        }
        opertRequest1.put("payerType", (Object)feeMode);
        opertRequest1.put("isBondedTrans", (Object)"N");
        String clearType = "A";
        if ("1".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            clearType = "P";
        } else if ("2".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            clearType = "R";
        } else if ("3".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            clearType = "O";
        }
        opertRequest1.put("clearType", (Object)clearType);
        opertRequest1.put("transCode1", (Object)paymentInfo.getTxCode());
        opertRequest1.put("amt1", (Object)paymentInfo.getActualAmount().setScale(2).toPlainString());
        String explanation = paymentInfo.getExplanation();
        if (StringUtils.isNotEmpty((String)explanation) && explanation.length() > 50) {
            explanation = explanation.substring(0, 50);
        }
        opertRequest1.put("transMsg1", (Object)explanation);
        opertRequest1.put("contactNo", (Object)"N/A");
        opertRequest1.put("invoiceNo", (Object)"N/A");
        if (StringUtils.isNotEmpty((String)setId)) {
            opertRequest1.put("attachFileSetId", (Object)setId);
        }
        if (paymentInfo.getBookingTime() != null) {
            opertRequest1.put("expectDate", (Object)paymentInfo.getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            PaymentUtil.setBookPayFlag((List)bankPayRequest.getPaymentInfos());
        } else {
            opertRequest1.put("expectDate", (Object)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        if (StringUtils.isNotEmpty((String)paymentInfo.getApplyName())) {
            opertRequest1.put("applyName", (Object)paymentInfo.getApplyName());
        }
        if (StringUtils.isNotEmpty((String)paymentInfo.getApplyPhone())) {
            opertRequest1.put("applyPhone", (Object)paymentInfo.getApplyPhone());
        }
        opertRequest.add((Object)opertRequest1);
        body.put("opertRequest", (Object)opertRequest);
        String bizCode = this.getBizCode();
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(req, this.logger, bizCode);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (s.contains("ErrMsg")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PayParser_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)"", (String)s);
        } else {
            String res = MsgParser.getReceMsg(s, this.logger);
            BankResponse response = MsgParser.getResponse(res, this.logger);
            if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38%s", (String)"PayParser_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
            }
            JSONObject request = JSONObject.parseObject((String)res);
            JSONObject resp = request.getJSONObject("response");
            JSONObject head = resp.getJSONObject("head");
            JSONObject body = resp.getJSONObject("body");
            JSONArray array = body.getJSONArray("opertResponse");
            if (array != null && array.size() > 0) {
                JSONObject opertResponse1 = array.getJSONObject(0);
                String code = opertResponse1.getString("code");
                String message = opertResponse1.getString("message");
                String ormLgcId = opertResponse1.getString("ormLgcId");
                if ("0000".equalsIgnoreCase(code)) {
                    EBGBusinessUtils.setBankRefId((List)paymentInfos, (String)ormLgcId);
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayParser_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)code, (String)message);
                } else {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayParser_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)code, (String)message);
                }
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PayParser_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ortOperation";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

