/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.oversea.upload;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.payment.oversea.upload.DCHelper;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.business.file.AbstractAttachmentHttpImpl;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.file.PayAttachmentService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AttachmentUploadImpl
extends AbstractAttachmentHttpImpl {
    EBGLogger logger = EBGLogger.getInstance().getLogger(AttachmentUploadImpl.class);

    public String getUploadUri() {
        return "/cdcserver/upload";
    }

    public Map<String, String> getUploadBody() {
        return null;
    }

    public String getBinaryBodyName() {
        return null;
    }

    public void parseUpload(PayAttachment payAttachment, String s) {
    }

    public String pack(PayAttachment payAttachment) {
        return null;
    }

    public void parse(PayAttachment payAttachment, String s) {
    }

    public void prepareAttachmentList(List<PayAttachment> payAttachments) {
        super.prepareAttachment(payAttachments);
    }

    public String getAttachmentPath(String bankVersionId) {
        return super.getOverseaAttachmentPath(bankVersionId);
    }

    public String doUpload(List<PayAttachment> payAttachments) {
        String setId = "";
        if (BankBusinessConfig.isPreCloud()) {
            return this.uploadFileByProxy(payAttachments);
        }
        this.prepareAttachmentList(payAttachments);
        String rootPath = this.getAttachmentPath(payAttachments.get(0).getBankVersionID());
        ArrayList<String> filePathList = new ArrayList<String>(1);
        boolean isContainsChinese = false;
        for (PayAttachment payAttachment : payAttachments) {
            if (!StringUtils.containsChinese((String)payAttachment.getFileName())) {
                File file = new File(rootPath, payAttachment.getFileName());
                if (!file.exists()) continue;
                filePathList.add(file.getPath());
                continue;
            }
            isContainsChinese = true;
            break;
        }
        if (!isContainsChinese) {
            JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.genSequence());
            JSONObject body = new JSONObject();
            JSONObject request = JsonUtil.getrequest(head, body);
            String encryptData = MsgPacker.getEncryptData(request, this.logger, this.getBizCode());
            String rsp = DCHelper.sendFileMsg(encryptData, filePathList, this.getBizCode());
            setId = this.parse(MsgParser.getReceMsg(rsp, this.logger));
            for (PayAttachment payAttachment : payAttachments) {
                payAttachment.setBankRefID(setId);
            }
        } else {
            this.logger.warn(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0\u5305\u542b\u4e2d\u6587\u5b57\u7b26\uff0c\u4e0d\u7b26\u5408\u63a5\u53e3\u89c4\u8303\uff0c\u9644\u4ef6\u4e0a\u4f20\u670d\u52a1\u7ec8\u6b62\u3002", (String)"AttachmentUploadImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        return setId;
    }

    private String uploadFileByProxy(List<PayAttachment> payAttachment) {
        this.logger.warn(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u4e91\u76f4\u8fde\u6a21\u5f0f\u6682\u4e0d\u652f\u6301\u5f0f\u5883\u5916\u652f\u4ed8\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u3002", (String)"AttachmentUploadImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        return "";
    }

    public String parse(String rspStr) {
        JSONObject item;
        String setId = "";
        BankResponse response = MsgParser.getResponse(rspStr, this.logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            return setId;
        }
        JSONObject request = JSONObject.parseObject((String)rspStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        if (body == null) {
            return setId;
        }
        JSONArray fileList = body.getJSONArray("fileList");
        for (int i = 0; i < fileList.size() && !StringUtils.isNotEmpty((String)(setId = (item = fileList.getJSONObject(i)).getString("setId"))); ++i) {
        }
        return setId;
    }

    public String uploadFile(PaymentInfo paymentInfo) {
        if (StringUtils.isNotEmpty((String)paymentInfo.getFileList())) {
            String bankBatchSeqID = paymentInfo.getBankBatchSeqID();
            List payAttachments = PayAttachmentService.getInstance().findByBankBatchSeqId(bankBatchSeqID);
            if (payAttachments.size() == 0) {
                return "";
            }
            return this.doUpload(payAttachments);
        }
        return "";
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "FILUPIFS";
    }

    public String getBizDesc() {
        return "To upload the attachment files of oversea pay.";
    }
}

