/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.util;

import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.Base64;
import kd.ebg.aqap.banks.cmb.opa.util.GetStore;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignWithAES {
    static String ECB_MODE = "AES/ECB/PKCS7Padding";
    static String GCM_MODE = "AES/GCM/NoPadding";

    private static Cipher getAESCipher(String mode, SecretKeySpec key, int type) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipherInstance = null;
        try {
            if ("GCM".equalsIgnoreCase(mode)) {
                cipherInstance = Cipher.getInstance(GCM_MODE, "BC");
                cipherInstance.init(type, (Key)key, new GCMParameterSpec(128, "".getBytes()));
            } else {
                cipherInstance = Cipher.getInstance(ECB_MODE, "BC");
                cipherInstance.init(type, key);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u521d\u59cb\u5316AES Cipher\u51fa\u73b0\u5f02\u5e38\u3002", (String)"SignWithAES_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (Throwable)e);
        }
        return cipherInstance;
    }

    public static String encryptAES256Str(String content) {
        String key = GetStore.getAES();
        return Base64.encode(SignWithAES.encryptAES256(content, key.getBytes()));
    }

    public static String decryptAES256(String content) {
        String key = GetStore.getAES();
        return SignWithAES.decryptAES256(content, key.getBytes(), true);
    }

    public static byte[] encryptAES256(String content, byte[] bytePassword) {
        try {
            SecretKeySpec key = new SecretKeySpec(bytePassword, "AES");
            Cipher cipherInstance = SignWithAES.getAESCipher("ECB", key, 1);
            byte[] byteContent = content.getBytes("UTF-8");
            byte[] cryptograph = cipherInstance.doFinal(byteContent);
            return cryptograph;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
    }

    public static String decryptAES256(String content, byte[] bytePassword, boolean logError) {
        if (content == null || content.length() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u5bc6\u3002", (String)"SignWithAES_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        byte[] bContent = null;
        try {
            bContent = Base64.decode(content);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
        try {
            SecretKeySpec key = new SecretKeySpec(bytePassword, "AES");
            Cipher cipherInstance = SignWithAES.getAESCipher("ECB", key, 2);
            byte[] crypted = cipherInstance.doFinal(bContent);
            return new String(crypted, "UTF-8");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
    }
}

