/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.detail;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.banks.psbc.dc.Parser;
import kd.ebg.aqap.banks.psbc.dc.util.DomHelper;
import kd.ebg.aqap.banks.psbc.dc.util.PsbcSocketUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public boolean match(BankDetailRequest request) {
        return !BankBusinessConfig.isDetailWithPage();
    }

    public String pack(BankDetailRequest request) {
        String detailTransCode = this.getDetailTransCode();
        Element root = Packer.createReqRootElement(detailTransCode);
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Query_Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Begin_Date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"End_Date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg(xmlStr);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.checkResponse(root, ResManager.loadKDString((String)"\u5b9a\u65e5\u671f\u4ea4\u6307\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        if (!"00".equalsIgnoreCase(bankResponse.getResponseCode())) {
            if ("01".equalsIgnoreCase(bankResponse.getResponseCode())) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7(%1$s)\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u72b6\u6001[%2$s]\u3002", (String)"DetailImpl_21", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), StringUtils.catWithSpace((String[])new String[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()})));
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7(%1$s)\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001[%2$s]\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u3002", (String)"DetailImpl_22", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), StringUtils.catWithSpace((String[])new String[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()})));
        }
        Element Param = DomHelper.getChildElementNotNull(root, "Param");
        List RecordSet = Param.getChildren("RecordSet");
        if (RecordSet.size() == 0) {
            detailResponse.setDetails(new ArrayList(1));
            return detailResponse;
        }
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(16);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < RecordSet.size(); ++i) {
            try {
                DetailInfo detail;
                String Remark;
                String Usage;
                String Trans_Date;
                String Bank_Serial;
                String Flag;
                String Balance;
                String Amount;
                Element record;
                block23: {
                    record = (Element)RecordSet.get(i);
                    String Name = DomHelper.getChildTextNullAsBlank(record, "Name");
                    String Account = DomHelper.getChildTextNullAsBlank(record, "Account");
                    String Bank = DomHelper.getChildTextNullAsBlank(record, "Bank");
                    Amount = DomHelper.getChildTextNullAsBlank(record, "Amount");
                    Balance = DomHelper.getChildTextNullAsBlank(record, "Balance");
                    Flag = DomHelper.getChildTextNullAsBlank(record, "Flag");
                    Bank_Serial = DomHelper.getChildTextNullAsBlank(record, "Bank_Serial");
                    Trans_Date = DomHelper.getChildTextNullAsBlank(record, "Trans_Date");
                    String Trans_Time = DomHelper.getChildTextNullAsBlank(record, "Trans_Time");
                    Usage = DomHelper.getChildTextNullAsBlank(record, "Usage");
                    Remark = DomHelper.getChildTextNullAsBlank(record, "Remark");
                    detail = new DetailInfo();
                    detail.setAccNo(request.getAcnt().getAccNo());
                    detail.setAccName(request.getAcnt().getAccName());
                    detail.setOppAccNo(Account);
                    detail.setOppAccName(Name);
                    detail.setOppBankName(Bank);
                    detail.setCurrency(request.getBankCurrency());
                    try {
                        if (!StringUtils.isEmpty((String)Trans_Date)) {
                            if (!StringUtils.isEmpty((String)Trans_Time)) {
                                detail.setTransDate(LocalDate.parse(Trans_Date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                                detail.setTransTime(LocalDateTime.parse(Trans_Date + Trans_Time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                            } else {
                                detail.setTransDate(LocalDate.parse(Trans_Date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                                detail.setTransTime(LocalDateTime.parse(Trans_Date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                            }
                            break block23;
                        }
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u63d0\u4f9b\u8f6c\u8d26\u65e5\u671f\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u65e5\u671f\u3002", (String)"DetailImpl_16", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
                    }
                    catch (Exception e) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a%s\u3002", (String)"DetailImpl_24", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                    }
                }
                if ("1".equalsIgnoreCase(Flag)) {
                    detail.setCreditAmount(BigDecimalHelper.div((String)Amount, (String)"100.00"));
                    detail.setDebitAmount(new BigDecimal("0.00"));
                } else if ("0".equalsIgnoreCase(Flag)) {
                    detail.setCreditAmount(new BigDecimal("0.00"));
                    detail.setDebitAmount(BigDecimalHelper.div((String)Amount, (String)"100.00"));
                } else {
                    EBServiceException ex = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7:%s\u3002", (String)"DetailImpl_25", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), Flag));
                    log.error("", (Throwable)ex);
                    throw ex;
                }
                if (!"".equals(Balance)) {
                    detail.setBalance(BigDecimalHelper.div((String)Balance, (String)"100.00"));
                }
                detail.setExplanation(Usage);
                if (!StringUtils.isEmpty((String)Remark)) {
                    int index = Remark.indexOf("_KD_");
                    if (index != -1) {
                        String bankDetailSeqId = BizNoUtil.getId((String)Remark);
                        String remark = BizNoUtil.getMsg((String)Remark);
                        detail.setKdFlag(bankDetailSeqId);
                        detail.setPayBankDetailSeqID(bankDetailSeqId);
                        if (StringUtils.isEmpty((String)detail.getExplanation())) {
                            detail.setExplanation(remark);
                        }
                        DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                    } else if (StringUtils.isEmpty((String)detail.getExplanation())) {
                        detail.setExplanation(Remark);
                    }
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
                detail.setJsonMap(jsonStr);
                String accNo = request.getAcnt().getAccNo();
                String transDate = Trans_Date;
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                detail.setBankDetailNo(Bank_Serial);
                totalList.add(detail);
                continue;
            }
            catch (Exception e) {
                log.info("\u7b2c{}\u6761\u660e\u7ec6\u89e3\u6790\u5f02\u5e38\uff1a{}", new Object[]{i, e.getMessage()});
            }
        }
        detailResponse.setDetails(totalList);
        return detailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u7248\u672c\u4e8c1108\u6216\u7248\u672c\u4e092108\u3002", (String)"DetailImpl_19", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6307\u5b9a\u65e5\u671f\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_20", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }

    private String getDetailTransCode() {
        boolean isVersion3 = BankBusinessConfig.isVersion3();
        if (isVersion3) {
            return "2108";
        }
        return "1108";
    }

    public String recv(InputStream inputStream) {
        String recv = super.recv(inputStream);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recv.getBytes(RequestContextUtils.getCharset()));
            byte[] bytes = PsbcSocketUtil.readTcpByte(byteArrayInputStream, "10", RequestContextUtils.getCharset());
            return new String(bytes, RequestContextUtils.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            log.info("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6", (Object)e);
            return "";
        }
    }
}

