/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.payment.otherbank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.njb.dc.services.payment.otherbank.CompanyPayQueryImpl;
import kd.ebg.aqap.banks.njb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.njb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.njb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CompanyPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyPayQueryImpl.class;
    }

    public String getDeveloper() {
        return "zhe_zhou";
    }

    public String getBizCode() {
        return "300001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u5916\u652f\u4ed8", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ((PayTypeEnum.PAY_FOR_CAPITAL_ALLOCATION.getName().equalsIgnoreCase(paymentInfo.getSubBizType()) || UseConvertor.isTransfer((PaymentInfo)paymentInfo)) && !paymentInfo.is2SameBank()) {
            return true;
        }
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && (paymentInfo.getTotalCount() == 1 || !paymentInfo.is2Merge());
    }

    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfolist = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = new PaymentInfo[paymentInfolist.size()];
        paymentInfolist.toArray(paymentInfos);
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData2("300001", paymentInfos, "0"));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acname", (String)"");
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_type", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfos[0].getDetailSeqID());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_accaddr", (String)paymentInfos[0].getIncomeAccDept());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_no", (String)paymentInfos[0].getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfos[0].getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"bank_flag", (String)(paymentInfos[0].is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"urgency_flag", (String)(paymentInfos[0].is2Urgent() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"area_flag", (String)(paymentInfos[0].is2SameCity() ? "0" : "1"));
        if (BankBusinessConfig.isAddKDFlag().booleanValue()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo[])paymentInfos);
            String cont = BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqID(), (String)paymentInfos[0].getExplanation());
            JDomUtils.addChild((Element)body, (String)"purpose", (String)cont);
        } else {
            JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfos[0].getExplanation());
        }
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        JDomUtils.addChild((Element)body, (String)"booking_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"booking_date", (String)"");
        JDomUtils.addChild((Element)body, (String)"booking_time", (String)"");
        JDomUtils.addChild((Element)body, (String)"saverecvinfo_flag", (String)"");
        JDomUtils.addChild((Element)body, (String)"mobiles", (String)paymentInfos[0].getMobiles());
        JDomUtils.addChild((Element)body, (String)"delay_flag", (String)"0");
        String requestXml = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(requestXml);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfolist = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = new PaymentInfo[paymentInfolist.size()];
        paymentInfolist.toArray(paymentInfos);
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(s), (String)encoding);
        Element head = bank_root.getChild("head");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if ("0000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfolist);
    }
}

