/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.proxy;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.services.proxy.FrontProxy;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FileProxy
extends FrontProxy {
    public String download(String fileName) {
        String rqstStr = this.packDownload(fileName);
        EBContext.getContext().setBizName("downloadFile");
        String rspStr = this.sendAndRecvMsg(rqstStr);
        return this.parseDownload(rspStr);
    }

    public String upload(String fileName, String content) {
        String rqstStr = this.packUpload(fileName, content);
        String rspStr = this.sendAndRecvMsg(rqstStr);
        return this.parseUpload(rspStr);
    }

    private String packUpload(String fileName, String content) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = this.createHead("uploadFile");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"file", (String)fileName);
        JDomUtils.addChild((Element)reqPara, (String)"fileContent", (String)content);
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    private String parseUpload(String rspStr) {
        return this.parseDownload(rspStr);
    }

    public String packDownload(String fileName) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = this.createHead("downloadFile");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileName", (String)fileName);
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public String parseDownload(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        this.checkResponse(root);
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        return JDomUtils.getChildTextTrim((Element)rspPara, (String)"fileContent");
    }

    public void checkResponse(Element root) {
        BankResponse rsp = this.parseHeader(root);
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 [%1$s %2$s]\u3002", (String)"FileProxy_4", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"FileProxy_1", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"SUCCESS".equalsIgnoreCase(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 [%1$s %2$s]\u3002", (String)"FileProxy_4", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
    }
}

