/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bnpp.idn.services.payment;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bnpp.idn.BankBusinessConfig;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class BNPP_CommonPacker {
    public static Element packPayXmlhead(List<PaymentInfo> paymentInfos, Element CstmrCdtTrfInitn) {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element GrpHdr = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"GrpHdr").setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"MsgId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"CreDtTm", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"))).setNamespace(ns1);
        Element NbOfTxs = JDomUtils.addChild((Element)GrpHdr, (String)"NbOfTxs").setNamespace(ns1);
        NbOfTxs.addContent(String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)GrpHdr, (String)"CtrlSum").setNamespace(ns1);
        Element InitgPty = JDomUtils.addChild((Element)GrpHdr, (String)"InitgPty").setNamespace(ns1);
        JDomUtils.addChild((Element)InitgPty, (String)"Nm", (String)paymentInfo.getAccName()).setNamespace(ns1);
        return GrpHdr;
    }

    public static Element packPayXmlPmtInfo(List<PaymentInfo> paymentInfos, Element CstmrCdtTrfInitn) {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String serviceLevel = paymentInfo.getServiceLevel();
        String accNo = paymentInfo.getAccNo();
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element PmtInf = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"PmtInf").setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtInfId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtMtd", (String)"TRF").setNamespace(ns1);
        Element PmtTpInf = JDomUtils.addChild((Element)PmtInf, (String)"PmtTpInf").setNamespace(ns1);
        if ("RTGS".equalsIgnoreCase(paymentInfo.getUseCN())) {
            JDomUtils.addChild((Element)PmtTpInf, (String)"InstrPrty", (String)"HIGH").setNamespace(ns1);
        } else {
            JDomUtils.addChild((Element)PmtTpInf, (String)"InstrPrty", (String)"NORM").setNamespace(ns1);
        }
        Element SvcLvl = JDomUtils.addChild((Element)PmtTpInf, (String)"SvcLvl").setNamespace(ns1);
        JDomUtils.addChild((Element)SvcLvl, (String)"Cd", (String)serviceLevel).setNamespace(ns1);
        LocalDateTime bookingTime = paymentInfo.getBookingTime();
        if (bookingTime == null) {
            bookingTime = LocalDateTime.now();
        }
        JDomUtils.addChild((Element)PmtInf, (String)"ReqdExctnDt", (String)bookingTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).setNamespace(ns1);
        Element Dbtr = JDomUtils.addChild((Element)PmtInf, (String)"Dbtr").setNamespace(ns1);
        JDomUtils.addChild((Element)Dbtr, (String)"Nm", (String)BankBusinessConfig.getPayCompanyName(accNo)).setNamespace(ns1);
        Element DbtrAcct = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAcct").setNamespace(ns1);
        Element DbtrAcct_Id = JDomUtils.addChild((Element)DbtrAcct, (String)"Id").setNamespace(ns1);
        Element DbtrAcct_Othr = JDomUtils.addChild((Element)DbtrAcct_Id, (String)"Othr").setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct_Othr, (String)"Id", (String)accNo).setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct, (String)"Ccy", (String)paymentInfo.getCurrency()).setNamespace(ns1);
        Element DbtrAgt = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAgt").setNamespace(ns1);
        Element FinInstnId = JDomUtils.addChild((Element)DbtrAgt, (String)"FinInstnId").setNamespace(ns1);
        String bic = BankBusinessConfig.getBicCode(accNo);
        if (StringUtils.isEmpty((String)bic)) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u7684BIC swift code\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728[\u94f6\u4f01\u8d26\u6237]\u9875\u9762\u7ef4\u62a4\u3002", (String)"BNPP_CommonPacker_0", (String)"ebg-aqap-banks-bnpp-idn", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)FinInstnId, (String)"BIC", (String)bic).setNamespace(ns1);
        return PmtInf;
    }

    public static void addPurp(Element p, PaymentInfo info, Namespace namespace) {
        Element Purp = JDomUtils.addChild((Element)p, (String)"Purp").setNamespace(namespace);
        String Prtry = info.getTransactionRemarks();
        if (StringUtils.isEmpty((String)Prtry)) {
            Prtry = "20";
        }
        JDomUtils.addChild((Element)Purp, (String)"Prtry", (String)Prtry).setNamespace(namespace);
    }

    public static void addCdtrAgt(Element target, PaymentInfo info, Namespace ns1) {
        Element CdtrAgt = JDomUtils.addChild((Element)target, (String)"CdtrAgt").setNamespace(ns1);
        Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
        Element ClrSysMmbId = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"ClrSysMmbId").setNamespace(ns1);
        Element ClrSysId = JDomUtils.addChild((Element)ClrSysMmbId, (String)"ClrSysId").setNamespace(ns1);
        JDomUtils.addChild((Element)ClrSysId, (String)"Prtry", (String)"IDNCC").setNamespace(ns1);
        JDomUtils.addChild((Element)ClrSysMmbId, (String)"MmbId", (String)info.getIncomeSwiftCode()).setNamespace(ns1);
        Element PstlAdr = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"PstlAdr").setNamespace(ns1);
        JDomUtils.addChild((Element)PstlAdr, (String)"Ctry", (String)"ID").setNamespace(ns1);
    }

    public static void addDtls(Element regularReport, String tp, String cd, Namespace ns1) {
        Element dtls = JDomUtils.addChild((Element)regularReport, (String)"Dtls").setNamespace(ns1);
        JDomUtils.addChild((Element)dtls, (String)"Tp", (String)tp).setNamespace(ns1);
        JDomUtils.addChild((Element)dtls, (String)"Cd", (String)cd).setNamespace(ns1);
    }
}

