/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bnpp.idn.services.utils;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BNPPUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BNPPUtils.class);
    public static Set<String> fileNames = new HashSet<String>(2);

    public static String formatStringByLength(String message, Integer length) {
        if (StringUtils.isEmpty((String)message) && message.length() > length) {
            message = message.substring(0, length);
        }
        return message;
    }

    public static String getCountry2Code(PaymentInfo info) {
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
        if (null == code && null == (code = ISOCountryUtils.getInstance().getCountryInfoByName(info.getIncomeCountry()))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6%s\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5339\u914d\u56fd\u5bb6\u4ee3\u7801\u8868\u3002", (String)"BNPPUtils_0", (String)"ebg-aqap-banks-bnpp-idn", (Object[])new Object[0]), info.getIncomeCountry()));
        }
        return code.geteChart2();
    }

    public static String getFileName() {
        String prefix = RequestContextUtils.getBankParameterValue((String)"pay_file_name");
        String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("ddMMyy_HHmmss"));
        String preFileName = "XMLISO_" + prefix + "_";
        if (fileNames.contains(preFileName + dateTime + "d")) {
            try {
                Thread.sleep(1000L);
                dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("ddMMyy_HHmmss"));
            }
            catch (InterruptedException e) {
                logger.info("\u6253\u65ad", (Object)e);
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        String fileName = preFileName + dateTime + "d";
        fileNames.add(fileName);
        return fileName;
    }

    public static boolean processingStatus(String status) {
        HashSet statusSet = new HashSet(2);
        statusSet.addAll(Lists.newArrayList((Object[])new String[]{"ACTC", "PDNG", "ACCP", "ACSP", "ACWC"}));
        return statusSet.contains(status);
    }
}

