/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.balance.balanceCheck;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class BalanceStatementImpl
extends AbstractBalanceStatementImpl
implements IBalanceStatement {
    public int getMonthSpan() {
        return 3;
    }

    public String pack(BankBalanceStatementRequest bankBalanceStatementRequest) {
        String accNo = bankBalanceStatementRequest.getAccNo();
        Element root = JDomUtils.createRoot((String)"Transaction");
        BankUtils.createSystemHead(root, accNo);
        Element transHead = JDomUtils.addChild((Element)root, (String)"TransHead");
        JDomUtils.addChild((Element)transHead, (String)"TransCode", (String)"b2e004010");
        JDomUtils.addChild((Element)transHead, (String)"BatchID", (String)BankUtils.createBatchIDBy8ID(accNo));
        LocalDateTime now = LocalDateTime.now();
        JDomUtils.addChild((Element)transHead, (String)"JnlDate", (String)now.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)transHead, (String)"JnlTime", (String)now.format(DateTimeFormatter.ofPattern("HHmmss")));
        Element transContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element reqData1 = JDomUtils.addChild((Element)transContent, (String)"ReqData");
        JDomUtils.addChild((Element)reqData1, (String)"ClientPatchID", (String)Sequence.gen18Sequence());
        JDomUtils.addChild((Element)reqData1, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)reqData1, (String)"BeginDate", (String)(bankBalanceStatementRequest.getStartMonth() + "01"));
        LocalDate localDate = YearMonth.parse(bankBalanceStatementRequest.getEndMonth(), DateTimeFormatter.ofPattern("yyyyMM")).atEndOfMonth();
        JDomUtils.addChild((Element)reqData1, (String)"EndDate", (String)localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)reqData1, (String)"CheckFlag", (String)"1");
        JDomUtils.addChild((Element)reqData1, (String)"StartNum", (String)"1");
        JDomUtils.addChild((Element)reqData1, (String)"RequestNum", (String)"99");
        JDomUtils.addChild((Element)reqData1, (String)"RedeemType", (String)"");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest bankBalanceStatementRequest, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Namespace namespace = root.getNamespace();
        Element transContent = root.getChild("TransContent", namespace);
        String returnCode = transContent.getChildTextTrim("ReturnCode", namespace);
        String returnMsg = transContent.getChildTextTrim("ReturnMsg", namespace);
        if (!"0000".equals(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)("bankResponse is failed,reason-->" + returnMsg));
        }
        Element batchRespList = transContent.getChild("BatchRespList", namespace);
        List respData = batchRespList.getChildren("RespData", namespace);
        ArrayList<BalanceReconciliationDetail> detailList = new ArrayList<BalanceReconciliationDetail>(16);
        for (Element element : respData) {
            BalanceReconciliationDetail detail = new BalanceReconciliationDetail();
            String acctNo = element.getChildText("AcNo", namespace);
            String year = element.getChildText("Year", namespace);
            String month = element.getChildText("Month", namespace);
            String currency = element.getChildText("Currency", namespace);
            String balance = element.getChildText("Amount", namespace);
            String serviceNum = element.getChildText("ServiceNum", namespace);
            detail.setBalance(balance);
            detail.setAccNo(acctNo);
            detail.setCurrency(StringUtils.isEmpty((String)currency) ? bankBalanceStatementRequest.getCurrency() : currency);
            detail.setMonth(year + month);
            detail.setStatementNo(serviceNum);
            detail.setBiz("serviceNum", serviceNum);
            detailList.add(detail);
        }
        return new EBBankBalanceStatementResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e004010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u67e5\u8be2", (String)"BalanceStatementImpl_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceStatementRequest bankBalanceStatementRequest) {
        return true;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder sb = new StringBuilder();
        sb.append("/ent/b2e004010.do?usrID=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserID"));
        sb.append("&userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserPassword"));
        factory.setUri(sb.toString());
        return factory;
    }
}

