/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

class TodayDetailParser {
    TodayDetailParser() {
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Namespace namespace = root.getNamespace();
        BankAcnt acnt = rqst.getAcnt();
        Element transContent = root.getChild("TransContent", namespace);
        if (null == transContent) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            if (StringUtils.isEmpty((String)ReturnCode)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u51fa\u9519\uff1a\u672a\u8fd4\u56deReturnCode\u3002", (String)"TodayDetailParser_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            }
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            String error = root.getChildTextTrim("error", namespace);
            if ("EGG0521".equalsIgnoreCase(ReturnCode) || -1 != ReturnMsg.indexOf("EGG0521")) {
                return detailList;
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u51fa\u9519\uff1a[ReturnCode=%1$s,ReturnMsg=%2$s,error=%3$s]", (String)"TodayDetailParser_5", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg, error));
        }
        String returnCode = transContent.getChildTextTrim("ReturnCode", namespace);
        String returnMsg = transContent.getChildTextTrim("ReturnMsg", namespace);
        String cur = transContent.getChildTextTrim("HUOBDH", namespace);
        if (!"0000".equalsIgnoreCase(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25:%s\u3002", (String)"TodayDetailParser_6", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{returnCode, returnMsg})));
        }
        Element BatchRespList = transContent.getChild("BatchRespList", namespace);
        List localList = BatchRespList.getChildren("RespData", namespace);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (Element RespData : localList) {
            String acntNo = RespData.getChildTextTrim("ZHANGH", namespace);
            String amoutStr = RespData.getChildTextTrim("JIO1JE", namespace);
            if (StringUtils.isEmpty((String)amoutStr)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a,JIO1JE=%s", (String)"TodayDetailParser_7", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), amoutStr));
            }
            BigDecimal amout = new BigDecimal(amoutStr.trim());
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(StringUtils.isEmpty((String)cur) ? rqst.getBankCurrency() : cur);
            String debitOrCredit = RespData.getChildTextTrim("JIEDBZ", namespace);
            if ("1".equalsIgnoreCase(debitOrCredit)) {
                detail.setDebitAmount(BankUtils.ZERO);
                detail.setCreditAmount(amout);
            } else if ("0".equalsIgnoreCase(debitOrCredit)) {
                detail.setDebitAmount(amout);
                detail.setCreditAmount(BankUtils.ZERO);
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7JIEDBZ=%s\u3002", (String)"TodayDetailParser_8", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), debitOrCredit));
            }
            detail.setAccNo(acntNo);
            String toAccountNo = RespData.getChildTextTrim("DUIFZH", namespace);
            String toAccountName = RespData.getChildTextTrim("DUIFMC", namespace);
            String oppAcntBankName = RespData.getChildTextTrim("respond3", namespace);
            detail.setOppAccNo(toAccountNo);
            detail.setOppAccName(toAccountName);
            detail.setOppBankName(StringUtils.isEmpty((String)oppAcntBankName) ? "" : oppAcntBankName);
            String remark = RespData.getChildTextTrim("BEIZXX", namespace);
            String summary = RespData.getChildTextTrim("ZHYODM", namespace);
            detail.setExplanation(BizNoUtil.getMsgNullAsBlank((String)summary));
            if (summary.equalsIgnoreCase(PropertiesConstants.getValue((String)"STMTS_SSGJ")) || summary.equalsIgnoreCase(PropertiesConstants.getValue((String)"STMTS_DSGJ"))) {
                detail.markTransUp();
            } else if (summary.equalsIgnoreCase(PropertiesConstants.getValue((String)"STMTS_SSBZ")) || summary.equalsIgnoreCase(PropertiesConstants.getValue((String)"STMTS_SSXB"))) {
                detail.markTransDown();
            }
            String KDRetFlag = BizNoUtil.getIdNullAsBlank((String)summary);
            if (KDRetFlag.length() > 13) {
                KDRetFlag = KDRetFlag.substring(KDRetFlag.length() - 13);
            }
            DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)KDRetFlag);
            detail.setPayBankDetailSeqID(KDRetFlag);
            String transDate = RespData.getChildTextTrim("JIOYRQ", namespace);
            String transTime = RespData.getChildTextTrim("JIOYSJ", namespace);
            String transTimeOld = RespData.getChildTextTrim("JIOYSJ", namespace);
            LocalDateTime transDateTime = null;
            if (!StringUtils.isEmpty((String)transDate)) {
                if (StringUtils.isEmpty((String)transTime)) {
                    transDateTime = LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyyMMdd")).atStartOfDay();
                } else {
                    try {
                        transTime = StringFormater.formatLen((String)transTime, (int)6, (boolean)true, (char)'0', (String)"GBK");
                    }
                    catch (UnsupportedEncodingException e) {
                        transTime = "000000";
                    }
                    transDateTime = LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                }
            } else if (!StringUtils.isEmpty((String)transTime)) {
                try {
                    transTime = StringFormater.formatLen((String)transTime, (int)6, (boolean)true, (char)'0', (String)"GBK");
                }
                catch (UnsupportedEncodingException e) {
                    transTime = "000000";
                }
                transDateTime = LocalTime.parse(transTime, DateTimeFormatter.ofPattern("HHmmss")).atDate(LocalDate.MIN);
            }
            detail.setTransTime(transDateTime);
            detail.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            String balanceStr = RespData.getChildTextTrim("ZHHUYE", namespace);
            if (!StringUtils.isEmpty((String)balanceStr)) {
                detail.setBalance(new BigDecimal(balanceStr));
            }
            String guiyls = RespData.getChildTextTrim("GUIYLS", namespace);
            String cpznxh = RespData.getChildTextTrim("CPZNXH", namespace);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(RespData);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("Amount", (Object)amout);
            jsonObject.put("transSeqNo", (Object)guiyls);
            jsonObject.put("JIOYRQ", (Object)(StringUtils.isEmpty((String)transDate) ? detail.getTransDate().toString() : transDate));
            jsonObject.put("JIOYSJ", (Object)(StringUtils.isEmpty((String)transTimeOld) ? detail.getTransTime().toString() : transTimeOld));
            jsonObject.put("GUIYLS", (Object)guiyls);
            jsonObject.put("ZHHUYE", (Object)detail.getBalance());
            jsonObject.put("CPZNXH", (Object)cpznxh);
            jsonObject.put("ZHYODM", (Object)summary);
            jsonObject.put("BEIZXX", (Object)remark);
            String bankLoginId = EBContext.getContext().getBankLoginID();
            String bankVersionId = EBContext.getContext().getBankVersionID();
            String customerId = EBContext.getContext().getCustomID();
            BankLoginConfigKey key = new BankLoginConfigKey();
            key.setBankLoginId(bankLoginId);
            key.setBankVersionId(bankVersionId);
            key.setCustomID(customerId);
            key.setBankConfigId("receiptFileType");
            String receiptFileType = BankLoginConfigService.getInstance().getBankLoginConfigValue(key);
            if (Objects.equals(receiptFileType, "OFD")) {
                jsonObject.put("Amount", (Object)"e");
                StringBuilder transSeqNo = new StringBuilder();
                transSeqNo.append(transDate).append(guiyls);
                String seq = StringLength.fixed((String)cpznxh, (String)"0", (int)10, (boolean)false);
                transSeqNo.append(seq).append(acntNo);
                jsonObject.put("transSeqNo", (Object)transSeqNo.toString());
            }
            detail.setJsonMap(jsonObject.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(acntNo, transDate, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(guiyls);
            detailList.add(detail);
        }
        return detailList;
    }
}

