/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.allocation;

import java.util.Date;
import kd.ebg.aqap.banks.ceb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.banks.ceb.dc.utils.DateHelper;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public String packPay(PaymentInfo[] paymentInfos) {
        Element root = JDomUtils.createRoot((String)"Transaction");
        Element SystemHead = JDomUtils.addChild((Element)root, (String)"SystemHead");
        JDomUtils.addChild((Element)SystemHead, (String)"Language", (String)"zh_CN");
        JDomUtils.addChild((Element)SystemHead, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"Version", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"CifNo", (String)BankUtils.getExclusiveCifNo(paymentInfos[0].getAccNo()));
        JDomUtils.addChild((Element)SystemHead, (String)"UserID", (String)RequestContextUtils.getBankParameterValue((String)"OperatorID"));
        JDomUtils.addChild((Element)SystemHead, (String)"SyMacFlag", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"Note", (String)"");
        Element TransHead = JDomUtils.addChild((Element)root, (String)"TransHead");
        JDomUtils.addChild((Element)TransHead, (String)"TransCode", (String)"b2e006021");
        JDomUtils.addChild((Element)TransHead, (String)"BatchID", (String)paymentInfos[0].getBankBatchSeqId());
        Date now = new Date();
        JDomUtils.addChild((Element)TransHead, (String)"JnlDate", (String)DateHelper.currentDate());
        JDomUtils.addChild((Element)TransHead, (String)"JnlTime", (String)DateHelper.currentTime());
        Element TransContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element ReqData = JDomUtils.addChild((Element)TransContent, (String)"ReqData");
        PaymentInfo paymentInfo = paymentInfos[0];
        String type = "";
        if (UseConvertor.isTransfer((PaymentInfo)paymentInfo)) {
            if (UseConvertor.isTransUp((PaymentInfo)paymentInfo)) {
                type = "a";
                JDomUtils.addChild((Element)ReqData, (String)"parentAccountNo", (String)paymentInfo.getIncomeAccNo());
                JDomUtils.addChild((Element)ReqData, (String)"childAccountNo", (String)paymentInfo.getAccNo());
            } else if (UseConvertor.isTransDown((PaymentInfo)paymentInfo)) {
                type = "b";
                JDomUtils.addChild((Element)ReqData, (String)"parentAccountNo", (String)paymentInfo.getAccNo());
                JDomUtils.addChild((Element)ReqData, (String)"childAccountNo", (String)paymentInfo.getIncomeAccNo());
            }
        }
        JDomUtils.addChild((Element)ReqData, (String)"ClientPatchID", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)ReqData, (String)"type", (String)type);
        JDomUtils.addChild((Element)ReqData, (String)"Montype", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)ReqData, (String)"amount", (String)paymentInfo.getAmount().toString());
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)ReqData, (String)"memo", (String)BizNoUtil.cont((String)paymentInfo.getBankDetailSeqId(), (String)paymentInfo.getExplanation()));
        } else {
            JDomUtils.addChild((Element)ReqData, (String)"memo", (String)paymentInfo.getExplanation());
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }
}

