/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.banks.ceb.dc.utils.DateHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "b2e004003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5bf9\u516c\u652f\u4ed8\u7ed3\u679c", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"Transaction");
        Element SystemHead = JDomUtils.addChild((Element)root, (String)"SystemHead");
        JDomUtils.addChild((Element)SystemHead, (String)"Language", (String)"zh_CN");
        JDomUtils.addChild((Element)SystemHead, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"Version", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"CifNo", (String)BankUtils.getExclusiveCifNo(((PaymentInfo)paymentInfos.get(0)).getAccNo()));
        JDomUtils.addChild((Element)SystemHead, (String)"UserID", (String)RequestContextUtils.getBankParameterValue((String)"OperatorID"));
        JDomUtils.addChild((Element)SystemHead, (String)"SyMacFlag", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"Note", (String)"");
        Element TransHead = JDomUtils.addChild((Element)root, (String)"TransHead");
        JDomUtils.addChild((Element)TransHead, (String)"TransCode", (String)"b2e004003");
        JDomUtils.addChild((Element)TransHead, (String)"BatchID", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)TransHead, (String)"JnlDate", (String)DateHelper.currentDate());
        JDomUtils.addChild((Element)TransHead, (String)"JnlTime", (String)DateHelper.currentTime());
        Element TransContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element ReqData = JDomUtils.addChild((Element)TransContent, (String)"ReqData");
        JDomUtils.addChild((Element)ReqData, (String)"ClientPatchID", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)ReqData, (String)"ClientBchID", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)ReqData, (String)"ClientPchID", (String)((PaymentInfo)paymentInfos.get(0)).getBankDetailSeqId());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        Namespace namespace;
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        String error = root.getChildTextTrim("error", namespace = root.getNamespace());
        if (!StringUtils.isEmpty((String)error)) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            if (StringUtils.isEmpty((String)ReturnCode)) {
                EBGBusinessUtils.setPaymentsWithoutStauts((List)paymentInfos, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5   ", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)"", (String)error);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)ReturnCode, (String)ReturnMsg);
            }
        } else {
            Element TransContent = root.getChild("TransContent", namespace);
            String ReturnCode = TransContent.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = TransContent.getChildTextTrim("ReturnMsg", namespace);
            Element RespData = TransContent.getChild("RespData", namespace);
            String ClientPatchID = RespData.getChildTextTrim("ClientPatchID", namespace);
            String NowFlag = RespData.getChildTextTrim("NowFlag", namespace);
            String TranferFlag = RespData.getChildTextTrim("TransferFlag", namespace);
            String TransferType = RespData.getChildTextTrim("TransferType", namespace);
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)ClientPatchID);
            if (null == paymentInfo) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u987a\u5e8f\u53f7:ClientPatchID=%s\u3002", (String)"CompanyQueryPayImpl_6", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ClientPatchID));
            }
            if ("00".equalsIgnoreCase(TranferFlag)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)TranferFlag, (String)ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u5df2\u6210\u529f", (String)"CompanyQueryPayImpl_4", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            } else if ("01".equalsIgnoreCase(TranferFlag) || "05".equalsIgnoreCase(TranferFlag)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)TranferFlag, (String)ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u5931\u8d25", (String)"CompanyQueryPayImpl_5", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            } else if ("06".equalsIgnoreCase(TranferFlag) || "10".equalsIgnoreCase(TranferFlag) || "13".equalsIgnoreCase(TranferFlag) || "15".equalsIgnoreCase(TranferFlag) || "16".equalsIgnoreCase(TranferFlag) || "17".equalsIgnoreCase(TranferFlag)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)TranferFlag, (String)TransferType);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)TranferFlag, (String)TransferType);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder builder = new StringBuilder();
        builder.append("/ent/b2e004003.do").append("?userPassword=").append(RequestContextUtils.getBankParameterValue((String)"UserPassword"));
        factory.setUri(builder.toString());
        return factory;
    }
}

