/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.opa;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cib.opa.services.apply.ApplyImpl;
import kd.ebg.aqap.banks.cib.opa.services.apply.QueryApplyImpl;
import kd.ebg.aqap.banks.cib.opa.services.balance.TodayBalanceImpl;
import kd.ebg.aqap.banks.cib.opa.services.detail.DetailImpl;
import kd.ebg.aqap.banks.cib.opa.services.payment.PaymentImpl;
import kd.ebg.aqap.banks.cib.opa.services.payment.QueryPaymentImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.template.OPAMetaDataTemplate;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyFunItem;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class CibOpaMetaDateImpl
extends OPAMetaDataTemplate {
    public static final String CUST_NO = "cust_no";

    public void baseConfigInit() {
        if ("prod".equals(System.getProperty("ebg.server.env"))) {
            this.setHost("open.cibfintech.com");
            this.setPort(443);
        } else {
            this.setHost("open.test.cibfintech.com");
            this.setPort(443);
        }
        this.setExchangeProtocol("HTTPS");
        this.setCharSet("UTF-8");
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c", (String)"CibOpaMetaDateImpl_0", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
        this.setBankVersionID("CIB_OPA");
        this.setBankShortName("CIB");
        this.setBankVersionName(ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u5f00\u653e\u5e73\u53f0\u7248", (String)"CibOpaMetaDateImpl_1", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c", (String)"CibOpaMetaDateImpl_0", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c", (String)"CibOpaMetaDateImpl_0", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5174\u4e1a", (String)"CibOpaMetaDateImpl_2", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0])}));
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getBankLoginConfig((String)CUST_NO, (String)ResManager.loadKDString((String)"\u5ba2\u6237\u7535\u5b50\u6e20\u9053\u7801", (String)"CibOpaMetaDateImpl_3", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)true)});
    }

    public List<BankPropertyFunItem> getBankPropertyFunItems() {
        return Lists.newArrayList((Object[])new BankPropertyFunItem[]{BankPropertyFunItem.builder().key(BizName.DETAIL.name()).name(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"CibOpaMetaDateImpl_4", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u76f8\u5173\u7684\u63a5\u53e3\uff0c\u5305\u62ec\u5386\u53f2\u660e\u7ec6\uff0c\u5f53\u65e5\u660e\u7ec6", (String)"CibOpaMetaDateImpl_5", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0])).funStr("0302").build(), BankPropertyFunItem.builder().key(BizName.BALANCE.name()).name(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d", (String)"CibOpaMetaDateImpl_6", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u5b9e\u65f6\u4f59\u989d\u63a5\u53e3", (String)"CibOpaMetaDateImpl_7", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0])).funStr("0301").build(), BankPropertyFunItem.builder().key(BizName.PAY.name()).name(ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"CibOpaMetaDateImpl_8", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u5355\u7b14\u4ed8\u6b3e\u53ca\u67e5\u8be2\u4ed8\u6b3e\u7ed3\u679c", (String)"CibOpaMetaDateImpl_9", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0])).funStr("0101,0102").build()});
    }

    public List<BankLoginConfig> getBankLoginConfig() {
        List<BankLoginConfig> loginConfigs = super.getBankLoginConfig();
        loginConfigs = loginConfigs.stream().filter(l -> !MetaDataConfigType.PGP_CONFIG.getName().equals(l.getType())).collect(Collectors.toList());
        return loginConfigs;
    }

    public boolean showInJdy() {
        return true;
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{ApplyImpl.class, QueryApplyImpl.class, TodayBalanceImpl.class, DetailImpl.class, PaymentImpl.class, QueryPaymentImpl.class});
    }

    public Map<String, Map<String, String>> getDetailNoRule() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        HashMap<String, String> ruleMap = new HashMap<String, String>();
        ruleMap.put("accNo", "acct_no");
        ruleMap.put("transDate", "date");
        ruleMap.put("uniqueSeq", "uniqueSerialNo");
        result.put("default", ruleMap);
        return result;
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("date", DetailUniqueTypeEnum.STRING.getType());
        result.put("uniqueSerialNo", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}

