/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzrcb.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzrcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gzrcb.dc.service.GRC_DC_Packer;
import kd.ebg.aqap.banks.gzrcb.dc.service.GRC_DC_Parser;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.GzrcbFileDownloadImpl;
import kd.ebg.aqap.banks.gzrcb.dc.service.utils.DateUtil;
import kd.ebg.aqap.banks.gzrcb.dc.service.utils.PackerUtil;
import kd.ebg.aqap.banks.gzrcb.dc.service.utils.ParserUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BankResponseResult;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest request) {
        if (BankBusinessConfig.isGetDetailByFile()) {
            return this.packDetailByFile(request);
        }
        return this.packByXml(request);
    }

    public String packDetailByFile(BankDetailRequest request) throws EBServiceException {
        log.info("startDate:" + request.getStartDate() + ",endDate:" + request.getEndDate());
        Element body = PackerUtil.buildBody();
        JDomUtils.addChild((Element)body, (String)"KEHUZH", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"ZZHHXH", (String)"0001");
        JDomUtils.addChild((Element)body, (String)"HUOBDH", (String)request.getBankCurrency());
        String testTransDate = RequestContextUtils.getBankParameterValue((String)"test_transDate");
        if (!StringUtils.isEmpty((String)testTransDate)) {
            JDomUtils.addChild((Element)body, (String)"QISHRQ", (String)testTransDate);
            JDomUtils.addChild((Element)body, (String)"DAOQRQ", (String)testTransDate);
        } else {
            JDomUtils.addChild((Element)body, (String)"QISHRQ", (String)DateUtil.formatDate(DateUtil.LocalDateToDate(request.getStartDate())));
            JDomUtils.addChild((Element)body, (String)"DAOQRQ", (String)DateUtil.formatDate(DateUtil.LocalDateToDate(request.getEndDate())));
        }
        JDomUtils.addChild((Element)body, (String)"QISHBS", (String)"0000");
        JDomUtils.addChild((Element)body, (String)"CXUNBS", (String)"9999");
        JDomUtils.addChild((Element)body, (String)"JIEDBZ", (String)"");
        StringBuilder builder = new StringBuilder();
        builder.append(RequestContextUtils.getBankParameterValue((String)"userNo")).append("|").append(request.getAcnt().getAccNo());
        PackerUtil.setSignPlainText(body, builder.toString());
        return PackerUtil.getPackedStr("YQ264", PackerUtil.buildRoot(body));
    }

    private String packByXml(BankDetailRequest rqst) throws EBServiceException {
        BankAcnt bankAcnt = rqst.getAcnt();
        String transCode = "YQ263";
        Date startDate = DateUtil.LocalDateToDate(rqst.getStartDate());
        Date endDate = DateUtil.LocalDateToDate(rqst.getEndDate());
        log.info("startDate:" + startDate + ",endDate:" + endDate);
        Element root = GRC_DC_Packer.createCommHead(RequestContextUtils.getRequestContext().getBankRequestSeq());
        Element body = JDomUtils.addChild((Element)root, (String)"main_data");
        String USERID = RequestContextUtils.getBankParameterValue((String)"userNo");
        JDomUtils.addChild((Element)body, (String)"USERID", (String)RequestContextUtils.getBankParameterValue((String)"userNo"));
        JDomUtils.addChild((Element)body, (String)"KEHUZH", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"ZZHHXH", (String)"");
        JDomUtils.addChild((Element)body, (String)"HUOBDH", (String)rqst.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"QISHRQ", (String)DateUtil.formatDate(startDate));
        JDomUtils.addChild((Element)body, (String)"DAOQRQ", (String)DateUtil.formatDate(endDate));
        int page = Integer.parseInt(this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"QISHBS", (String)(page * 10 + 1 + ""));
        JDomUtils.addChild((Element)body, (String)"CXUNBS", (String)"10");
        JDomUtils.addChild((Element)body, (String)"JIEDBZ", (String)"");
        JDomUtils.addChild((Element)body, (String)"SIGDAT", (String)(USERID + "|" + bankAcnt.getAccNo()));
        return GRC_DC_Packer.covert2GRCXMLMessage(root, transCode);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String rsp) {
        if (BankBusinessConfig.isGetDetailByFile()) {
            this.setLastPage(true);
            return new EBBankDetailResponse(this.parseDetailFile(request, rsp));
        }
        return new EBBankDetailResponse(this.parseDetailXML(request, rsp));
    }

    private List<DetailInfo> parseDetailXML(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        int recordNum;
        this.setLastPage(true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String rspStrXML = rspStr.substring(rspStr.indexOf("#") + 1);
        Element root = GRC_DC_Parser.parseString2Root(rspStrXML);
        BankResponse response = GRC_DC_Parser.parseResponse(root);
        if (!"SUCCESS".equals(response.getResponseCode())) {
            log.info("\u672a\u67e5\u5230\u4ea4\u6613\u660e\u7ec6\u6216\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38");
            return detailList;
        }
        Element main_data = root.getChild("main_data");
        Element list_01 = main_data.getChild("list_01");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)list_01, (String)"ZBISHU");
        int page = Integer.parseInt(this.getCurrentPage()) + 1;
        this.setCurrentPage(page);
        if (StringUtils.isNotEmpty((String)recordNumStr)) {
            this.setLastPage(Integer.parseInt(recordNumStr) < 10 * page + 1);
        }
        if ((recordNum = Integer.parseInt(recordNumStr)) == 0) {
            return detailList;
        }
        List list = list_01.getChildren("row");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < list.size(); ++i) {
            try {
                DetailInfo detailInfo = new DetailInfo();
                Element row = (Element)list.get(i);
                String currency = ParserUtils.checkUnNullableElement((Element)row, (String)"HUOBDH");
                String dc = ParserUtils.checkUnNullableElement((Element)row, (String)"JIEDBZ");
                String amountStr = ParserUtils.checkUnNullableElement((Element)row, (String)"DAYIJE");
                String balanceStr = JDomUtils.getChildText((Element)row, (String)"ZHHUYE");
                String oppAccNo = ParserUtils.getUnNullElementTextValue((Element)row, (String)"DPACNO", (String)"");
                String oppAccName = ParserUtils.getUnNullElementTextValue((Element)row, (String)"DUIFMC", (String)"");
                String oppAccBank = ParserUtils.checkUnNullableElement((Element)row, (String)"JIGOMC");
                String explanation = ParserUtils.checkUnNullableElement((Element)row, (String)"ZHYOMS");
                String remarks = JDomUtils.getChildText((Element)row, (String)"BEIZXX");
                String transDateStr = ParserUtils.checkUnNullableElement((Element)row, (String)"JIOYRQ");
                String transTimeStr = ParserUtils.checkUnNullableElement((Element)row, (String)"JIOYSJ");
                String transDateTimeStr = transDateStr + transTimeStr;
                BigDecimal amount = null;
                if (StringUtils.isEmpty((String)amountStr)) {
                    String msg = ResManager.loadKDString((String)"\u5e7f\u5dde\u519c\u5546\u884c\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"HisDetailImpl_0", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]);
                    log.error(msg);
                    continue;
                }
                amount = new BigDecimal(amountStr.trim());
                detailInfo.setCurrency(currency);
                if ("0".equalsIgnoreCase(dc)) {
                    detailInfo.setDebitAmount(amount);
                    detailInfo.setCreditAmount(new BigDecimal("0.00"));
                } else {
                    detailInfo.setCreditAmount(amount);
                    detailInfo.setDebitAmount(new BigDecimal("0.00"));
                }
                detailInfo.setOppAccNo(oppAccNo);
                detailInfo.setOppAccName(oppAccName);
                detailInfo.setOppBankName(oppAccBank);
                detailInfo.setExplanation(explanation);
                try {
                    Date transDateTime = DateTimeUtils.parseDate((String)transDateTimeStr.trim(), (String)"yyyyMMddHHmmss");
                    detailInfo.setTransTime(DateUtil.dateTolocalDateTime(transDateTime));
                    detailInfo.setTransDate(detailInfo.getTransTime().toLocalDate());
                }
                catch (ParseException e) {
                    String msg = String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u4ea4\u6613\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38:%1$s\u3002", (String)"HisDetailImpl_3", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), e.getMessage());
                    log.error(msg);
                    continue;
                }
                if (!StringUtils.isEmpty((String)balanceStr)) {
                    detailInfo.setBalance(new BigDecimal(balanceStr.trim()));
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                detailInfo.setJsonMap(jsonStr);
                String accNo = rqst.getHeader().getAcnt().getAccNo();
                String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
                if (!StringUtils.isEmpty((String)remarks) && remarks.contains("_KD_")) {
                    String bankDetailSeqID = BizNoUtil.getId((String)remarks);
                    String explans = BizNoUtil.getMsg((String)remarks);
                    DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)bankDetailSeqID);
                    remarks = explans;
                }
                if ("ZHYOMS".equals(BankBusinessConfig.getDetailRemarks())) {
                    detailInfo.setExplanation(explanation);
                } else {
                    detailInfo.setExplanation(remarks);
                }
                detailList.add(detailInfo);
                continue;
            }
            catch (Throwable t) {
                log.error("parse detail error, continue to next.", t);
            }
        }
        return detailList;
    }

    public List<DetailInfo> parseDetailFile(BankDetailRequest request, String rsp) throws EBServiceException {
        Element body;
        String fileName;
        Element root = JDomUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
        Element header = JDomUtils.getChildElement((Element)root, (String)"comm_head");
        BankResponseResult result = ParserUtil.paserHeadResponse(header);
        List<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        if (result.isSuccess() && !StringUtils.isEmpty((String)(fileName = JDomUtils.getChildText((Element)(body = JDomUtils.getChildElement((Element)root, (String)"main_data")), (String)"FILENM")))) {
            GzrcbFileDownloadImpl util = new GzrcbFileDownloadImpl();
            String fileContent = util.downloadFile(fileName);
            detailInfos = this.parserDetailInfo(fileContent, request.getAcnt(), request.getBankCurrency());
        }
        return detailInfos;
    }

    private List<DetailInfo> parserDetailInfo(String fileContent, BankAcnt acnt, String bankCurrency) throws EBServiceException {
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
        String[] lines = StringUtils.split((String)fileContent, (String)"\n");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int j = 0; j < lines.length; ++j) {
            if (StringUtils.isEmpty((String)lines[j])) continue;
            String[] fileFragments = StringUtils.split((String)lines[j], (String)"|");
            DetailInfo info = new DetailInfo();
            info.setAccNo(fileFragments[0]);
            info.setAccName(acnt.getAccName());
            info.setOppAccNo(fileFragments[2]);
            info.setOppAccName(fileFragments[3]);
            try {
                String timeStr = fileFragments[12];
                if (timeStr.length() < 6) {
                    timeStr = StringFormater.formatLen((String)timeStr, (int)6, (boolean)true, (char)'0', (String)RequestContextUtils.getCharset());
                }
                info.setTransTime(DateUtil.dateTolocalDateTime(DateTimeUtils.parseDate((String)(fileFragments[5] + timeStr), (String)"yyyyMMddHHmmss")));
                info.setTransDate(info.getTransTime().toLocalDate());
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
                continue;
            }
            info.setOppBankName(fileFragments[14]);
            if (StringUtils.isNotEmpty((String)fileFragments[7])) {
                info.setBalance(new BigDecimal(fileFragments[7]));
            }
            info.setExplanation(fileFragments[11]);
            info.setCurrency(bankCurrency);
            BigDecimal amount = new BigDecimal(fileFragments[6]);
            String amountStr = amount.setScale(2, 4).toPlainString();
            if (amount.compareTo(PackerUtils.ZERO) >= 0) {
                info.setDebitAmount(PackerUtils.ZERO);
                info.setCreditAmount(amount);
            } else {
                info.setDebitAmount(amount.abs());
                info.setCreditAmount(PackerUtils.ZERO);
                amountStr = amount.abs().setScale(2, 4).toPlainString();
            }
            DetailSysFiled.set((DetailInfo)info, (String)"bizRefNo", (String)fileFragments[10]);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("JIOYRQ", (Object)fileFragments[5]);
            jsonObject.put("DAYIJE", (Object)amountStr);
            jsonObject.put("GUIYLS", (Object)fileFragments[10]);
            jsonObject.put("SERNUM", (Object)fileFragments[15]);
            jsonObject.put("ZHYOMS", (Object)fileFragments[11]);
            jsonObject.put("BEIZXX", (Object)fileFragments[16]);
            info.setJsonMap(jsonObject.toJSONString());
            info.setBankDetailNo(fileFragments[10]);
            String accNo = acnt.getAccNo();
            String transDate = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            info.setReceiptNo(receiptNo);
            result.add(info);
            String use = fileFragments[16];
            if (StringUtils.isEmpty((String)use) || !use.contains("_KD_")) continue;
            String bankDetailSeqID = BizNoUtil.getId((String)use);
            info.setPayBankDetailSeqID(bankDetailSeqID);
            DetailSysFiled.set((DetailInfo)info, (String)"KDRetFlag", (String)bankDetailSeqID);
        }
        return result;
    }

    public String getDeveloper() {
        return "kiki";
    }

    public String getBizCode() {
        return "YQ263,YQ264";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6", (String)"HisDetailImpl_2", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

